/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The overrides that are sent to a container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchContainerOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchContainerOverrides.Builder, BatchContainerOverrides> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Command")
            .getter(getter(BatchContainerOverrides::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchEnvironmentVariable>> ENVIRONMENT_FIELD = SdkField
            .<List<BatchEnvironmentVariable>> builder(MarshallingType.LIST)
            .memberName("Environment")
            .getter(getter(BatchContainerOverrides::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchEnvironmentVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchEnvironmentVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(BatchContainerOverrides::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<List<BatchResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<List<BatchResourceRequirement>> builder(MarshallingType.LIST)
            .memberName("ResourceRequirements")
            .getter(getter(BatchContainerOverrides::resourceRequirements))
            .setter(setter(Builder::resourceRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchResourceRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchResourceRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD,
            ENVIRONMENT_FIELD, INSTANCE_TYPE_FIELD, RESOURCE_REQUIREMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> command;

    private final List<BatchEnvironmentVariable> environment;

    private final String instanceType;

    private final List<BatchResourceRequirement> resourceRequirements;

    private BatchContainerOverrides(BuilderImpl builder) {
        this.command = builder.command;
        this.environment = builder.environment;
        this.instanceType = builder.instanceType;
        this.resourceRequirements = builder.resourceRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the Command property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command to send to the container that overrides the default command from the Docker image or the task
     * definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommand} method.
     * </p>
     * 
     * @return The command to send to the container that overrides the default command from the Docker image or the task
     *         definition.
     */
    public final List<String> command() {
        return command;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment variables to send to the container. You can add new environment variables, which are added to the
     * container at launch, or you can override the existing environment variables from the Docker image or the task
     * definition.
     * </p>
     * <note>
     * <p>
     * Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for variables
     * that Batch sets.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to send to the container. You can add new environment variables, which are
     *         added to the container at launch, or you can override the existing environment variables from the Docker
     *         image or the task definition.</p> <note>
     *         <p>
     *         Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for
     *         variables that Batch sets.
     *         </p>
     */
    public final List<BatchEnvironmentVariable> environment() {
        return environment;
    }

    /**
     * <p>
     * The instance type to use for a multi-node parallel job.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and
     * shouldn't be provided.
     * </p>
     * </note>
     * 
     * @return The instance type to use for a multi-node parallel job.</p> <note>
     *         <p>
     *         This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and
     *         shouldn't be provided.
     *         </p>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceRequirements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceRequirements() {
        return resourceRequirements != null && !(resourceRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type and amount of resources to assign to a container. This overrides the settings in the job definition. The
     * supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceRequirements} method.
     * </p>
     * 
     * @return The type and amount of resources to assign to a container. This overrides the settings in the job
     *         definition. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
     */
    public final List<BatchResourceRequirement> resourceRequirements() {
        return resourceRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceRequirements() ? resourceRequirements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchContainerOverrides)) {
            return false;
        }
        BatchContainerOverrides other = (BatchContainerOverrides) obj;
        return hasCommand() == other.hasCommand() && Objects.equals(command(), other.command())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment())
                && Objects.equals(instanceType(), other.instanceType())
                && hasResourceRequirements() == other.hasResourceRequirements()
                && Objects.equals(resourceRequirements(), other.resourceRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchContainerOverrides").add("Command", hasCommand() ? command() : null)
                .add("Environment", hasEnvironment() ? environment() : null).add("InstanceType", instanceType())
                .add("ResourceRequirements", hasResourceRequirements() ? resourceRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "ResourceRequirements":
            return Optional.ofNullable(clazz.cast(resourceRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Command", COMMAND_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("ResourceRequirements", RESOURCE_REQUIREMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchContainerOverrides, T> g) {
        return obj -> g.apply((BatchContainerOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchContainerOverrides> {
        /**
         * <p>
         * The command to send to the container that overrides the default command from the Docker image or the task
         * definition.
         * </p>
         * 
         * @param command
         *        The command to send to the container that overrides the default command from the Docker image or the
         *        task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command to send to the container that overrides the default command from the Docker image or the task
         * definition.
         * </p>
         * 
         * @param command
         *        The command to send to the container that overrides the default command from the Docker image or the
         *        task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The environment variables to send to the container. You can add new environment variables, which are added to
         * the container at launch, or you can override the existing environment variables from the Docker image or the
         * task definition.
         * </p>
         * <note>
         * <p>
         * Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for
         * variables that Batch sets.
         * </p>
         * </note>
         * 
         * @param environment
         *        The environment variables to send to the container. You can add new environment variables, which are
         *        added to the container at launch, or you can override the existing environment variables from the
         *        Docker image or the task definition.</p> <note>
         *        <p>
         *        Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for
         *        variables that Batch sets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<BatchEnvironmentVariable> environment);

        /**
         * <p>
         * The environment variables to send to the container. You can add new environment variables, which are added to
         * the container at launch, or you can override the existing environment variables from the Docker image or the
         * task definition.
         * </p>
         * <note>
         * <p>
         * Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for
         * variables that Batch sets.
         * </p>
         * </note>
         * 
         * @param environment
         *        The environment variables to send to the container. You can add new environment variables, which are
         *        added to the container at launch, or you can override the existing environment variables from the
         *        Docker image or the task definition.</p> <note>
         *        <p>
         *        Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for
         *        variables that Batch sets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(BatchEnvironmentVariable... environment);

        /**
         * <p>
         * The environment variables to send to the container. You can add new environment variables, which are added to
         * the container at launch, or you can override the existing environment variables from the Docker image or the
         * task definition.
         * </p>
         * <note>
         * <p>
         * Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for
         * variables that Batch sets.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.BatchEnvironmentVariable.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pipes.model.BatchEnvironmentVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.BatchEnvironmentVariable.Builder#build()} is called
         * immediately and its result is passed to {@link #environment(List<BatchEnvironmentVariable>)}.
         * 
         * @param environment
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.BatchEnvironmentVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(java.util.Collection<BatchEnvironmentVariable>)
         */
        Builder environment(Consumer<BatchEnvironmentVariable.Builder>... environment);

        /**
         * <p>
         * The instance type to use for a multi-node parallel job.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and
         * shouldn't be provided.
         * </p>
         * </note>
         * 
         * @param instanceType
         *        The instance type to use for a multi-node parallel job.</p> <note>
         *        <p>
         *        This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources,
         *        and shouldn't be provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type and amount of resources to assign to a container. This overrides the settings in the job definition.
         * The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of resources to assign to a container. This overrides the settings in the job
         *        definition. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and
         *        <code>VCPU</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(Collection<BatchResourceRequirement> resourceRequirements);

        /**
         * <p>
         * The type and amount of resources to assign to a container. This overrides the settings in the job definition.
         * The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of resources to assign to a container. This overrides the settings in the job
         *        definition. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and
         *        <code>VCPU</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(BatchResourceRequirement... resourceRequirements);

        /**
         * <p>
         * The type and amount of resources to assign to a container. This overrides the settings in the job definition.
         * The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.BatchResourceRequirement.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pipes.model.BatchResourceRequirement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.BatchResourceRequirement.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceRequirements(List<BatchResourceRequirement>)}.
         * 
         * @param resourceRequirements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.BatchResourceRequirement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRequirements(java.util.Collection<BatchResourceRequirement>)
         */
        Builder resourceRequirements(Consumer<BatchResourceRequirement.Builder>... resourceRequirements);
    }

    static final class BuilderImpl implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private List<BatchEnvironmentVariable> environment = DefaultSdkAutoConstructList.getInstance();

        private String instanceType;

        private List<BatchResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchContainerOverrides model) {
            command(model.command);
            environment(model.environment);
            instanceType(model.instanceType);
            resourceRequirements(model.resourceRequirements);
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final List<BatchEnvironmentVariable.Builder> getEnvironment() {
            List<BatchEnvironmentVariable.Builder> result = BatchEnvironmentVariableListCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<BatchEnvironmentVariable.BuilderImpl> environment) {
            this.environment = BatchEnvironmentVariableListCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<BatchEnvironmentVariable> environment) {
            this.environment = BatchEnvironmentVariableListCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(BatchEnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<BatchEnvironmentVariable.Builder>... environment) {
            environment(Stream.of(environment).map(c -> BatchEnvironmentVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<BatchResourceRequirement.Builder> getResourceRequirements() {
            List<BatchResourceRequirement.Builder> result = BatchResourceRequirementsListCopier
                    .copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<BatchResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = BatchResourceRequirementsListCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<BatchResourceRequirement> resourceRequirements) {
            this.resourceRequirements = BatchResourceRequirementsListCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(BatchResourceRequirement... resourceRequirements) {
            resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<BatchResourceRequirement.Builder>... resourceRequirements) {
            resourceRequirements(Stream.of(resourceRequirements)
                    .map(c -> BatchResourceRequirement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchContainerOverrides build() {
            return new BatchContainerOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
