/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipesRequest extends PipesRequest implements ToCopyableBuilder<ListPipesRequest.Builder, ListPipesRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(ListPipesRequest::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NamePrefix").build()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(ListPipesRequest::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DesiredState").build()).build();

    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentState").getter(getter(ListPipesRequest::currentStateAsString))
            .setter(setter(Builder::currentState))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CurrentState").build()).build();

    private static final SdkField<String> SOURCE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePrefix").getter(getter(ListPipesRequest::sourcePrefix)).setter(setter(Builder::sourcePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SourcePrefix").build()).build();

    private static final SdkField<String> TARGET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetPrefix").getter(getter(ListPipesRequest::targetPrefix)).setter(setter(Builder::targetPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TargetPrefix").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListPipesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD,
            DESIRED_STATE_FIELD, CURRENT_STATE_FIELD, SOURCE_PREFIX_FIELD, TARGET_PREFIX_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String namePrefix;

    private final String desiredState;

    private final String currentState;

    private final String sourcePrefix;

    private final String targetPrefix;

    private final String nextToken;

    private final Integer limit;

    private ListPipesRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
        this.sourcePrefix = builder.sourcePrefix;
        this.targetPrefix = builder.targetPrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * A value that will return a subset of the pipes associated with this account. For example,
     * <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
     * </p>
     * 
     * @return A value that will return a subset of the pipes associated with this account. For example,
     *         <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
     */
    public final String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeState
     */
    public final RequestedPipeState desiredState() {
        return RequestedPipeState.fromValue(desiredState);
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The state the pipe is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link PipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The state the pipe is in.
     * @see PipeState
     */
    public final PipeState currentState() {
        return PipeState.fromValue(currentState);
    }

    /**
     * <p>
     * The state the pipe is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link PipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The state the pipe is in.
     * @see PipeState
     */
    public final String currentStateAsString() {
        return currentState;
    }

    /**
     * <p>
     * The prefix matching the pipe source.
     * </p>
     * 
     * @return The prefix matching the pipe source.
     */
    public final String sourcePrefix() {
        return sourcePrefix;
    }

    /**
     * <p>
     * The prefix matching the pipe target.
     * </p>
     * 
     * @return The prefix matching the pipe target.
     */
    public final String targetPrefix() {
        return targetPrefix;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an HTTP 400 InvalidToken error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of pipes to include in the response.
     * </p>
     * 
     * @return The maximum number of pipes to include in the response.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(targetPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipesRequest)) {
            return false;
        }
        ListPipesRequest other = (ListPipesRequest) obj;
        return Objects.equals(namePrefix(), other.namePrefix())
                && Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(currentStateAsString(), other.currentStateAsString())
                && Objects.equals(sourcePrefix(), other.sourcePrefix()) && Objects.equals(targetPrefix(), other.targetPrefix())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipesRequest").add("NamePrefix", namePrefix()).add("DesiredState", desiredStateAsString())
                .add("CurrentState", currentStateAsString()).add("SourcePrefix", sourcePrefix())
                .add("TargetPrefix", targetPrefix())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "CurrentState":
            return Optional.ofNullable(clazz.cast(currentStateAsString()));
        case "SourcePrefix":
            return Optional.ofNullable(clazz.cast(sourcePrefix()));
        case "TargetPrefix":
            return Optional.ofNullable(clazz.cast(targetPrefix()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("CurrentState", CURRENT_STATE_FIELD);
        map.put("SourcePrefix", SOURCE_PREFIX_FIELD);
        map.put("TargetPrefix", TARGET_PREFIX_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipesRequest, T> g) {
        return obj -> g.apply((ListPipesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PipesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPipesRequest> {
        /**
         * <p>
         * A value that will return a subset of the pipes associated with this account. For example,
         * <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
         * </p>
         * 
         * @param namePrefix
         *        A value that will return a subset of the pipes associated with this account. For example,
         *        <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeState
         */
        Builder desiredState(RequestedPipeState desiredState);

        /**
         * <p>
         * The state the pipe is in.
         * </p>
         * 
         * @param currentState
         *        The state the pipe is in.
         * @see PipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeState
         */
        Builder currentState(String currentState);

        /**
         * <p>
         * The state the pipe is in.
         * </p>
         * 
         * @param currentState
         *        The state the pipe is in.
         * @see PipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeState
         */
        Builder currentState(PipeState currentState);

        /**
         * <p>
         * The prefix matching the pipe source.
         * </p>
         * 
         * @param sourcePrefix
         *        The prefix matching the pipe source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePrefix(String sourcePrefix);

        /**
         * <p>
         * The prefix matching the pipe target.
         * </p>
         * 
         * @param targetPrefix
         *        The prefix matching the pipe target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPrefix(String targetPrefix);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an HTTP 400 InvalidToken error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of pipes to include in the response.
         * </p>
         * 
         * @param limit
         *        The maximum number of pipes to include in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PipesRequest.BuilderImpl implements Builder {
        private String namePrefix;

        private String desiredState;

        private String currentState;

        private String sourcePrefix;

        private String targetPrefix;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipesRequest model) {
            super(model);
            namePrefix(model.namePrefix);
            desiredState(model.desiredState);
            currentState(model.currentState);
            sourcePrefix(model.sourcePrefix);
            targetPrefix(model.targetPrefix);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getSourcePrefix() {
            return sourcePrefix;
        }

        public final void setSourcePrefix(String sourcePrefix) {
            this.sourcePrefix = sourcePrefix;
        }

        @Override
        public final Builder sourcePrefix(String sourcePrefix) {
            this.sourcePrefix = sourcePrefix;
            return this;
        }

        public final String getTargetPrefix() {
            return targetPrefix;
        }

        public final void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        @Override
        public final Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPipesRequest build() {
            return new ListPipesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
