/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a Rabbit MQ broker as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeSourceRabbitMQBrokerParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeSourceRabbitMQBrokerParameters.Builder, PipeSourceRabbitMQBrokerParameters> {
    private static final SdkField<MQBrokerAccessCredentials> CREDENTIALS_FIELD = SdkField
            .<MQBrokerAccessCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(PipeSourceRabbitMQBrokerParameters::credentials)).setter(setter(Builder::credentials))
            .constructor(MQBrokerAccessCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueName").getter(getter(PipeSourceRabbitMQBrokerParameters::queueName))
            .setter(setter(Builder::queueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()).build();

    private static final SdkField<String> VIRTUAL_HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualHost").getter(getter(PipeSourceRabbitMQBrokerParameters::virtualHost))
            .setter(setter(Builder::virtualHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualHost").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(PipeSourceRabbitMQBrokerParameters::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(PipeSourceRabbitMQBrokerParameters::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            QUEUE_NAME_FIELD, VIRTUAL_HOST_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MQBrokerAccessCredentials credentials;

    private final String queueName;

    private final String virtualHost;

    private final Integer batchSize;

    private final Integer maximumBatchingWindowInSeconds;

    private PipeSourceRabbitMQBrokerParameters(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.queueName = builder.queueName;
        this.virtualHost = builder.virtualHost;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * The credentials needed to access the resource.
     * </p>
     * 
     * @return The credentials needed to access the resource.
     */
    public final MQBrokerAccessCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The name of the destination queue to consume.
     * </p>
     * 
     * @return The name of the destination queue to consume.
     */
    public final String queueName() {
        return queueName;
    }

    /**
     * <p>
     * The name of the virtual host associated with the source broker.
     * </p>
     * 
     * @return The name of the virtual host associated with the source broker.
     */
    public final String virtualHost() {
        return virtualHost;
    }

    /**
     * <p>
     * The maximum number of records to include in each batch.
     * </p>
     * 
     * @return The maximum number of records to include in each batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The maximum length of a time to wait for events.
     * </p>
     * 
     * @return The maximum length of a time to wait for events.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode + Objects.hashCode(virtualHost());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceRabbitMQBrokerParameters)) {
            return false;
        }
        PipeSourceRabbitMQBrokerParameters other = (PipeSourceRabbitMQBrokerParameters) obj;
        return Objects.equals(credentials(), other.credentials()) && Objects.equals(queueName(), other.queueName())
                && Objects.equals(virtualHost(), other.virtualHost()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeSourceRabbitMQBrokerParameters").add("Credentials", credentials())
                .add("QueueName", queueName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VirtualHost", virtualHost() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BatchSize", batchSize()).add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "QueueName":
            return Optional.ofNullable(clazz.cast(queueName()));
        case "VirtualHost":
            return Optional.ofNullable(clazz.cast(virtualHost()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("QueueName", QUEUE_NAME_FIELD);
        map.put("VirtualHost", VIRTUAL_HOST_FIELD);
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceRabbitMQBrokerParameters, T> g) {
        return obj -> g.apply((PipeSourceRabbitMQBrokerParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeSourceRabbitMQBrokerParameters> {
        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * 
         * @param credentials
         *        The credentials needed to access the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(MQBrokerAccessCredentials credentials);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link MQBrokerAccessCredentials.Builder}
         * avoiding the need to create one manually via {@link MQBrokerAccessCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MQBrokerAccessCredentials.Builder#build()} is called immediately
         * and its result is passed to {@link #credentials(MQBrokerAccessCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link MQBrokerAccessCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(MQBrokerAccessCredentials)
         */
        default Builder credentials(Consumer<MQBrokerAccessCredentials.Builder> credentials) {
            return credentials(MQBrokerAccessCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The name of the destination queue to consume.
         * </p>
         * 
         * @param queueName
         *        The name of the destination queue to consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The name of the virtual host associated with the source broker.
         * </p>
         * 
         * @param virtualHost
         *        The name of the virtual host associated with the source broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualHost(String virtualHost);

        /**
         * <p>
         * The maximum number of records to include in each batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records to include in each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The maximum length of a time to wait for events.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum length of a time to wait for events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private MQBrokerAccessCredentials credentials;

        private String queueName;

        private String virtualHost;

        private Integer batchSize;

        private Integer maximumBatchingWindowInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceRabbitMQBrokerParameters model) {
            credentials(model.credentials);
            queueName(model.queueName);
            virtualHost(model.virtualHost);
            batchSize(model.batchSize);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
        }

        public final MQBrokerAccessCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(MQBrokerAccessCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(MQBrokerAccessCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getQueueName() {
            return queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final String getVirtualHost() {
            return virtualHost;
        }

        public final void setVirtualHost(String virtualHost) {
            this.virtualHost = virtualHost;
        }

        @Override
        public final Builder virtualHost(String virtualHost) {
            this.virtualHost = virtualHost;
            return this;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        @Override
        public PipeSourceRabbitMQBrokerParameters build() {
            return new PipeSourceRabbitMQBrokerParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
