/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters required to set up a source for your pipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipeSourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatePipeSourceParameters.Builder, UpdatePipeSourceParameters> {
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(UpdatePipeSourceParameters::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()).build();

    private static final SdkField<UpdatePipeSourceKinesisStreamParameters> KINESIS_STREAM_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceKinesisStreamParameters> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamParameters")
            .getter(getter(UpdatePipeSourceParameters::kinesisStreamParameters)).setter(setter(Builder::kinesisStreamParameters))
            .constructor(UpdatePipeSourceKinesisStreamParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamParameters").build())
            .build();

    private static final SdkField<UpdatePipeSourceDynamoDBStreamParameters> DYNAMO_DB_STREAM_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceDynamoDBStreamParameters> builder(MarshallingType.SDK_POJO).memberName("DynamoDBStreamParameters")
            .getter(getter(UpdatePipeSourceParameters::dynamoDBStreamParameters))
            .setter(setter(Builder::dynamoDBStreamParameters)).constructor(UpdatePipeSourceDynamoDBStreamParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBStreamParameters").build())
            .build();

    private static final SdkField<UpdatePipeSourceSqsQueueParameters> SQS_QUEUE_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceSqsQueueParameters> builder(MarshallingType.SDK_POJO).memberName("SqsQueueParameters")
            .getter(getter(UpdatePipeSourceParameters::sqsQueueParameters)).setter(setter(Builder::sqsQueueParameters))
            .constructor(UpdatePipeSourceSqsQueueParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueParameters").build())
            .build();

    private static final SdkField<UpdatePipeSourceActiveMQBrokerParameters> ACTIVE_MQ_BROKER_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceActiveMQBrokerParameters> builder(MarshallingType.SDK_POJO).memberName("ActiveMQBrokerParameters")
            .getter(getter(UpdatePipeSourceParameters::activeMQBrokerParameters))
            .setter(setter(Builder::activeMQBrokerParameters)).constructor(UpdatePipeSourceActiveMQBrokerParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveMQBrokerParameters").build())
            .build();

    private static final SdkField<UpdatePipeSourceRabbitMQBrokerParameters> RABBIT_MQ_BROKER_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceRabbitMQBrokerParameters> builder(MarshallingType.SDK_POJO).memberName("RabbitMQBrokerParameters")
            .getter(getter(UpdatePipeSourceParameters::rabbitMQBrokerParameters))
            .setter(setter(Builder::rabbitMQBrokerParameters)).constructor(UpdatePipeSourceRabbitMQBrokerParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RabbitMQBrokerParameters").build())
            .build();

    private static final SdkField<UpdatePipeSourceManagedStreamingKafkaParameters> MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceManagedStreamingKafkaParameters> builder(MarshallingType.SDK_POJO)
            .memberName("ManagedStreamingKafkaParameters")
            .getter(getter(UpdatePipeSourceParameters::managedStreamingKafkaParameters))
            .setter(setter(Builder::managedStreamingKafkaParameters))
            .constructor(UpdatePipeSourceManagedStreamingKafkaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedStreamingKafkaParameters")
                    .build()).build();

    private static final SdkField<UpdatePipeSourceSelfManagedKafkaParameters> SELF_MANAGED_KAFKA_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceSelfManagedKafkaParameters> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedKafkaParameters")
            .getter(getter(UpdatePipeSourceParameters::selfManagedKafkaParameters))
            .setter(setter(Builder::selfManagedKafkaParameters))
            .constructor(UpdatePipeSourceSelfManagedKafkaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD,
            KINESIS_STREAM_PARAMETERS_FIELD, DYNAMO_DB_STREAM_PARAMETERS_FIELD, SQS_QUEUE_PARAMETERS_FIELD,
            ACTIVE_MQ_BROKER_PARAMETERS_FIELD, RABBIT_MQ_BROKER_PARAMETERS_FIELD, MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD,
            SELF_MANAGED_KAFKA_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FilterCriteria filterCriteria;

    private final UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters;

    private final UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;

    private final UpdatePipeSourceSqsQueueParameters sqsQueueParameters;

    private final UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters;

    private final UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;

    private final UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;

    private final UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

    private UpdatePipeSourceParameters(BuilderImpl builder) {
        this.filterCriteria = builder.filterCriteria;
        this.kinesisStreamParameters = builder.kinesisStreamParameters;
        this.dynamoDBStreamParameters = builder.dynamoDBStreamParameters;
        this.sqsQueueParameters = builder.sqsQueueParameters;
        this.activeMQBrokerParameters = builder.activeMQBrokerParameters;
        this.rabbitMQBrokerParameters = builder.rabbitMQBrokerParameters;
        this.managedStreamingKafkaParameters = builder.managedStreamingKafkaParameters;
        this.selfManagedKafkaParameters = builder.selfManagedKafkaParameters;
    }

    /**
     * <p>
     * The collection of event patterns used to filter events.
     * </p>
     * <p>
     * To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code>
     * objects.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and
     * Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The collection of event patterns used to filter events.</p>
     *         <p>
     *         To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of
     *         <code>Filter</code> objects.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
     *         >Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The parameters for using a Kinesis stream as a source.
     * </p>
     * 
     * @return The parameters for using a Kinesis stream as a source.
     */
    public final UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters() {
        return kinesisStreamParameters;
    }

    /**
     * <p>
     * The parameters for using a DynamoDB stream as a source.
     * </p>
     * 
     * @return The parameters for using a DynamoDB stream as a source.
     */
    public final UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters() {
        return dynamoDBStreamParameters;
    }

    /**
     * <p>
     * The parameters for using a Amazon SQS stream as a source.
     * </p>
     * 
     * @return The parameters for using a Amazon SQS stream as a source.
     */
    public final UpdatePipeSourceSqsQueueParameters sqsQueueParameters() {
        return sqsQueueParameters;
    }

    /**
     * <p>
     * The parameters for using an Active MQ broker as a source.
     * </p>
     * 
     * @return The parameters for using an Active MQ broker as a source.
     */
    public final UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters() {
        return activeMQBrokerParameters;
    }

    /**
     * <p>
     * The parameters for using a Rabbit MQ broker as a source.
     * </p>
     * 
     * @return The parameters for using a Rabbit MQ broker as a source.
     */
    public final UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters() {
        return rabbitMQBrokerParameters;
    }

    /**
     * <p>
     * The parameters for using an MSK stream as a source.
     * </p>
     * 
     * @return The parameters for using an MSK stream as a source.
     */
    public final UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters() {
        return managedStreamingKafkaParameters;
    }

    /**
     * <p>
     * The parameters for using a self-managed Apache Kafka stream as a source.
     * </p>
     * <p>
     * A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This includes
     * both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
     * href="https://www.confluent.io/">Confluent Cloud</a>, <a href="https://www.cloudkarafka.com/">CloudKarafka</a>,
     * or <a href="https://redpanda.com/">Redpanda</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a
     * source</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The parameters for using a self-managed Apache Kafka stream as a source.</p>
     *         <p>
     *         A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This
     *         includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
     *         href="https://www.confluent.io/">Confluent Cloud</a>, <a
     *         href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams
     *         as a source</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters() {
        return selfManagedKafkaParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueueParameters());
        hashCode = 31 * hashCode + Objects.hashCode(activeMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(rabbitMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(managedStreamingKafkaParameters());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedKafkaParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceParameters)) {
            return false;
        }
        UpdatePipeSourceParameters other = (UpdatePipeSourceParameters) obj;
        return Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(kinesisStreamParameters(), other.kinesisStreamParameters())
                && Objects.equals(dynamoDBStreamParameters(), other.dynamoDBStreamParameters())
                && Objects.equals(sqsQueueParameters(), other.sqsQueueParameters())
                && Objects.equals(activeMQBrokerParameters(), other.activeMQBrokerParameters())
                && Objects.equals(rabbitMQBrokerParameters(), other.rabbitMQBrokerParameters())
                && Objects.equals(managedStreamingKafkaParameters(), other.managedStreamingKafkaParameters())
                && Objects.equals(selfManagedKafkaParameters(), other.selfManagedKafkaParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipeSourceParameters").add("FilterCriteria", filterCriteria())
                .add("KinesisStreamParameters", kinesisStreamParameters())
                .add("DynamoDBStreamParameters", dynamoDBStreamParameters()).add("SqsQueueParameters", sqsQueueParameters())
                .add("ActiveMQBrokerParameters", activeMQBrokerParameters())
                .add("RabbitMQBrokerParameters", rabbitMQBrokerParameters())
                .add("ManagedStreamingKafkaParameters", managedStreamingKafkaParameters())
                .add("SelfManagedKafkaParameters", selfManagedKafkaParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "KinesisStreamParameters":
            return Optional.ofNullable(clazz.cast(kinesisStreamParameters()));
        case "DynamoDBStreamParameters":
            return Optional.ofNullable(clazz.cast(dynamoDBStreamParameters()));
        case "SqsQueueParameters":
            return Optional.ofNullable(clazz.cast(sqsQueueParameters()));
        case "ActiveMQBrokerParameters":
            return Optional.ofNullable(clazz.cast(activeMQBrokerParameters()));
        case "RabbitMQBrokerParameters":
            return Optional.ofNullable(clazz.cast(rabbitMQBrokerParameters()));
        case "ManagedStreamingKafkaParameters":
            return Optional.ofNullable(clazz.cast(managedStreamingKafkaParameters()));
        case "SelfManagedKafkaParameters":
            return Optional.ofNullable(clazz.cast(selfManagedKafkaParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterCriteria", FILTER_CRITERIA_FIELD);
        map.put("KinesisStreamParameters", KINESIS_STREAM_PARAMETERS_FIELD);
        map.put("DynamoDBStreamParameters", DYNAMO_DB_STREAM_PARAMETERS_FIELD);
        map.put("SqsQueueParameters", SQS_QUEUE_PARAMETERS_FIELD);
        map.put("ActiveMQBrokerParameters", ACTIVE_MQ_BROKER_PARAMETERS_FIELD);
        map.put("RabbitMQBrokerParameters", RABBIT_MQ_BROKER_PARAMETERS_FIELD);
        map.put("ManagedStreamingKafkaParameters", MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD);
        map.put("SelfManagedKafkaParameters", SELF_MANAGED_KAFKA_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePipeSourceParameters> {
        /**
         * <p>
         * The collection of event patterns used to filter events.
         * </p>
         * <p>
         * To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code>
         * objects.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
         * and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param filterCriteria
         *        The collection of event patterns used to filter events.</p>
         *        <p>
         *        To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of
         *        <code>Filter</code> objects.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
         *        >Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * The collection of event patterns used to filter events.
         * </p>
         * <p>
         * To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code>
         * objects.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
         * and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The parameters for using a Kinesis stream as a source.
         * </p>
         * 
         * @param kinesisStreamParameters
         *        The parameters for using a Kinesis stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters);

        /**
         * <p>
         * The parameters for using a Kinesis stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceKinesisStreamParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceKinesisStreamParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceKinesisStreamParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters)}.
         * 
         * @param kinesisStreamParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceKinesisStreamParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters)
         */
        default Builder kinesisStreamParameters(Consumer<UpdatePipeSourceKinesisStreamParameters.Builder> kinesisStreamParameters) {
            return kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters.builder()
                    .applyMutation(kinesisStreamParameters).build());
        }

        /**
         * <p>
         * The parameters for using a DynamoDB stream as a source.
         * </p>
         * 
         * @param dynamoDBStreamParameters
         *        The parameters for using a DynamoDB stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters);

        /**
         * <p>
         * The parameters for using a DynamoDB stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceDynamoDBStreamParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceDynamoDBStreamParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceDynamoDBStreamParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters)}.
         * 
         * @param dynamoDBStreamParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceDynamoDBStreamParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters)
         */
        default Builder dynamoDBStreamParameters(
                Consumer<UpdatePipeSourceDynamoDBStreamParameters.Builder> dynamoDBStreamParameters) {
            return dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters.builder()
                    .applyMutation(dynamoDBStreamParameters).build());
        }

        /**
         * <p>
         * The parameters for using a Amazon SQS stream as a source.
         * </p>
         * 
         * @param sqsQueueParameters
         *        The parameters for using a Amazon SQS stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueueParameters(UpdatePipeSourceSqsQueueParameters sqsQueueParameters);

        /**
         * <p>
         * The parameters for using a Amazon SQS stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceSqsQueueParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceSqsQueueParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceSqsQueueParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sqsQueueParameters(UpdatePipeSourceSqsQueueParameters)}.
         * 
         * @param sqsQueueParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceSqsQueueParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsQueueParameters(UpdatePipeSourceSqsQueueParameters)
         */
        default Builder sqsQueueParameters(Consumer<UpdatePipeSourceSqsQueueParameters.Builder> sqsQueueParameters) {
            return sqsQueueParameters(UpdatePipeSourceSqsQueueParameters.builder().applyMutation(sqsQueueParameters).build());
        }

        /**
         * <p>
         * The parameters for using an Active MQ broker as a source.
         * </p>
         * 
         * @param activeMQBrokerParameters
         *        The parameters for using an Active MQ broker as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters);

        /**
         * <p>
         * The parameters for using an Active MQ broker as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceActiveMQBrokerParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceActiveMQBrokerParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceActiveMQBrokerParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters)}.
         * 
         * @param activeMQBrokerParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceActiveMQBrokerParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters)
         */
        default Builder activeMQBrokerParameters(
                Consumer<UpdatePipeSourceActiveMQBrokerParameters.Builder> activeMQBrokerParameters) {
            return activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters.builder()
                    .applyMutation(activeMQBrokerParameters).build());
        }

        /**
         * <p>
         * The parameters for using a Rabbit MQ broker as a source.
         * </p>
         * 
         * @param rabbitMQBrokerParameters
         *        The parameters for using a Rabbit MQ broker as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters);

        /**
         * <p>
         * The parameters for using a Rabbit MQ broker as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceRabbitMQBrokerParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceRabbitMQBrokerParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceRabbitMQBrokerParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters)}.
         * 
         * @param rabbitMQBrokerParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceRabbitMQBrokerParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters)
         */
        default Builder rabbitMQBrokerParameters(
                Consumer<UpdatePipeSourceRabbitMQBrokerParameters.Builder> rabbitMQBrokerParameters) {
            return rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters.builder()
                    .applyMutation(rabbitMQBrokerParameters).build());
        }

        /**
         * <p>
         * The parameters for using an MSK stream as a source.
         * </p>
         * 
         * @param managedStreamingKafkaParameters
         *        The parameters for using an MSK stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters);

        /**
         * <p>
         * The parameters for using an MSK stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceManagedStreamingKafkaParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceManagedStreamingKafkaParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceManagedStreamingKafkaParameters.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #managedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters)}.
         * 
         * @param managedStreamingKafkaParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceManagedStreamingKafkaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters)
         */
        default Builder managedStreamingKafkaParameters(
                Consumer<UpdatePipeSourceManagedStreamingKafkaParameters.Builder> managedStreamingKafkaParameters) {
            return managedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters.builder()
                    .applyMutation(managedStreamingKafkaParameters).build());
        }

        /**
         * <p>
         * The parameters for using a self-managed Apache Kafka stream as a source.
         * </p>
         * <p>
         * A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This
         * includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
         * href="https://www.confluent.io/">Confluent Cloud</a>, <a
         * href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a
         * source</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param selfManagedKafkaParameters
         *        The parameters for using a self-managed Apache Kafka stream as a source.</p>
         *        <p>
         *        A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services.
         *        This includes both clusters you manage yourself, as well as those hosted by a third-party provider,
         *        such as <a href="https://www.confluent.io/">Confluent Cloud</a>, <a
         *        href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a
         *        href="https://redpanda.com/">Redpanda</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka
         *        streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters);

        /**
         * <p>
         * The parameters for using a self-managed Apache Kafka stream as a source.
         * </p>
         * <p>
         * A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This
         * includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
         * href="https://www.confluent.io/">Confluent Cloud</a>, <a
         * href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a
         * source</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdatePipeSourceSelfManagedKafkaParameters.Builder} avoiding the need to create one manually via
         * {@link UpdatePipeSourceSelfManagedKafkaParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceSelfManagedKafkaParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters)}.
         * 
         * @param selfManagedKafkaParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceSelfManagedKafkaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters)
         */
        default Builder selfManagedKafkaParameters(
                Consumer<UpdatePipeSourceSelfManagedKafkaParameters.Builder> selfManagedKafkaParameters) {
            return selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters.builder()
                    .applyMutation(selfManagedKafkaParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterCriteria filterCriteria;

        private UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters;

        private UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;

        private UpdatePipeSourceSqsQueueParameters sqsQueueParameters;

        private UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters;

        private UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;

        private UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;

        private UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceParameters model) {
            filterCriteria(model.filterCriteria);
            kinesisStreamParameters(model.kinesisStreamParameters);
            dynamoDBStreamParameters(model.dynamoDBStreamParameters);
            sqsQueueParameters(model.sqsQueueParameters);
            activeMQBrokerParameters(model.activeMQBrokerParameters);
            rabbitMQBrokerParameters(model.rabbitMQBrokerParameters);
            managedStreamingKafkaParameters(model.managedStreamingKafkaParameters);
            selfManagedKafkaParameters(model.selfManagedKafkaParameters);
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final UpdatePipeSourceKinesisStreamParameters.Builder getKinesisStreamParameters() {
            return kinesisStreamParameters != null ? kinesisStreamParameters.toBuilder() : null;
        }

        public final void setKinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters.BuilderImpl kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters != null ? kinesisStreamParameters.build() : null;
        }

        @Override
        public final Builder kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters;
            return this;
        }

        public final UpdatePipeSourceDynamoDBStreamParameters.Builder getDynamoDBStreamParameters() {
            return dynamoDBStreamParameters != null ? dynamoDBStreamParameters.toBuilder() : null;
        }

        public final void setDynamoDBStreamParameters(
                UpdatePipeSourceDynamoDBStreamParameters.BuilderImpl dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters != null ? dynamoDBStreamParameters.build() : null;
        }

        @Override
        public final Builder dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters;
            return this;
        }

        public final UpdatePipeSourceSqsQueueParameters.Builder getSqsQueueParameters() {
            return sqsQueueParameters != null ? sqsQueueParameters.toBuilder() : null;
        }

        public final void setSqsQueueParameters(UpdatePipeSourceSqsQueueParameters.BuilderImpl sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters != null ? sqsQueueParameters.build() : null;
        }

        @Override
        public final Builder sqsQueueParameters(UpdatePipeSourceSqsQueueParameters sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters;
            return this;
        }

        public final UpdatePipeSourceActiveMQBrokerParameters.Builder getActiveMQBrokerParameters() {
            return activeMQBrokerParameters != null ? activeMQBrokerParameters.toBuilder() : null;
        }

        public final void setActiveMQBrokerParameters(
                UpdatePipeSourceActiveMQBrokerParameters.BuilderImpl activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters != null ? activeMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters;
            return this;
        }

        public final UpdatePipeSourceRabbitMQBrokerParameters.Builder getRabbitMQBrokerParameters() {
            return rabbitMQBrokerParameters != null ? rabbitMQBrokerParameters.toBuilder() : null;
        }

        public final void setRabbitMQBrokerParameters(
                UpdatePipeSourceRabbitMQBrokerParameters.BuilderImpl rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters != null ? rabbitMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters;
            return this;
        }

        public final UpdatePipeSourceManagedStreamingKafkaParameters.Builder getManagedStreamingKafkaParameters() {
            return managedStreamingKafkaParameters != null ? managedStreamingKafkaParameters.toBuilder() : null;
        }

        public final void setManagedStreamingKafkaParameters(
                UpdatePipeSourceManagedStreamingKafkaParameters.BuilderImpl managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters != null ? managedStreamingKafkaParameters
                    .build() : null;
        }

        @Override
        public final Builder managedStreamingKafkaParameters(
                UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
            return this;
        }

        public final UpdatePipeSourceSelfManagedKafkaParameters.Builder getSelfManagedKafkaParameters() {
            return selfManagedKafkaParameters != null ? selfManagedKafkaParameters.toBuilder() : null;
        }

        public final void setSelfManagedKafkaParameters(
                UpdatePipeSourceSelfManagedKafkaParameters.BuilderImpl selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters != null ? selfManagedKafkaParameters.build() : null;
        }

        @Override
        public final Builder selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters;
            return this;
        }

        @Override
        public UpdatePipeSourceParameters build() {
            return new UpdatePipeSourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
