/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.KafkaBootstrapServersCopier;
import software.amazon.awssdk.services.pipes.model.SelfManagedKafkaAccessConfigurationCredentials;
import software.amazon.awssdk.services.pipes.model.SelfManagedKafkaAccessConfigurationVpc;
import software.amazon.awssdk.services.pipes.model.SelfManagedKafkaStartPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeSourceSelfManagedKafkaParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeSourceSelfManagedKafkaParameters> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::topicName)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::startingPositionAsString)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_BOOTSTRAP_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalBootstrapServers").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::additionalBootstrapServers)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::additionalBootstrapServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalBootstrapServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::batchSize)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::maximumBatchingWindowInSeconds)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<String> CONSUMER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerGroupID").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::consumerGroupID)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::consumerGroupID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerGroupID").build()}).build();
    private static final SdkField<SelfManagedKafkaAccessConfigurationCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::credentials)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::credentials)).constructor(SelfManagedKafkaAccessConfigurationCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<String> SERVER_ROOT_CA_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerRootCaCertificate").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::serverRootCaCertificate)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::serverRootCaCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerRootCaCertificate").build()}).build();
    private static final SdkField<SelfManagedKafkaAccessConfigurationVpc> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(PipeSourceSelfManagedKafkaParameters.getter(PipeSourceSelfManagedKafkaParameters::vpc)).setter(PipeSourceSelfManagedKafkaParameters.setter(Builder::vpc)).constructor(SelfManagedKafkaAccessConfigurationVpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD, STARTING_POSITION_FIELD, ADDITIONAL_BOOTSTRAP_SERVERS_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, CONSUMER_GROUP_ID_FIELD, CREDENTIALS_FIELD, SERVER_ROOT_CA_CERTIFICATE_FIELD, VPC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipeSourceSelfManagedKafkaParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String topicName;
    private final String startingPosition;
    private final List<String> additionalBootstrapServers;
    private final Integer batchSize;
    private final Integer maximumBatchingWindowInSeconds;
    private final String consumerGroupID;
    private final SelfManagedKafkaAccessConfigurationCredentials credentials;
    private final String serverRootCaCertificate;
    private final SelfManagedKafkaAccessConfigurationVpc vpc;

    private PipeSourceSelfManagedKafkaParameters(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.startingPosition = builder.startingPosition;
        this.additionalBootstrapServers = builder.additionalBootstrapServers;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.consumerGroupID = builder.consumerGroupID;
        this.credentials = builder.credentials;
        this.serverRootCaCertificate = builder.serverRootCaCertificate;
        this.vpc = builder.vpc;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final SelfManagedKafkaStartPosition startingPosition() {
        return SelfManagedKafkaStartPosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final boolean hasAdditionalBootstrapServers() {
        return this.additionalBootstrapServers != null && !(this.additionalBootstrapServers instanceof SdkAutoConstructList);
    }

    public final List<String> additionalBootstrapServers() {
        return this.additionalBootstrapServers;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final String consumerGroupID() {
        return this.consumerGroupID;
    }

    public final SelfManagedKafkaAccessConfigurationCredentials credentials() {
        return this.credentials;
    }

    public final String serverRootCaCertificate() {
        return this.serverRootCaCertificate;
    }

    public final SelfManagedKafkaAccessConfigurationVpc vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalBootstrapServers() ? this.additionalBootstrapServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerGroupID());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverRootCaCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceSelfManagedKafkaParameters)) {
            return false;
        }
        PipeSourceSelfManagedKafkaParameters other = (PipeSourceSelfManagedKafkaParameters)obj;
        return Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && this.hasAdditionalBootstrapServers() == other.hasAdditionalBootstrapServers() && Objects.equals(this.additionalBootstrapServers(), other.additionalBootstrapServers()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.consumerGroupID(), other.consumerGroupID()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.serverRootCaCertificate(), other.serverRootCaCertificate()) && Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"PipeSourceSelfManagedKafkaParameters").add("TopicName", (Object)(this.topicName() == null ? null : "*** Sensitive Data Redacted ***")).add("StartingPosition", (Object)this.startingPositionAsString()).add("AdditionalBootstrapServers", (Object)(this.additionalBootstrapServers() == null ? null : "*** Sensitive Data Redacted ***")).add("BatchSize", (Object)this.batchSize()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("ConsumerGroupID", (Object)(this.consumerGroupID() == null ? null : "*** Sensitive Data Redacted ***")).add("Credentials", (Object)this.credentials()).add("ServerRootCaCertificate", (Object)this.serverRootCaCertificate()).add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "AdditionalBootstrapServers": {
                return Optional.ofNullable(clazz.cast(this.additionalBootstrapServers()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "ConsumerGroupID": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupID()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "ServerRootCaCertificate": {
                return Optional.ofNullable(clazz.cast(this.serverRootCaCertificate()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicName", TOPIC_NAME_FIELD);
        map.put("StartingPosition", STARTING_POSITION_FIELD);
        map.put("AdditionalBootstrapServers", ADDITIONAL_BOOTSTRAP_SERVERS_FIELD);
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        map.put("ConsumerGroupID", CONSUMER_GROUP_ID_FIELD);
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("ServerRootCaCertificate", SERVER_ROOT_CA_CERTIFICATE_FIELD);
        map.put("Vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceSelfManagedKafkaParameters, T> g) {
        return obj -> g.apply((PipeSourceSelfManagedKafkaParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicName;
        private String startingPosition;
        private List<String> additionalBootstrapServers = DefaultSdkAutoConstructList.getInstance();
        private Integer batchSize;
        private Integer maximumBatchingWindowInSeconds;
        private String consumerGroupID;
        private SelfManagedKafkaAccessConfigurationCredentials credentials;
        private String serverRootCaCertificate;
        private SelfManagedKafkaAccessConfigurationVpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceSelfManagedKafkaParameters model) {
            this.topicName(model.topicName);
            this.startingPosition(model.startingPosition);
            this.additionalBootstrapServers(model.additionalBootstrapServers);
            this.batchSize(model.batchSize);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.consumerGroupID(model.consumerGroupID);
            this.credentials(model.credentials);
            this.serverRootCaCertificate(model.serverRootCaCertificate);
            this.vpc(model.vpc);
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(SelfManagedKafkaStartPosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Collection<String> getAdditionalBootstrapServers() {
            if (this.additionalBootstrapServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalBootstrapServers;
        }

        public final void setAdditionalBootstrapServers(Collection<String> additionalBootstrapServers) {
            this.additionalBootstrapServers = KafkaBootstrapServersCopier.copy(additionalBootstrapServers);
        }

        @Override
        public final Builder additionalBootstrapServers(Collection<String> additionalBootstrapServers) {
            this.additionalBootstrapServers = KafkaBootstrapServersCopier.copy(additionalBootstrapServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalBootstrapServers(String ... additionalBootstrapServers) {
            this.additionalBootstrapServers(Arrays.asList(additionalBootstrapServers));
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final String getConsumerGroupID() {
            return this.consumerGroupID;
        }

        public final void setConsumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
        }

        @Override
        public final Builder consumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(SelfManagedKafkaAccessConfigurationCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(SelfManagedKafkaAccessConfigurationCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getServerRootCaCertificate() {
            return this.serverRootCaCertificate;
        }

        public final void setServerRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
        }

        @Override
        public final Builder serverRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationVpc.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(SelfManagedKafkaAccessConfigurationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(SelfManagedKafkaAccessConfigurationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public PipeSourceSelfManagedKafkaParameters build() {
            return new PipeSourceSelfManagedKafkaParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeSourceSelfManagedKafkaParameters> {
        public Builder topicName(String var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(SelfManagedKafkaStartPosition var1);

        public Builder additionalBootstrapServers(Collection<String> var1);

        public Builder additionalBootstrapServers(String ... var1);

        public Builder batchSize(Integer var1);

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder consumerGroupID(String var1);

        public Builder credentials(SelfManagedKafkaAccessConfigurationCredentials var1);

        default public Builder credentials(Consumer<SelfManagedKafkaAccessConfigurationCredentials.Builder> credentials) {
            return this.credentials((SelfManagedKafkaAccessConfigurationCredentials)((SelfManagedKafkaAccessConfigurationCredentials.Builder)SelfManagedKafkaAccessConfigurationCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder serverRootCaCertificate(String var1);

        public Builder vpc(SelfManagedKafkaAccessConfigurationVpc var1);

        default public Builder vpc(Consumer<SelfManagedKafkaAccessConfigurationVpc.Builder> vpc) {
            return this.vpc((SelfManagedKafkaAccessConfigurationVpc)((SelfManagedKafkaAccessConfigurationVpc.Builder)SelfManagedKafkaAccessConfigurationVpc.builder().applyMutation(vpc)).build());
        }
    }
}

