/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pricing.model.PricingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPriceListsRequest
extends PricingRequest
implements ToCopyableBuilder<Builder, ListPriceListsRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(ListPriceListsRequest.getter(ListPriceListsRequest::serviceCode)).setter(ListPriceListsRequest.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EffectiveDate").getter(ListPriceListsRequest.getter(ListPriceListsRequest::effectiveDate)).setter(ListPriceListsRequest.setter(Builder::effectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").build()}).build();
    private static final SdkField<String> REGION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionCode").getter(ListPriceListsRequest.getter(ListPriceListsRequest::regionCode)).setter(ListPriceListsRequest.setter(Builder::regionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionCode").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ListPriceListsRequest.getter(ListPriceListsRequest::currencyCode)).setter(ListPriceListsRequest.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPriceListsRequest.getter(ListPriceListsRequest::nextToken)).setter(ListPriceListsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPriceListsRequest.getter(ListPriceListsRequest::maxResults)).setter(ListPriceListsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, EFFECTIVE_DATE_FIELD, REGION_CODE_FIELD, CURRENCY_CODE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPriceListsRequest.memberNameToFieldInitializer();
    private final String serviceCode;
    private final Instant effectiveDate;
    private final String regionCode;
    private final String currencyCode;
    private final String nextToken;
    private final Integer maxResults;

    private ListPriceListsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.effectiveDate = builder.effectiveDate;
        this.regionCode = builder.regionCode;
        this.currencyCode = builder.currencyCode;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final Instant effectiveDate() {
        return this.effectiveDate;
    }

    public final String regionCode() {
        return this.regionCode;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPriceListsRequest)) {
            return false;
        }
        ListPriceListsRequest other = (ListPriceListsRequest)((Object)obj);
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.regionCode(), other.regionCode()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListPriceListsRequest").add("ServiceCode", (Object)this.serviceCode()).add("EffectiveDate", (Object)this.effectiveDate()).add("RegionCode", (Object)this.regionCode()).add("CurrencyCode", (Object)this.currencyCode()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "EffectiveDate": {
                return Optional.ofNullable(clazz.cast(this.effectiveDate()));
            }
            case "RegionCode": {
                return Optional.ofNullable(clazz.cast(this.regionCode()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("EffectiveDate", EFFECTIVE_DATE_FIELD);
        map.put("RegionCode", REGION_CODE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPriceListsRequest, T> g) {
        return obj -> g.apply((ListPriceListsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PricingRequest.BuilderImpl
    implements Builder {
        private String serviceCode;
        private Instant effectiveDate;
        private String regionCode;
        private String currencyCode;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPriceListsRequest model) {
            super(model);
            this.serviceCode(model.serviceCode);
            this.effectiveDate(model.effectiveDate);
            this.regionCode(model.regionCode);
            this.currencyCode(model.currencyCode);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final Instant getEffectiveDate() {
            return this.effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final String getRegionCode() {
            return this.regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPriceListsRequest build() {
            return new ListPriceListsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PricingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPriceListsRequest> {
        public Builder serviceCode(String var1);

        public Builder effectiveDate(Instant var1);

        public Builder regionCode(String var1);

        public Builder currencyCode(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

