/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.NameValuePair;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinition;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionsCopier;
import software.amazon.awssdk.services.privatenetworks.model.OptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SitePlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SitePlan> {
    private static final SdkField<List<NameValuePair>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("options").getter(SitePlan.getter(SitePlan::options)).setter(SitePlan.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NameValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkResourceDefinition>> RESOURCE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceDefinitions").getter(SitePlan.getter(SitePlan::resourceDefinitions)).setter(SitePlan.setter(Builder::resourceDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, RESOURCE_DEFINITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<NameValuePair> options;
    private final List<NetworkResourceDefinition> resourceDefinitions;

    private SitePlan(BuilderImpl builder) {
        this.options = builder.options;
        this.resourceDefinitions = builder.resourceDefinitions;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<NameValuePair> options() {
        return this.options;
    }

    public final boolean hasResourceDefinitions() {
        return this.resourceDefinitions != null && !(this.resourceDefinitions instanceof SdkAutoConstructList);
    }

    public final List<NetworkResourceDefinition> resourceDefinitions() {
        return this.resourceDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDefinitions() ? this.resourceDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SitePlan)) {
            return false;
        }
        SitePlan other = (SitePlan)obj;
        return this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && this.hasResourceDefinitions() == other.hasResourceDefinitions() && Objects.equals(this.resourceDefinitions(), other.resourceDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"SitePlan").add("Options", this.hasOptions() ? this.options() : null).add("ResourceDefinitions", this.hasResourceDefinitions() ? this.resourceDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "resourceDefinitions": {
                return Optional.ofNullable(clazz.cast(this.resourceDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SitePlan, T> g) {
        return obj -> g.apply((SitePlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NameValuePair> options = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkResourceDefinition> resourceDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SitePlan model) {
            this.options(model.options);
            this.resourceDefinitions(model.resourceDefinitions);
        }

        public final List<NameValuePair.Builder> getOptions() {
            List<NameValuePair.Builder> result = OptionsCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<NameValuePair.BuilderImpl> options) {
            this.options = OptionsCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<NameValuePair> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(NameValuePair ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<NameValuePair.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (NameValuePair)((NameValuePair.Builder)NameValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkResourceDefinition.Builder> getResourceDefinitions() {
            List<NetworkResourceDefinition.Builder> result = NetworkResourceDefinitionsCopier.copyToBuilder(this.resourceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceDefinitions(Collection<NetworkResourceDefinition.BuilderImpl> resourceDefinitions) {
            this.resourceDefinitions = NetworkResourceDefinitionsCopier.copyFromBuilder(resourceDefinitions);
        }

        @Override
        public final Builder resourceDefinitions(Collection<NetworkResourceDefinition> resourceDefinitions) {
            this.resourceDefinitions = NetworkResourceDefinitionsCopier.copy(resourceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDefinitions(NetworkResourceDefinition ... resourceDefinitions) {
            this.resourceDefinitions(Arrays.asList(resourceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDefinitions(Consumer<NetworkResourceDefinition.Builder> ... resourceDefinitions) {
            this.resourceDefinitions(Stream.of(resourceDefinitions).map(c -> (NetworkResourceDefinition)((NetworkResourceDefinition.Builder)NetworkResourceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SitePlan build() {
            return new SitePlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SitePlan> {
        public Builder options(Collection<NameValuePair> var1);

        public Builder options(NameValuePair ... var1);

        public Builder options(Consumer<NameValuePair.Builder> ... var1);

        public Builder resourceDefinitions(Collection<NetworkResourceDefinition> var1);

        public Builder resourceDefinitions(NetworkResourceDefinition ... var1);

        public Builder resourceDefinitions(Consumer<NetworkResourceDefinition.Builder> ... var1);
    }
}

