/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksAsyncClient;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse;
import software.amazon.awssdk.services.privatenetworks.model.Network;

public class ListNetworksPublisher
implements SdkPublisher<ListNetworksResponse> {
    private final PrivateNetworksAsyncClient client;
    private final ListNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNetworksPublisher(PrivateNetworksAsyncClient client, ListNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNetworksPublisher(PrivateNetworksAsyncClient client, ListNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Network> networks() {
        Function<ListNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.networks() != null) {
                return response.networks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNetworksResponseFetcher
    implements AsyncPageFetcher<ListNetworksResponse> {
        private ListNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNetworksResponse> nextPage(ListNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListNetworksPublisher.this.client.listNetworks(ListNetworksPublisher.this.firstRequest);
            }
            return ListNetworksPublisher.this.client.listNetworks((ListNetworksRequest)((Object)ListNetworksPublisher.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

