/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierListCopier;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceIdentifiersResponse
extends PrivateNetworksResponse
implements ToCopyableBuilder<Builder, ListDeviceIdentifiersResponse> {
    private static final SdkField<List<DeviceIdentifier>> DEVICE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deviceIdentifiers").getter(ListDeviceIdentifiersResponse.getter(ListDeviceIdentifiersResponse::deviceIdentifiers)).setter(ListDeviceIdentifiersResponse.setter(Builder::deviceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeviceIdentifiersResponse.getter(ListDeviceIdentifiersResponse::nextToken)).setter(ListDeviceIdentifiersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeviceIdentifiersResponse.memberNameToFieldInitializer();
    private final List<DeviceIdentifier> deviceIdentifiers;
    private final String nextToken;

    private ListDeviceIdentifiersResponse(BuilderImpl builder) {
        super(builder);
        this.deviceIdentifiers = builder.deviceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeviceIdentifiers() {
        return this.deviceIdentifiers != null && !(this.deviceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<DeviceIdentifier> deviceIdentifiers() {
        return this.deviceIdentifiers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceIdentifiers() ? this.deviceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceIdentifiersResponse)) {
            return false;
        }
        ListDeviceIdentifiersResponse other = (ListDeviceIdentifiersResponse)((Object)obj);
        return this.hasDeviceIdentifiers() == other.hasDeviceIdentifiers() && Objects.equals(this.deviceIdentifiers(), other.deviceIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceIdentifiersResponse").add("DeviceIdentifiers", this.hasDeviceIdentifiers() ? this.deviceIdentifiers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.deviceIdentifiers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deviceIdentifiers", DEVICE_IDENTIFIERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceIdentifiersResponse, T> g) {
        return obj -> g.apply((ListDeviceIdentifiersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksResponse.BuilderImpl
    implements Builder {
        private List<DeviceIdentifier> deviceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceIdentifiersResponse model) {
            super(model);
            this.deviceIdentifiers(model.deviceIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final List<DeviceIdentifier.Builder> getDeviceIdentifiers() {
            List<DeviceIdentifier.Builder> result = DeviceIdentifierListCopier.copyToBuilder(this.deviceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceIdentifiers(Collection<DeviceIdentifier.BuilderImpl> deviceIdentifiers) {
            this.deviceIdentifiers = DeviceIdentifierListCopier.copyFromBuilder(deviceIdentifiers);
        }

        @Override
        public final Builder deviceIdentifiers(Collection<DeviceIdentifier> deviceIdentifiers) {
            this.deviceIdentifiers = DeviceIdentifierListCopier.copy(deviceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIdentifiers(DeviceIdentifier ... deviceIdentifiers) {
            this.deviceIdentifiers(Arrays.asList(deviceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIdentifiers(Consumer<DeviceIdentifier.Builder> ... deviceIdentifiers) {
            this.deviceIdentifiers(Stream.of(deviceIdentifiers).map(c -> (DeviceIdentifier)((DeviceIdentifier.Builder)DeviceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeviceIdentifiersResponse build() {
            return new ListDeviceIdentifiersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PrivateNetworksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceIdentifiersResponse> {
        public Builder deviceIdentifiers(Collection<DeviceIdentifier> var1);

        public Builder deviceIdentifiers(DeviceIdentifier ... var1);

        public Builder deviceIdentifiers(Consumer<DeviceIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

