/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CardType {
    TEXT_INPUT("text-input"),
    Q_QUERY("q-query"),
    FILE_UPLOAD("file-upload"),
    Q_PLUGIN("q-plugin"),
    FORM_INPUT("form-input"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CardType> VALUE_MAP;
    private final String value;

    private CardType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CardType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CardType> knownValues() {
        EnumSet<CardType> knownValues = EnumSet.allOf(CardType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CardType.class, CardType::toString);
    }
}

