/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppRequiredCapability {
    FILE_UPLOAD("FileUpload"),
    CREATOR_MODE("CreatorMode"),
    RETRIEVAL_MODE("RetrievalMode"),
    PLUGIN_MODE("PluginMode"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppRequiredCapability> VALUE_MAP;
    private final String value;

    private AppRequiredCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppRequiredCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppRequiredCapability> knownValues() {
        EnumSet<AppRequiredCapability> knownValues = EnumSet.allOf(AppRequiredCapability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppRequiredCapability.class, AppRequiredCapability::toString);
    }
}

