/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qapps.QAppsAsyncClient;
import software.amazon.awssdk.services.qapps.internal.UserAgentUtils;
import software.amazon.awssdk.services.qapps.model.ListQAppsRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppsResponse;
import software.amazon.awssdk.services.qapps.model.UserAppItem;

public class ListQAppsPublisher
implements SdkPublisher<ListQAppsResponse> {
    private final QAppsAsyncClient client;
    private final ListQAppsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQAppsPublisher(QAppsAsyncClient client, ListQAppsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQAppsPublisher(QAppsAsyncClient client, ListQAppsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQAppsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQAppsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserAppItem> apps() {
        Function<ListQAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.apps() != null) {
                return response.apps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQAppsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQAppsResponseFetcher
    implements AsyncPageFetcher<ListQAppsResponse> {
        private ListQAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListQAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQAppsResponse> nextPage(ListQAppsResponse previousPage) {
            if (previousPage == null) {
                return ListQAppsPublisher.this.client.listQApps(ListQAppsPublisher.this.firstRequest);
            }
            return ListQAppsPublisher.this.client.listQApps((ListQAppsRequest)((Object)ListQAppsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

