/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.IndexCapacityConfiguration;
import software.amazon.awssdk.services.qbusiness.model.IndexType;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.Tag;
import software.amazon.awssdk.services.qbusiness.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIndexRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateIndexRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateIndexRequest.getter(CreateIndexRequest::applicationId)).setter(CreateIndexRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateIndexRequest.getter(CreateIndexRequest::displayName)).setter(CreateIndexRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateIndexRequest.getter(CreateIndexRequest::description)).setter(CreateIndexRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateIndexRequest.getter(CreateIndexRequest::typeAsString)).setter(CreateIndexRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateIndexRequest.getter(CreateIndexRequest::tags)).setter(CreateIndexRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IndexCapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacityConfiguration").getter(CreateIndexRequest.getter(CreateIndexRequest::capacityConfiguration)).setter(CreateIndexRequest.setter(Builder::capacityConfiguration)).constructor(IndexCapacityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateIndexRequest.getter(CreateIndexRequest::clientToken)).setter(CreateIndexRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, TAGS_FIELD, CAPACITY_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIndexRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String displayName;
    private final String description;
    private final String type;
    private final List<Tag> tags;
    private final IndexCapacityConfiguration capacityConfiguration;
    private final String clientToken;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.type = builder.type;
        this.tags = builder.tags;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final IndexType type() {
        return IndexType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final IndexCapacityConfiguration capacityConfiguration() {
        return this.capacityConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.capacityConfiguration(), other.capacityConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIndexRequest").add("ApplicationId", (Object)this.applicationId()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("CapacityConfiguration", (Object)this.capacityConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "capacityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capacityConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("capacityConfiguration", CAPACITY_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String displayName;
        private String description;
        private String type;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private IndexCapacityConfiguration capacityConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.displayName(model.displayName);
            this.description(model.description);
            this.type(model.type);
            this.tags(model.tags);
            this.capacityConfiguration(model.capacityConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IndexType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IndexCapacityConfiguration.Builder getCapacityConfiguration() {
            return this.capacityConfiguration != null ? this.capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(IndexCapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIndexRequest> {
        public Builder applicationId(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(IndexType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder capacityConfiguration(IndexCapacityConfiguration var1);

        default public Builder capacityConfiguration(Consumer<IndexCapacityConfiguration.Builder> capacityConfiguration) {
            return this.capacityConfiguration((IndexCapacityConfiguration)((IndexCapacityConfiguration.Builder)IndexCapacityConfiguration.builder().applyMutation(capacityConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

