/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.OpenIDConnectProviderConfiguration;
import software.amazon.awssdk.services.qbusiness.model.SamlProviderConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProviderConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityProviderConfiguration> {
    private static final SdkField<SamlProviderConfiguration> SAML_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlConfiguration").getter(IdentityProviderConfiguration.getter(IdentityProviderConfiguration::samlConfiguration)).setter(IdentityProviderConfiguration.setter(Builder::samlConfiguration)).constructor(SamlProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfiguration").build()}).build();
    private static final SdkField<OpenIDConnectProviderConfiguration> OPEN_ID_CONNECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openIDConnectConfiguration").getter(IdentityProviderConfiguration.getter(IdentityProviderConfiguration::openIDConnectConfiguration)).setter(IdentityProviderConfiguration.setter(Builder::openIDConnectConfiguration)).constructor(OpenIDConnectProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_CONFIGURATION_FIELD, OPEN_ID_CONNECT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentityProviderConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SamlProviderConfiguration samlConfiguration;
    private final OpenIDConnectProviderConfiguration openIDConnectConfiguration;
    private final Type type;

    private IdentityProviderConfiguration(BuilderImpl builder) {
        this.samlConfiguration = builder.samlConfiguration;
        this.openIDConnectConfiguration = builder.openIDConnectConfiguration;
        this.type = builder.type;
    }

    public final SamlProviderConfiguration samlConfiguration() {
        return this.samlConfiguration;
    }

    public final OpenIDConnectProviderConfiguration openIDConnectConfiguration() {
        return this.openIDConnectConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderConfiguration)) {
            return false;
        }
        IdentityProviderConfiguration other = (IdentityProviderConfiguration)obj;
        return Objects.equals(this.samlConfiguration(), other.samlConfiguration()) && Objects.equals(this.openIDConnectConfiguration(), other.openIDConnectConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityProviderConfiguration").add("SamlConfiguration", (Object)this.samlConfiguration()).add("OpenIDConnectConfiguration", (Object)this.openIDConnectConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "samlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.samlConfiguration()));
            }
            case "openIDConnectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static IdentityProviderConfiguration fromSamlConfiguration(SamlProviderConfiguration samlConfiguration) {
        return (IdentityProviderConfiguration)IdentityProviderConfiguration.builder().samlConfiguration(samlConfiguration).build();
    }

    public static IdentityProviderConfiguration fromSamlConfiguration(Consumer<SamlProviderConfiguration.Builder> samlConfiguration) {
        SamlProviderConfiguration.Builder builder = SamlProviderConfiguration.builder();
        samlConfiguration.accept(builder);
        return IdentityProviderConfiguration.fromSamlConfiguration((SamlProviderConfiguration)builder.build());
    }

    public static IdentityProviderConfiguration fromOpenIDConnectConfiguration(OpenIDConnectProviderConfiguration openIDConnectConfiguration) {
        return (IdentityProviderConfiguration)IdentityProviderConfiguration.builder().openIDConnectConfiguration(openIDConnectConfiguration).build();
    }

    public static IdentityProviderConfiguration fromOpenIDConnectConfiguration(Consumer<OpenIDConnectProviderConfiguration.Builder> openIDConnectConfiguration) {
        OpenIDConnectProviderConfiguration.Builder builder = OpenIDConnectProviderConfiguration.builder();
        openIDConnectConfiguration.accept(builder);
        return IdentityProviderConfiguration.fromOpenIDConnectConfiguration((OpenIDConnectProviderConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("samlConfiguration", SAML_CONFIGURATION_FIELD);
        map.put("openIDConnectConfiguration", OPEN_ID_CONNECT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderConfiguration, T> g) {
        return obj -> g.apply((IdentityProviderConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SAML_CONFIGURATION,
        OPEN_ID_CONNECT_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SamlProviderConfiguration samlConfiguration;
        private OpenIDConnectProviderConfiguration openIDConnectConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderConfiguration model) {
            this.samlConfiguration(model.samlConfiguration);
            this.openIDConnectConfiguration(model.openIDConnectConfiguration);
        }

        public final SamlProviderConfiguration.Builder getSamlConfiguration() {
            return this.samlConfiguration != null ? this.samlConfiguration.toBuilder() : null;
        }

        public final void setSamlConfiguration(SamlProviderConfiguration.BuilderImpl samlConfiguration) {
            SamlProviderConfiguration oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration != null ? samlConfiguration.build() : null;
            this.handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
        }

        @Override
        public final Builder samlConfiguration(SamlProviderConfiguration samlConfiguration) {
            SamlProviderConfiguration oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration;
            this.handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
            return this;
        }

        public final OpenIDConnectProviderConfiguration.Builder getOpenIDConnectConfiguration() {
            return this.openIDConnectConfiguration != null ? this.openIDConnectConfiguration.toBuilder() : null;
        }

        public final void setOpenIDConnectConfiguration(OpenIDConnectProviderConfiguration.BuilderImpl openIDConnectConfiguration) {
            OpenIDConnectProviderConfiguration oldValue = this.openIDConnectConfiguration;
            this.openIDConnectConfiguration = openIDConnectConfiguration != null ? openIDConnectConfiguration.build() : null;
            this.handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIDConnectConfiguration);
        }

        @Override
        public final Builder openIDConnectConfiguration(OpenIDConnectProviderConfiguration openIDConnectConfiguration) {
            OpenIDConnectProviderConfiguration oldValue = this.openIDConnectConfiguration;
            this.openIDConnectConfiguration = openIDConnectConfiguration;
            this.handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIDConnectConfiguration);
            return this;
        }

        public IdentityProviderConfiguration build() {
            return new IdentityProviderConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityProviderConfiguration> {
        public Builder samlConfiguration(SamlProviderConfiguration var1);

        default public Builder samlConfiguration(Consumer<SamlProviderConfiguration.Builder> samlConfiguration) {
            return this.samlConfiguration((SamlProviderConfiguration)((SamlProviderConfiguration.Builder)SamlProviderConfiguration.builder().applyMutation(samlConfiguration)).build());
        }

        public Builder openIDConnectConfiguration(OpenIDConnectProviderConfiguration var1);

        default public Builder openIDConnectConfiguration(Consumer<OpenIDConnectProviderConfiguration.Builder> openIDConnectConfiguration) {
            return this.openIDConnectConfiguration((OpenIDConnectProviderConfiguration)((OpenIDConnectProviderConfiguration.Builder)OpenIDConnectProviderConfiguration.builder().applyMutation(openIDConnectConfiguration)).build());
        }
    }
}

