/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PluginType {
    SERVICE_NOW("SERVICE_NOW"),
    SALESFORCE("SALESFORCE"),
    JIRA("JIRA"),
    ZENDESK("ZENDESK"),
    CUSTOM("CUSTOM"),
    QUICKSIGHT("QUICKSIGHT"),
    SERVICENOW_NOW_PLATFORM("SERVICENOW_NOW_PLATFORM"),
    JIRA_CLOUD("JIRA_CLOUD"),
    SALESFORCE_CRM("SALESFORCE_CRM"),
    ZENDESK_SUITE("ZENDESK_SUITE"),
    ATLASSIAN_CONFLUENCE("ATLASSIAN_CONFLUENCE"),
    GOOGLE_CALENDAR("GOOGLE_CALENDAR"),
    MICROSOFT_TEAMS("MICROSOFT_TEAMS"),
    MICROSOFT_EXCHANGE("MICROSOFT_EXCHANGE"),
    PAGERDUTY_ADVANCE("PAGERDUTY_ADVANCE"),
    SMARTSHEET("SMARTSHEET"),
    ASANA("ASANA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PluginType> VALUE_MAP;
    private final String value;

    private PluginType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PluginType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PluginType> knownValues() {
        EnumSet<PluginType> knownValues = EnumSet.allOf(PluginType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PluginType.class, PluginType::toString);
    }
}

