/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.Conversation;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse;

public class ListConversationsPublisher
implements SdkPublisher<ListConversationsResponse> {
    private final QBusinessAsyncClient client;
    private final ListConversationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConversationsPublisher(QBusinessAsyncClient client, ListConversationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConversationsPublisher(QBusinessAsyncClient client, ListConversationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConversationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConversationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Conversation> conversations() {
        Function<ListConversationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.conversations() != null) {
                return response.conversations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConversationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConversationsResponseFetcher
    implements AsyncPageFetcher<ListConversationsResponse> {
        private ListConversationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConversationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConversationsResponse> nextPage(ListConversationsResponse previousPage) {
            if (previousPage == null) {
                return ListConversationsPublisher.this.client.listConversations(ListConversationsPublisher.this.firstRequest);
            }
            return ListConversationsPublisher.this.client.listConversations((ListConversationsRequest)((Object)ListConversationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

