/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.DataAccessor;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse;

public class ListDataAccessorsPublisher
implements SdkPublisher<ListDataAccessorsResponse> {
    private final QBusinessAsyncClient client;
    private final ListDataAccessorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataAccessorsPublisher(QBusinessAsyncClient client, ListDataAccessorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataAccessorsPublisher(QBusinessAsyncClient client, ListDataAccessorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataAccessorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataAccessorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataAccessor> dataAccessors() {
        Function<ListDataAccessorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataAccessors() != null) {
                return response.dataAccessors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataAccessorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataAccessorsResponseFetcher
    implements AsyncPageFetcher<ListDataAccessorsResponse> {
        private ListDataAccessorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataAccessorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataAccessorsResponse> nextPage(ListDataAccessorsResponse previousPage) {
            if (previousPage == null) {
                return ListDataAccessorsPublisher.this.client.listDataAccessors(ListDataAccessorsPublisher.this.firstRequest);
            }
            return ListDataAccessorsPublisher.this.client.listDataAccessors((ListDataAccessorsRequest)((Object)ListDataAccessorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

