/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.RelevantContent;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse;

public class SearchRelevantContentIterable
implements SdkIterable<SearchRelevantContentResponse> {
    private final QBusinessClient client;
    private final SearchRelevantContentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchRelevantContentIterable(QBusinessClient client, SearchRelevantContentRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchRelevantContentResponseFetcher();
    }

    public Iterator<SearchRelevantContentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RelevantContent> relevantContent() {
        Function<SearchRelevantContentResponse, Iterator> getIterator = response -> {
            if (response != null && response.relevantContent() != null) {
                return response.relevantContent().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchRelevantContentResponseFetcher
    implements SyncPageFetcher<SearchRelevantContentResponse> {
        private SearchRelevantContentResponseFetcher() {
        }

        public boolean hasNextPage(SearchRelevantContentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchRelevantContentResponse nextPage(SearchRelevantContentResponse previousPage) {
            if (previousPage == null) {
                return SearchRelevantContentIterable.this.client.searchRelevantContent(SearchRelevantContentIterable.this.firstRequest);
            }
            return SearchRelevantContentIterable.this.client.searchRelevantContent((SearchRelevantContentRequest)((Object)SearchRelevantContentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

