/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AIPromptSummary;
import software.amazon.awssdk.services.qconnect.model.AIPromptSummaryListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAiPromptsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, ListAiPromptsResponse> {
    private static final SdkField<List<AIPromptSummary>> AI_PROMPT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aiPromptSummaries").getter(ListAiPromptsResponse.getter(ListAiPromptsResponse::aiPromptSummaries)).setter(ListAiPromptsResponse.setter(Builder::aiPromptSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AIPromptSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAiPromptsResponse.getter(ListAiPromptsResponse::nextToken)).setter(ListAiPromptsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("aiPromptSummaries", AI_PROMPT_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AIPromptSummary> aiPromptSummaries;
    private final String nextToken;

    private ListAiPromptsResponse(BuilderImpl builder) {
        super(builder);
        this.aiPromptSummaries = builder.aiPromptSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAiPromptSummaries() {
        return this.aiPromptSummaries != null && !(this.aiPromptSummaries instanceof SdkAutoConstructList);
    }

    public final List<AIPromptSummary> aiPromptSummaries() {
        return this.aiPromptSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiPromptSummaries() ? this.aiPromptSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiPromptsResponse)) {
            return false;
        }
        ListAiPromptsResponse other = (ListAiPromptsResponse)((Object)obj);
        return this.hasAiPromptSummaries() == other.hasAiPromptSummaries() && Objects.equals(this.aiPromptSummaries(), other.aiPromptSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAiPromptsResponse").add("AiPromptSummaries", this.hasAiPromptSummaries() ? this.aiPromptSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiPromptSummaries": {
                return Optional.ofNullable(clazz.cast(this.aiPromptSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAiPromptsResponse, T> g) {
        return obj -> g.apply((ListAiPromptsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<AIPromptSummary> aiPromptSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiPromptsResponse model) {
            super(model);
            this.aiPromptSummaries(model.aiPromptSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AIPromptSummary.Builder> getAiPromptSummaries() {
            List<AIPromptSummary.Builder> result = AIPromptSummaryListCopier.copyToBuilder(this.aiPromptSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiPromptSummaries(Collection<AIPromptSummary.BuilderImpl> aiPromptSummaries) {
            this.aiPromptSummaries = AIPromptSummaryListCopier.copyFromBuilder(aiPromptSummaries);
        }

        @Override
        public final Builder aiPromptSummaries(Collection<AIPromptSummary> aiPromptSummaries) {
            this.aiPromptSummaries = AIPromptSummaryListCopier.copy(aiPromptSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptSummaries(AIPromptSummary ... aiPromptSummaries) {
            this.aiPromptSummaries(Arrays.asList(aiPromptSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptSummaries(Consumer<AIPromptSummary.Builder> ... aiPromptSummaries) {
            this.aiPromptSummaries(Stream.of(aiPromptSummaries).map(c -> (AIPromptSummary)((AIPromptSummary.Builder)AIPromptSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiPromptsResponse build() {
            return new ListAiPromptsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAiPromptsResponse> {
        public Builder aiPromptSummaries(Collection<AIPromptSummary> var1);

        public Builder aiPromptSummaries(AIPromptSummary ... var1);

        public Builder aiPromptSummaries(Consumer<AIPromptSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

