/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AndConditionsCopier;
import software.amazon.awssdk.services.qconnect.model.OrCondition;
import software.amazon.awssdk.services.qconnect.model.OrConditionsCopier;
import software.amazon.awssdk.services.qconnect.model.TagCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TagFilter> {
    private static final SdkField<List<TagCondition>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("andConditions").getter(TagFilter.getter(TagFilter::andConditions)).setter(TagFilter.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OrCondition>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orConditions").getter(TagFilter.getter(TagFilter::orConditions)).setter(TagFilter.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagCondition").getter(TagFilter.getter(TagFilter::tagCondition)).setter(TagFilter.setter(Builder::tagCondition)).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_CONDITIONS_FIELD, OR_CONDITIONS_FIELD, TAG_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("andConditions", AND_CONDITIONS_FIELD);
            this.put("orConditions", OR_CONDITIONS_FIELD);
            this.put("tagCondition", TAG_CONDITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<TagCondition> andConditions;
    private final List<OrCondition> orConditions;
    private final TagCondition tagCondition;
    private final Type type;

    private TagFilter(BuilderImpl builder) {
        this.andConditions = builder.andConditions;
        this.orConditions = builder.orConditions;
        this.tagCondition = builder.tagCondition;
        this.type = builder.type;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<TagCondition> andConditions() {
        return this.andConditions;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<OrCondition> orConditions() {
        return this.orConditions;
    }

    public final TagCondition tagCondition() {
        return this.tagCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tagCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagFilter)) {
            return false;
        }
        TagFilter other = (TagFilter)obj;
        return this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && Objects.equals(this.tagCondition(), other.tagCondition());
    }

    public final String toString() {
        return ToString.builder((String)"TagFilter").add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("TagCondition", (Object)this.tagCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "andConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "orConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "tagCondition": {
                return Optional.ofNullable(clazz.cast(this.tagCondition()));
            }
        }
        return Optional.empty();
    }

    public static TagFilter fromAndConditions(List<TagCondition> andConditions) {
        return (TagFilter)TagFilter.builder().andConditions(andConditions).build();
    }

    public static TagFilter fromOrConditions(List<OrCondition> orConditions) {
        return (TagFilter)TagFilter.builder().orConditions(orConditions).build();
    }

    public static TagFilter fromTagCondition(TagCondition tagCondition) {
        return (TagFilter)TagFilter.builder().tagCondition(tagCondition).build();
    }

    public static TagFilter fromTagCondition(Consumer<TagCondition.Builder> tagCondition) {
        TagCondition.Builder builder = TagCondition.builder();
        tagCondition.accept(builder);
        return TagFilter.fromTagCondition((TagCondition)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TagFilter, T> g) {
        return obj -> g.apply((TagFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AND_CONDITIONS,
        OR_CONDITIONS,
        TAG_CONDITION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<TagCondition> andConditions = DefaultSdkAutoConstructList.getInstance();
        private List<OrCondition> orConditions = DefaultSdkAutoConstructList.getInstance();
        private TagCondition tagCondition;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TagFilter model) {
            this.andConditions(model.andConditions);
            this.orConditions(model.orConditions);
            this.tagCondition(model.tagCondition);
        }

        public final List<TagCondition.Builder> getAndConditions() {
            List<TagCondition.Builder> result = AndConditionsCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<TagCondition.BuilderImpl> andConditions) {
            List<TagCondition> oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copyFromBuilder(andConditions);
            this.handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
        }

        @Override
        public final Builder andConditions(Collection<TagCondition> andConditions) {
            List<TagCondition> oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copy(andConditions);
            this.handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(TagCondition ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<TagCondition.Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OrCondition.Builder> getOrConditions() {
            List<OrCondition.Builder> result = OrConditionsCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<OrCondition.BuilderImpl> orConditions) {
            List<OrCondition> oldValue = this.orConditions;
            this.orConditions = OrConditionsCopier.copyFromBuilder(orConditions);
            this.handleUnionValueChange(Type.OR_CONDITIONS, oldValue, this.orConditions);
        }

        @Override
        public final Builder orConditions(Collection<OrCondition> orConditions) {
            List<OrCondition> oldValue = this.orConditions;
            this.orConditions = OrConditionsCopier.copy(orConditions);
            this.handleUnionValueChange(Type.OR_CONDITIONS, oldValue, this.orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(OrCondition ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<OrCondition.Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (OrCondition)((OrCondition.Builder)OrCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return this.tagCondition != null ? this.tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            TagCondition oldValue = this.tagCondition;
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
            this.handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            TagCondition oldValue = this.tagCondition;
            this.tagCondition = tagCondition;
            this.handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
            return this;
        }

        public TagFilter build() {
            return new TagFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagFilter> {
        public Builder andConditions(Collection<TagCondition> var1);

        public Builder andConditions(TagCondition ... var1);

        public Builder andConditions(Consumer<TagCondition.Builder> ... var1);

        public Builder orConditions(Collection<OrCondition> var1);

        public Builder orConditions(OrCondition ... var1);

        public Builder orConditions(Consumer<OrCondition.Builder> ... var1);

        public Builder tagCondition(TagCondition var1);

        default public Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return this.tagCondition((TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation(tagCondition)).build());
        }
    }
}

