/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateSearchResultData;
import software.amazon.awssdk.services.qconnect.model.SearchMessageTemplatesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchMessageTemplatesResponse;

public class SearchMessageTemplatesIterable
implements SdkIterable<SearchMessageTemplatesResponse> {
    private final QConnectClient client;
    private final SearchMessageTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchMessageTemplatesIterable(QConnectClient client, SearchMessageTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchMessageTemplatesResponseFetcher();
    }

    public Iterator<SearchMessageTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MessageTemplateSearchResultData> results() {
        Function<SearchMessageTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchMessageTemplatesResponseFetcher
    implements SyncPageFetcher<SearchMessageTemplatesResponse> {
        private SearchMessageTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(SearchMessageTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchMessageTemplatesResponse nextPage(SearchMessageTemplatesResponse previousPage) {
            if (previousPage == null) {
                return SearchMessageTemplatesIterable.this.client.searchMessageTemplates(SearchMessageTemplatesIterable.this.firstRequest);
            }
            return SearchMessageTemplatesIterable.this.client.searchMessageTemplates((SearchMessageTemplatesRequest)((Object)SearchMessageTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

