/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data that is output as a result of the assistant association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssistantAssociationOutputData implements SdkPojo, Serializable,
        ToCopyableBuilder<AssistantAssociationOutputData.Builder, AssistantAssociationOutputData> {
    private static final SdkField<KnowledgeBaseAssociationData> KNOWLEDGE_BASE_ASSOCIATION_FIELD = SdkField
            .<KnowledgeBaseAssociationData> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseAssociation")
            .getter(getter(AssistantAssociationOutputData::knowledgeBaseAssociation))
            .setter(setter(Builder::knowledgeBaseAssociation)).constructor(KnowledgeBaseAssociationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KNOWLEDGE_BASE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseAssociationData knowledgeBaseAssociation;

    private final Type type;

    private AssistantAssociationOutputData(BuilderImpl builder) {
        this.knowledgeBaseAssociation = builder.knowledgeBaseAssociation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @return The knowledge base where output data is sent.
     */
    public final KnowledgeBaseAssociationData knowledgeBaseAssociation() {
        return knowledgeBaseAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantAssociationOutputData)) {
            return false;
        }
        AssistantAssociationOutputData other = (AssistantAssociationOutputData) obj;
        return Objects.equals(knowledgeBaseAssociation(), other.knowledgeBaseAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssistantAssociationOutputData").add("KnowledgeBaseAssociation", knowledgeBaseAssociation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseAssociation":
            return Optional.ofNullable(clazz.cast(knowledgeBaseAssociation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseAssociation()} initialized to the given value.
     *
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @param knowledgeBaseAssociation
     *        The knowledge base where output data is sent.
     */
    public static AssistantAssociationOutputData fromKnowledgeBaseAssociation(
            KnowledgeBaseAssociationData knowledgeBaseAssociation) {
        return builder().knowledgeBaseAssociation(knowledgeBaseAssociation).build();
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseAssociation()} initialized to the given value.
     *
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @param knowledgeBaseAssociation
     *        The knowledge base where output data is sent.
     */
    public static AssistantAssociationOutputData fromKnowledgeBaseAssociation(
            Consumer<KnowledgeBaseAssociationData.Builder> knowledgeBaseAssociation) {
        KnowledgeBaseAssociationData.Builder builder = KnowledgeBaseAssociationData.builder();
        knowledgeBaseAssociation.accept(builder);
        return fromKnowledgeBaseAssociation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseAssociation", KNOWLEDGE_BASE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssistantAssociationOutputData, T> g) {
        return obj -> g.apply((AssistantAssociationOutputData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssistantAssociationOutputData> {
        /**
         * <p>
         * The knowledge base where output data is sent.
         * </p>
         * 
         * @param knowledgeBaseAssociation
         *        The knowledge base where output data is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseAssociation(KnowledgeBaseAssociationData knowledgeBaseAssociation);

        /**
         * <p>
         * The knowledge base where output data is sent.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseAssociationData.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseAssociationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseAssociationData.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBaseAssociation(KnowledgeBaseAssociationData)}.
         * 
         * @param knowledgeBaseAssociation
         *        a consumer that will call methods on {@link KnowledgeBaseAssociationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseAssociation(KnowledgeBaseAssociationData)
         */
        default Builder knowledgeBaseAssociation(Consumer<KnowledgeBaseAssociationData.Builder> knowledgeBaseAssociation) {
            return knowledgeBaseAssociation(KnowledgeBaseAssociationData.builder().applyMutation(knowledgeBaseAssociation)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseAssociationData knowledgeBaseAssociation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantAssociationOutputData model) {
            knowledgeBaseAssociation(model.knowledgeBaseAssociation);
        }

        public final KnowledgeBaseAssociationData.Builder getKnowledgeBaseAssociation() {
            return knowledgeBaseAssociation != null ? knowledgeBaseAssociation.toBuilder() : null;
        }

        public final void setKnowledgeBaseAssociation(KnowledgeBaseAssociationData.BuilderImpl knowledgeBaseAssociation) {
            Object oldValue = this.knowledgeBaseAssociation;
            this.knowledgeBaseAssociation = knowledgeBaseAssociation != null ? knowledgeBaseAssociation.build() : null;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_ASSOCIATION, oldValue, this.knowledgeBaseAssociation);
        }

        @Override
        public final Builder knowledgeBaseAssociation(KnowledgeBaseAssociationData knowledgeBaseAssociation) {
            Object oldValue = this.knowledgeBaseAssociation;
            this.knowledgeBaseAssociation = knowledgeBaseAssociation;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_ASSOCIATION, oldValue, this.knowledgeBaseAssociation);
            return this;
        }

        @Override
        public AssistantAssociationOutputData build() {
            return new AssistantAssociationOutputData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AssistantAssociationOutputData#type()
     */
    public enum Type {
        KNOWLEDGE_BASE_ASSOCIATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
