/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMessageTemplateAttachmentRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateMessageTemplateAttachmentRequest.Builder, CreateMessageTemplateAttachmentRequest> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(CreateMessageTemplateAttachmentRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreateMessageTemplateAttachmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentDisposition").getter(getter(CreateMessageTemplateAttachmentRequest::contentDispositionAsString))
            .setter(setter(Builder::contentDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDisposition").build())
            .build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(CreateMessageTemplateAttachmentRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateId").getter(getter(CreateMessageTemplateAttachmentRequest::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageTemplateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMessageTemplateAttachmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            CLIENT_TOKEN_FIELD, CONTENT_DISPOSITION_FIELD, KNOWLEDGE_BASE_ID_FIELD, MESSAGE_TEMPLATE_ID_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String body;

    private final String clientToken;

    private final String contentDisposition;

    private final String knowledgeBaseId;

    private final String messageTemplateId;

    private final String name;

    private CreateMessageTemplateAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.clientToken = builder.clientToken;
        this.contentDisposition = builder.contentDisposition;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The body of the attachment file being uploaded. It should be encoded using base64 encoding.
     * </p>
     * 
     * @return The body of the attachment file being uploaded. It should be encoded using base64 encoding.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The presentation information for the attachment file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentDisposition} will return {@link ContentDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentDispositionAsString}.
     * </p>
     * 
     * @return The presentation information for the attachment file.
     * @see ContentDisposition
     */
    public final ContentDisposition contentDisposition() {
        return ContentDisposition.fromValue(contentDisposition);
    }

    /**
     * <p>
     * The presentation information for the attachment file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentDisposition} will return {@link ContentDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentDispositionAsString}.
     * </p>
     * 
     * @return The presentation information for the attachment file.
     * @see ContentDisposition
     */
    public final String contentDispositionAsString() {
        return contentDisposition;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
     * </p>
     * 
     * @return The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * The name of the attachment file being uploaded. The name should include the file extension.
     * </p>
     * 
     * @return The name of the attachment file being uploaded. The name should include the file extension.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(contentDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMessageTemplateAttachmentRequest)) {
            return false;
        }
        CreateMessageTemplateAttachmentRequest other = (CreateMessageTemplateAttachmentRequest) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(contentDispositionAsString(), other.contentDispositionAsString())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(messageTemplateId(), other.messageTemplateId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMessageTemplateAttachmentRequest")
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("ClientToken", clientToken())
                .add("ContentDisposition", contentDispositionAsString()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("MessageTemplateId", messageTemplateId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "contentDisposition":
            return Optional.ofNullable(clazz.cast(contentDispositionAsString()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "messageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("body", BODY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("contentDisposition", CONTENT_DISPOSITION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMessageTemplateAttachmentRequest, T> g) {
        return obj -> g.apply((CreateMessageTemplateAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMessageTemplateAttachmentRequest> {
        /**
         * <p>
         * The body of the attachment file being uploaded. It should be encoded using base64 encoding.
         * </p>
         * 
         * @param body
         *        The body of the attachment file being uploaded. It should be encoded using base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The presentation information for the attachment file.
         * </p>
         * 
         * @param contentDisposition
         *        The presentation information for the attachment file.
         * @see ContentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentDisposition
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * <p>
         * The presentation information for the attachment file.
         * </p>
         * 
         * @param contentDisposition
         *        The presentation information for the attachment file.
         * @see ContentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentDisposition
         */
        Builder contentDisposition(ContentDisposition contentDisposition);

        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template. Can be either the ID or the ARN. It cannot contain any
         *        qualifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * The name of the attachment file being uploaded. The name should include the file extension.
         * </p>
         * 
         * @param name
         *        The name of the attachment file being uploaded. The name should include the file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String body;

        private String clientToken;

        private String contentDisposition;

        private String knowledgeBaseId;

        private String messageTemplateId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMessageTemplateAttachmentRequest model) {
            super(model);
            body(model.body);
            clientToken(model.clientToken);
            contentDisposition(model.contentDisposition);
            knowledgeBaseId(model.knowledgeBaseId);
            messageTemplateId(model.messageTemplateId);
            name(model.name);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentDisposition(ContentDisposition contentDisposition) {
            this.contentDisposition(contentDisposition == null ? null : contentDisposition.toString());
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMessageTemplateAttachmentRequest build() {
            return new CreateMessageTemplateAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
