/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMessageTemplateAttachmentResponse extends QConnectResponse implements
        ToCopyableBuilder<CreateMessageTemplateAttachmentResponse.Builder, CreateMessageTemplateAttachmentResponse> {
    private static final SdkField<MessageTemplateAttachment> ATTACHMENT_FIELD = SdkField
            .<MessageTemplateAttachment> builder(MarshallingType.SDK_POJO).memberName("attachment")
            .getter(getter(CreateMessageTemplateAttachmentResponse::attachment)).setter(setter(Builder::attachment))
            .constructor(MessageTemplateAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MessageTemplateAttachment attachment;

    private CreateMessageTemplateAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * The message template attachment.
     * </p>
     * 
     * @return The message template attachment.
     */
    public final MessageTemplateAttachment attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMessageTemplateAttachmentResponse)) {
            return false;
        }
        CreateMessageTemplateAttachmentResponse other = (CreateMessageTemplateAttachmentResponse) obj;
        return Objects.equals(attachment(), other.attachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMessageTemplateAttachmentResponse").add("Attachment", attachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachment", ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMessageTemplateAttachmentResponse, T> g) {
        return obj -> g.apply((CreateMessageTemplateAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMessageTemplateAttachmentResponse> {
        /**
         * <p>
         * The message template attachment.
         * </p>
         * 
         * @param attachment
         *        The message template attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(MessageTemplateAttachment attachment);

        /**
         * <p>
         * The message template attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateAttachment.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #attachment(MessageTemplateAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link MessageTemplateAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(MessageTemplateAttachment)
         */
        default Builder attachment(Consumer<MessageTemplateAttachment.Builder> attachment) {
            return attachment(MessageTemplateAttachment.builder().applyMutation(attachment).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private MessageTemplateAttachment attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMessageTemplateAttachmentResponse model) {
            super(model);
            attachment(model.attachment);
        }

        public final MessageTemplateAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(MessageTemplateAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(MessageTemplateAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public CreateMessageTemplateAttachmentResponse build() {
            return new CreateMessageTemplateAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
