/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMessageTemplateResponse extends QConnectResponse implements
        ToCopyableBuilder<CreateMessageTemplateResponse.Builder, CreateMessageTemplateResponse> {
    private static final SdkField<MessageTemplateData> MESSAGE_TEMPLATE_FIELD = SdkField
            .<MessageTemplateData> builder(MarshallingType.SDK_POJO).memberName("messageTemplate")
            .getter(getter(CreateMessageTemplateResponse::messageTemplate)).setter(setter(Builder::messageTemplate))
            .constructor(MessageTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MessageTemplateData messageTemplate;

    private CreateMessageTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.messageTemplate = builder.messageTemplate;
    }

    /**
     * <p>
     * The message template.
     * </p>
     * 
     * @return The message template.
     */
    public final MessageTemplateData messageTemplate() {
        return messageTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMessageTemplateResponse)) {
            return false;
        }
        CreateMessageTemplateResponse other = (CreateMessageTemplateResponse) obj;
        return Objects.equals(messageTemplate(), other.messageTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMessageTemplateResponse").add("MessageTemplate", messageTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageTemplate":
            return Optional.ofNullable(clazz.cast(messageTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageTemplate", MESSAGE_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMessageTemplateResponse, T> g) {
        return obj -> g.apply((CreateMessageTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMessageTemplateResponse> {
        /**
         * <p>
         * The message template.
         * </p>
         * 
         * @param messageTemplate
         *        The message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplate(MessageTemplateData messageTemplate);

        /**
         * <p>
         * The message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateData.Builder} avoiding the
         * need to create one manually via {@link MessageTemplateData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateData.Builder#build()} is called immediately and
         * its result is passed to {@link #messageTemplate(MessageTemplateData)}.
         * 
         * @param messageTemplate
         *        a consumer that will call methods on {@link MessageTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageTemplate(MessageTemplateData)
         */
        default Builder messageTemplate(Consumer<MessageTemplateData.Builder> messageTemplate) {
            return messageTemplate(MessageTemplateData.builder().applyMutation(messageTemplate).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private MessageTemplateData messageTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMessageTemplateResponse model) {
            super(model);
            messageTemplate(model.messageTemplate);
        }

        public final MessageTemplateData.Builder getMessageTemplate() {
            return messageTemplate != null ? messageTemplate.toBuilder() : null;
        }

        public final void setMessageTemplate(MessageTemplateData.BuilderImpl messageTemplate) {
            this.messageTemplate = messageTemplate != null ? messageTemplate.build() : null;
        }

        @Override
        public final Builder messageTemplate(MessageTemplateData messageTemplate) {
            this.messageTemplate = messageTemplate;
            return this;
        }

        @Override
        public CreateMessageTemplateResponse build() {
            return new CreateMessageTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
