/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSummary implements SdkPojo, Serializable, ToCopyableBuilder<DataSummary.Builder, DataSummary> {
    private static final SdkField<DataDetails> DETAILS_FIELD = SdkField.<DataDetails> builder(MarshallingType.SDK_POJO)
            .memberName("details").getter(getter(DataSummary::details)).setter(setter(Builder::details))
            .constructor(DataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<DataReference> REFERENCE_FIELD = SdkField.<DataReference> builder(MarshallingType.SDK_POJO)
            .memberName("reference").getter(getter(DataSummary::reference)).setter(setter(Builder::reference))
            .constructor(DataReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETAILS_FIELD, REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataDetails details;

    private final DataReference reference;

    private DataSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.reference = builder.reference;
    }

    /**
     * <p>
     * Details about the data.
     * </p>
     * 
     * @return Details about the data.
     */
    public final DataDetails details() {
        return details;
    }

    /**
     * <p>
     * Reference information about the content.
     * </p>
     * 
     * @return Reference information about the content.
     */
    public final DataReference reference() {
        return reference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSummary)) {
            return false;
        }
        DataSummary other = (DataSummary) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(reference(), other.reference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSummary").add("Details", details()).add("Reference", reference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "reference":
            return Optional.ofNullable(clazz.cast(reference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("details", DETAILS_FIELD);
        map.put("reference", REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSummary, T> g) {
        return obj -> g.apply((DataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSummary> {
        /**
         * <p>
         * Details about the data.
         * </p>
         * 
         * @param details
         *        Details about the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(DataDetails details);

        /**
         * <p>
         * Details about the data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataDetails.Builder} avoiding the need to
         * create one manually via {@link DataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #details(DataDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link DataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(DataDetails)
         */
        default Builder details(Consumer<DataDetails.Builder> details) {
            return details(DataDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * Reference information about the content.
         * </p>
         * 
         * @param reference
         *        Reference information about the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(DataReference reference);

        /**
         * <p>
         * Reference information about the content.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReference.Builder} avoiding the need
         * to create one manually via {@link DataReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReference.Builder#build()} is called immediately and its
         * result is passed to {@link #reference(DataReference)}.
         * 
         * @param reference
         *        a consumer that will call methods on {@link DataReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reference(DataReference)
         */
        default Builder reference(Consumer<DataReference.Builder> reference) {
            return reference(DataReference.builder().applyMutation(reference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataDetails details;

        private DataReference reference;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSummary model) {
            details(model.details);
            reference(model.reference);
        }

        public final DataDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(DataDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(DataDetails details) {
            this.details = details;
            return this;
        }

        public final DataReference.Builder getReference() {
            return reference != null ? reference.toBuilder() : null;
        }

        public final void setReference(DataReference.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(DataReference reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public DataSummary build() {
            return new DataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
