/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The regular expression to configure for the AI Guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailRegexConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailRegexConfig.Builder, GuardrailRegexConfig> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailRegexConfig::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GuardrailRegexConfig::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GuardrailRegexConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pattern")
            .getter(getter(GuardrailRegexConfig::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, PATTERN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String description;

    private final String name;

    private final String pattern;

    private GuardrailRegexConfig(BuilderImpl builder) {
        this.action = builder.action;
        this.description = builder.description;
        this.name = builder.name;
        this.pattern = builder.pattern;
    }

    /**
     * <p>
     * The AI Guardrail action to configure when matching regular expression is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The AI Guardrail action to configure when matching regular expression is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction action() {
        return GuardrailSensitiveInformationAction.fromValue(action);
    }

    /**
     * <p>
     * The AI Guardrail action to configure when matching regular expression is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The AI Guardrail action to configure when matching regular expression is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The description of the regular expression to configure for the AI Guardrail.
     * </p>
     * 
     * @return The description of the regular expression to configure for the AI Guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the regular expression to configure for the AI Guardrail.
     * </p>
     * 
     * @return The name of the regular expression to configure for the AI Guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The regular expression pattern to configure for the AI Guardrail.
     * </p>
     * 
     * @return The regular expression pattern to configure for the AI Guardrail.
     */
    public final String pattern() {
        return pattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailRegexConfig)) {
            return false;
        }
        GuardrailRegexConfig other = (GuardrailRegexConfig) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(pattern(), other.pattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailRegexConfig")
                .add("Action", actionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Pattern", pattern() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pattern", PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailRegexConfig, T> g) {
        return obj -> g.apply((GuardrailRegexConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailRegexConfig> {
        /**
         * <p>
         * The AI Guardrail action to configure when matching regular expression is detected.
         * </p>
         * 
         * @param action
         *        The AI Guardrail action to configure when matching regular expression is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(String action);

        /**
         * <p>
         * The AI Guardrail action to configure when matching regular expression is detected.
         * </p>
         * 
         * @param action
         *        The AI Guardrail action to configure when matching regular expression is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(GuardrailSensitiveInformationAction action);

        /**
         * <p>
         * The description of the regular expression to configure for the AI Guardrail.
         * </p>
         * 
         * @param description
         *        The description of the regular expression to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the regular expression to configure for the AI Guardrail.
         * </p>
         * 
         * @param name
         *        The name of the regular expression to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The regular expression pattern to configure for the AI Guardrail.
         * </p>
         * 
         * @param pattern
         *        The regular expression pattern to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String description;

        private String name;

        private String pattern;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailRegexConfig model) {
            action(model.action);
            description(model.description);
            name(model.name);
            pattern(model.pattern);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        public GuardrailRegexConfig build() {
            return new GuardrailRegexConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
