/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAiAgentsResponse extends QConnectResponse implements
        ToCopyableBuilder<ListAiAgentsResponse.Builder, ListAiAgentsResponse> {
    private static final SdkField<List<AIAgentSummary>> AI_AGENT_SUMMARIES_FIELD = SdkField
            .<List<AIAgentSummary>> builder(MarshallingType.LIST)
            .memberName("aiAgentSummaries")
            .getter(getter(ListAiAgentsResponse::aiAgentSummaries))
            .setter(setter(Builder::aiAgentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AIAgentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIAgentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAiAgentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AIAgentSummary> aiAgentSummaries;

    private final String nextToken;

    private ListAiAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.aiAgentSummaries = builder.aiAgentSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AiAgentSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAiAgentSummaries() {
        return aiAgentSummaries != null && !(aiAgentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of AI Agents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentSummaries} method.
     * </p>
     * 
     * @return The summaries of AI Agents.
     */
    public final List<AIAgentSummary> aiAgentSummaries() {
        return aiAgentSummaries;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAiAgentSummaries() ? aiAgentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiAgentsResponse)) {
            return false;
        }
        ListAiAgentsResponse other = (ListAiAgentsResponse) obj;
        return hasAiAgentSummaries() == other.hasAiAgentSummaries()
                && Objects.equals(aiAgentSummaries(), other.aiAgentSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAiAgentsResponse")
                .add("AiAgentSummaries", hasAiAgentSummaries() ? aiAgentSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgentSummaries":
            return Optional.ofNullable(clazz.cast(aiAgentSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiAgentSummaries", AI_AGENT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAiAgentsResponse, T> g) {
        return obj -> g.apply((ListAiAgentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAiAgentsResponse> {
        /**
         * <p>
         * The summaries of AI Agents.
         * </p>
         * 
         * @param aiAgentSummaries
         *        The summaries of AI Agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentSummaries(Collection<AIAgentSummary> aiAgentSummaries);

        /**
         * <p>
         * The summaries of AI Agents.
         * </p>
         * 
         * @param aiAgentSummaries
         *        The summaries of AI Agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentSummaries(AIAgentSummary... aiAgentSummaries);

        /**
         * <p>
         * The summaries of AI Agents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AIAgentSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.AIAgentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AIAgentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #aiAgentSummaries(List<AIAgentSummary>)}.
         * 
         * @param aiAgentSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AIAgentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiAgentSummaries(java.util.Collection<AIAgentSummary>)
         */
        Builder aiAgentSummaries(Consumer<AIAgentSummary.Builder>... aiAgentSummaries);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<AIAgentSummary> aiAgentSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiAgentsResponse model) {
            super(model);
            aiAgentSummaries(model.aiAgentSummaries);
            nextToken(model.nextToken);
        }

        public final List<AIAgentSummary.Builder> getAiAgentSummaries() {
            List<AIAgentSummary.Builder> result = AIAgentSummaryListCopier.copyToBuilder(this.aiAgentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiAgentSummaries(Collection<AIAgentSummary.BuilderImpl> aiAgentSummaries) {
            this.aiAgentSummaries = AIAgentSummaryListCopier.copyFromBuilder(aiAgentSummaries);
        }

        @Override
        public final Builder aiAgentSummaries(Collection<AIAgentSummary> aiAgentSummaries) {
            this.aiAgentSummaries = AIAgentSummaryListCopier.copy(aiAgentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgentSummaries(AIAgentSummary... aiAgentSummaries) {
            aiAgentSummaries(Arrays.asList(aiAgentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgentSummaries(Consumer<AIAgentSummary.Builder>... aiAgentSummaries) {
            aiAgentSummaries(Stream.of(aiAgentSummaries).map(c -> AIAgentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiAgentsResponse build() {
            return new ListAiAgentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
