/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageOutput implements SdkPojo, Serializable, ToCopyableBuilder<MessageOutput.Builder, MessageOutput> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(MessageOutput::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> PARTICIPANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participant").getter(getter(MessageOutput::participantAsString)).setter(setter(Builder::participant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participant").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(MessageOutput::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<MessageData> VALUE_FIELD = SdkField.<MessageData> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(MessageOutput::value)).setter(setter(Builder::value))
            .constructor(MessageData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            PARTICIPANT_FIELD, TIMESTAMP_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String participant;

    private final Instant timestamp;

    private final MessageData value;

    private MessageOutput(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.participant = builder.participant;
        this.timestamp = builder.timestamp;
        this.value = builder.value;
    }

    /**
     * <p>
     * The identifier of a message.
     * </p>
     * 
     * @return The identifier of a message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The participant of a message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participant} will
     * return {@link Participant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #participantAsString}.
     * </p>
     * 
     * @return The participant of a message.
     * @see Participant
     */
    public final Participant participant() {
        return Participant.fromValue(participant);
    }

    /**
     * <p>
     * The participant of a message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participant} will
     * return {@link Participant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #participantAsString}.
     * </p>
     * 
     * @return The participant of a message.
     * @see Participant
     */
    public final String participantAsString() {
        return participant;
    }

    /**
     * <p>
     * The timestamp of a message.
     * </p>
     * 
     * @return The timestamp of a message.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The value of a message data.
     * </p>
     * 
     * @return The value of a message data.
     */
    public final MessageData value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(participantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageOutput)) {
            return false;
        }
        MessageOutput other = (MessageOutput) obj;
        return Objects.equals(messageId(), other.messageId())
                && Objects.equals(participantAsString(), other.participantAsString())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageOutput").add("MessageId", messageId()).add("Participant", participantAsString())
                .add("Timestamp", timestamp()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "participant":
            return Optional.ofNullable(clazz.cast(participantAsString()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("participant", PARTICIPANT_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageOutput, T> g) {
        return obj -> g.apply((MessageOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageOutput> {
        /**
         * <p>
         * The identifier of a message.
         * </p>
         * 
         * @param messageId
         *        The identifier of a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The participant of a message.
         * </p>
         * 
         * @param participant
         *        The participant of a message.
         * @see Participant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Participant
         */
        Builder participant(String participant);

        /**
         * <p>
         * The participant of a message.
         * </p>
         * 
         * @param participant
         *        The participant of a message.
         * @see Participant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Participant
         */
        Builder participant(Participant participant);

        /**
         * <p>
         * The timestamp of a message.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The value of a message data.
         * </p>
         * 
         * @param value
         *        The value of a message data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MessageData value);

        /**
         * <p>
         * The value of a message data.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageData.Builder} avoiding the need to
         * create one manually via {@link MessageData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageData.Builder#build()} is called immediately and its result
         * is passed to {@link #value(MessageData)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MessageData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MessageData)
         */
        default Builder value(Consumer<MessageData.Builder> value) {
            return value(MessageData.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String participant;

        private Instant timestamp;

        private MessageData value;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageOutput model) {
            messageId(model.messageId);
            participant(model.participant);
            timestamp(model.timestamp);
            value(model.value);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getParticipant() {
            return participant;
        }

        public final void setParticipant(String participant) {
            this.participant = participant;
        }

        @Override
        public final Builder participant(String participant) {
            this.participant = participant;
            return this;
        }

        @Override
        public final Builder participant(Participant participant) {
            this.participant(participant == null ? null : participant.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final MessageData.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MessageData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MessageData value) {
            this.value = value;
            return this;
        }

        @Override
        public MessageOutput build() {
            return new MessageOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
