/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the source content ranking data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RankingData implements SdkPojo, Serializable, ToCopyableBuilder<RankingData.Builder, RankingData> {
    private static final SdkField<String> RELEVANCE_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relevanceLevel").getter(getter(RankingData::relevanceLevelAsString))
            .setter(setter(Builder::relevanceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceLevel").build()).build();

    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("relevanceScore").getter(getter(RankingData::relevanceScore)).setter(setter(Builder::relevanceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEVANCE_LEVEL_FIELD,
            RELEVANCE_SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relevanceLevel;

    private final Double relevanceScore;

    private RankingData(BuilderImpl builder) {
        this.relevanceLevel = builder.relevanceLevel;
        this.relevanceScore = builder.relevanceScore;
    }

    /**
     * <p>
     * The relevance score of the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevanceLevel}
     * will return {@link RelevanceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relevanceLevelAsString}.
     * </p>
     * 
     * @return The relevance score of the content.
     * @see RelevanceLevel
     */
    public final RelevanceLevel relevanceLevel() {
        return RelevanceLevel.fromValue(relevanceLevel);
    }

    /**
     * <p>
     * The relevance score of the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevanceLevel}
     * will return {@link RelevanceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relevanceLevelAsString}.
     * </p>
     * 
     * @return The relevance score of the content.
     * @see RelevanceLevel
     */
    public final String relevanceLevelAsString() {
        return relevanceLevel;
    }

    /**
     * <p>
     * The relevance level of the recommendation.
     * </p>
     * 
     * @return The relevance level of the recommendation.
     */
    public final Double relevanceScore() {
        return relevanceScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relevanceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RankingData)) {
            return false;
        }
        RankingData other = (RankingData) obj;
        return Objects.equals(relevanceLevelAsString(), other.relevanceLevelAsString())
                && Objects.equals(relevanceScore(), other.relevanceScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RankingData").add("RelevanceLevel", relevanceLevelAsString())
                .add("RelevanceScore", relevanceScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relevanceLevel":
            return Optional.ofNullable(clazz.cast(relevanceLevelAsString()));
        case "relevanceScore":
            return Optional.ofNullable(clazz.cast(relevanceScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relevanceLevel", RELEVANCE_LEVEL_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RankingData, T> g) {
        return obj -> g.apply((RankingData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RankingData> {
        /**
         * <p>
         * The relevance score of the content.
         * </p>
         * 
         * @param relevanceLevel
         *        The relevance score of the content.
         * @see RelevanceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelevanceLevel
         */
        Builder relevanceLevel(String relevanceLevel);

        /**
         * <p>
         * The relevance score of the content.
         * </p>
         * 
         * @param relevanceLevel
         *        The relevance score of the content.
         * @see RelevanceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelevanceLevel
         */
        Builder relevanceLevel(RelevanceLevel relevanceLevel);

        /**
         * <p>
         * The relevance level of the recommendation.
         * </p>
         * 
         * @param relevanceScore
         *        The relevance level of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceScore(Double relevanceScore);
    }

    static final class BuilderImpl implements Builder {
        private String relevanceLevel;

        private Double relevanceScore;

        private BuilderImpl() {
        }

        private BuilderImpl(RankingData model) {
            relevanceLevel(model.relevanceLevel);
            relevanceScore(model.relevanceScore);
        }

        public final String getRelevanceLevel() {
            return relevanceLevel;
        }

        public final void setRelevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
        }

        @Override
        public final Builder relevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
            return this;
        }

        @Override
        public final Builder relevanceLevel(RelevanceLevel relevanceLevel) {
            this.relevanceLevel(relevanceLevel == null ? null : relevanceLevel.toString());
            return this;
        }

        public final Double getRelevanceScore() {
            return relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        @Override
        public RankingData build() {
            return new RankingData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
