/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conversation history data to included in conversation context data before the the Amazon Q in Connect session..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfServiceConversationHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfServiceConversationHistory.Builder, SelfServiceConversationHistory> {
    private static final SdkField<String> BOT_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botResponse").getter(getter(SelfServiceConversationHistory::botResponse))
            .setter(setter(Builder::botResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botResponse").build()).build();

    private static final SdkField<String> INPUT_TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputTranscript").getter(getter(SelfServiceConversationHistory::inputTranscript))
            .setter(setter(Builder::inputTranscript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTranscript").build()).build();

    private static final SdkField<Integer> TURN_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("turnNumber").getter(getter(SelfServiceConversationHistory::turnNumber))
            .setter(setter(Builder::turnNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turnNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_RESPONSE_FIELD,
            INPUT_TRANSCRIPT_FIELD, TURN_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botResponse;

    private final String inputTranscript;

    private final Integer turnNumber;

    private SelfServiceConversationHistory(BuilderImpl builder) {
        this.botResponse = builder.botResponse;
        this.inputTranscript = builder.inputTranscript;
        this.turnNumber = builder.turnNumber;
    }

    /**
     * <p>
     * The bot response of the conversation history data.
     * </p>
     * 
     * @return The bot response of the conversation history data.
     */
    public final String botResponse() {
        return botResponse;
    }

    /**
     * <p>
     * The input transcript of the conversation history data.
     * </p>
     * 
     * @return The input transcript of the conversation history data.
     */
    public final String inputTranscript() {
        return inputTranscript;
    }

    /**
     * <p>
     * The number of turn of the conversation history data.
     * </p>
     * 
     * @return The number of turn of the conversation history data.
     */
    public final Integer turnNumber() {
        return turnNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botResponse());
        hashCode = 31 * hashCode + Objects.hashCode(inputTranscript());
        hashCode = 31 * hashCode + Objects.hashCode(turnNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfServiceConversationHistory)) {
            return false;
        }
        SelfServiceConversationHistory other = (SelfServiceConversationHistory) obj;
        return Objects.equals(botResponse(), other.botResponse()) && Objects.equals(inputTranscript(), other.inputTranscript())
                && Objects.equals(turnNumber(), other.turnNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfServiceConversationHistory")
                .add("BotResponse", botResponse() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InputTranscript", inputTranscript() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TurnNumber", turnNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botResponse":
            return Optional.ofNullable(clazz.cast(botResponse()));
        case "inputTranscript":
            return Optional.ofNullable(clazz.cast(inputTranscript()));
        case "turnNumber":
            return Optional.ofNullable(clazz.cast(turnNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botResponse", BOT_RESPONSE_FIELD);
        map.put("inputTranscript", INPUT_TRANSCRIPT_FIELD);
        map.put("turnNumber", TURN_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfServiceConversationHistory, T> g) {
        return obj -> g.apply((SelfServiceConversationHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfServiceConversationHistory> {
        /**
         * <p>
         * The bot response of the conversation history data.
         * </p>
         * 
         * @param botResponse
         *        The bot response of the conversation history data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botResponse(String botResponse);

        /**
         * <p>
         * The input transcript of the conversation history data.
         * </p>
         * 
         * @param inputTranscript
         *        The input transcript of the conversation history data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTranscript(String inputTranscript);

        /**
         * <p>
         * The number of turn of the conversation history data.
         * </p>
         * 
         * @param turnNumber
         *        The number of turn of the conversation history data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnNumber(Integer turnNumber);
    }

    static final class BuilderImpl implements Builder {
        private String botResponse;

        private String inputTranscript;

        private Integer turnNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfServiceConversationHistory model) {
            botResponse(model.botResponse);
            inputTranscript(model.inputTranscript);
            turnNumber(model.turnNumber);
        }

        public final String getBotResponse() {
            return botResponse;
        }

        public final void setBotResponse(String botResponse) {
            this.botResponse = botResponse;
        }

        @Override
        public final Builder botResponse(String botResponse) {
            this.botResponse = botResponse;
            return this;
        }

        public final String getInputTranscript() {
            return inputTranscript;
        }

        public final void setInputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
        }

        @Override
        public final Builder inputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
            return this;
        }

        public final Integer getTurnNumber() {
            return turnNumber;
        }

        public final void setTurnNumber(Integer turnNumber) {
            this.turnNumber = turnNumber;
        }

        @Override
        public final Builder turnNumber(Integer turnNumber) {
            this.turnNumber = turnNumber;
            return this;
        }

        @Override
        public SelfServiceConversationHistory build() {
            return new SelfServiceConversationHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
