/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageRequest extends QConnectRequest implements
        ToCopyableBuilder<SendMessageRequest.Builder, SendMessageRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(SendMessageRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(SendMessageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ConversationContext> CONVERSATION_CONTEXT_FIELD = SdkField
            .<ConversationContext> builder(MarshallingType.SDK_POJO).memberName("conversationContext")
            .getter(getter(SendMessageRequest::conversationContext)).setter(setter(Builder::conversationContext))
            .constructor(ConversationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationContext").build())
            .build();

    private static final SdkField<MessageInput> MESSAGE_FIELD = SdkField.<MessageInput> builder(MarshallingType.SDK_POJO)
            .memberName("message").getter(getter(SendMessageRequest::message)).setter(setter(Builder::message))
            .constructor(MessageInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SendMessageRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SendMessageRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            CLIENT_TOKEN_FIELD, CONVERSATION_CONTEXT_FIELD, MESSAGE_FIELD, SESSION_ID_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String clientToken;

    private final ConversationContext conversationContext;

    private final MessageInput message;

    private final String sessionId;

    private final String type;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.clientToken = builder.clientToken;
        this.conversationContext = builder.conversationContext;
        this.message = builder.message;
        this.sessionId = builder.sessionId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the AWS SDK populates this field.For more information about idempotency, see Making retries safe with idempotent
     * APIs.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the AWS SDK populates this field.For more information about idempotency, see Making retries
     *         safe with idempotent APIs.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The conversation context before the Amazon Q in Connect session.
     * </p>
     * 
     * @return The conversation context before the Amazon Q in Connect session.
     */
    public final ConversationContext conversationContext() {
        return conversationContext;
    }

    /**
     * <p>
     * The message data to submit to the Amazon Q in Connect session.
     * </p>
     * 
     * @return The message data to submit to the Amazon Q in Connect session.
     */
    public final MessageInput message() {
        return message;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect session.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The message type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The message type.
     * @see MessageType
     */
    public final MessageType type() {
        return MessageType.fromValue(type);
    }

    /**
     * <p>
     * The message type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The message type.
     * @see MessageType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(conversationContext());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(conversationContext(), other.conversationContext())
                && Objects.equals(message(), other.message()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageRequest").add("AssistantId", assistantId()).add("ClientToken", clientToken())
                .add("ConversationContext", conversationContext()).add("Message", message()).add("SessionId", sessionId())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "conversationContext":
            return Optional.ofNullable(clazz.cast(conversationContext()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("conversationContext", CONVERSATION_CONTEXT_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendMessageRequest, T> g) {
        return obj -> g.apply((SendMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the AWS SDK populates this field.For more information about idempotency, see Making retries safe
         * with idempotent APIs.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the AWS SDK populates this field.For more information about idempotency, see Making retries
         *        safe with idempotent APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The conversation context before the Amazon Q in Connect session.
         * </p>
         * 
         * @param conversationContext
         *        The conversation context before the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationContext(ConversationContext conversationContext);

        /**
         * <p>
         * The conversation context before the Amazon Q in Connect session.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationContext.Builder} avoiding the
         * need to create one manually via {@link ConversationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationContext.Builder#build()} is called immediately and
         * its result is passed to {@link #conversationContext(ConversationContext)}.
         * 
         * @param conversationContext
         *        a consumer that will call methods on {@link ConversationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationContext(ConversationContext)
         */
        default Builder conversationContext(Consumer<ConversationContext.Builder> conversationContext) {
            return conversationContext(ConversationContext.builder().applyMutation(conversationContext).build());
        }

        /**
         * <p>
         * The message data to submit to the Amazon Q in Connect session.
         * </p>
         * 
         * @param message
         *        The message data to submit to the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(MessageInput message);

        /**
         * <p>
         * The message data to submit to the Amazon Q in Connect session.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageInput.Builder} avoiding the need
         * to create one manually via {@link MessageInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageInput.Builder#build()} is called immediately and its
         * result is passed to {@link #message(MessageInput)}.
         * 
         * @param message
         *        a consumer that will call methods on {@link MessageInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #message(MessageInput)
         */
        default Builder message(Consumer<MessageInput.Builder> message) {
            return message(MessageInput.builder().applyMutation(message).build());
        }

        /**
         * <p>
         * The identifier of the Amazon Q in Connect session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The message type.
         * </p>
         * 
         * @param type
         *        The message type.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(String type);

        /**
         * <p>
         * The message type.
         * </p>
         * 
         * @param type
         *        The message type.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(MessageType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String clientToken;

        private ConversationContext conversationContext;

        private MessageInput message;

        private String sessionId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            super(model);
            assistantId(model.assistantId);
            clientToken(model.clientToken);
            conversationContext(model.conversationContext);
            message(model.message);
            sessionId(model.sessionId);
            type(model.type);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ConversationContext.Builder getConversationContext() {
            return conversationContext != null ? conversationContext.toBuilder() : null;
        }

        public final void setConversationContext(ConversationContext.BuilderImpl conversationContext) {
            this.conversationContext = conversationContext != null ? conversationContext.build() : null;
        }

        @Override
        public final Builder conversationContext(ConversationContext conversationContext) {
            this.conversationContext = conversationContext;
            return this;
        }

        public final MessageInput.Builder getMessage() {
            return message != null ? message.toBuilder() : null;
        }

        public final void setMessage(MessageInput.BuilderImpl message) {
            this.message = message != null ? message.build() : null;
        }

        @Override
        public final Builder message(MessageInput message) {
            this.message = message;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
