/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportJobResponse extends QConnectResponse implements
        ToCopyableBuilder<StartImportJobResponse.Builder, StartImportJobResponse> {
    private static final SdkField<ImportJobData> IMPORT_JOB_FIELD = SdkField.<ImportJobData> builder(MarshallingType.SDK_POJO)
            .memberName("importJob").getter(getter(StartImportJobResponse::importJob)).setter(setter(Builder::importJob))
            .constructor(ImportJobData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ImportJobData importJob;

    private StartImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.importJob = builder.importJob;
    }

    /**
     * <p>
     * The import job.
     * </p>
     * 
     * @return The import job.
     */
    public final ImportJobData importJob() {
        return importJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportJobResponse)) {
            return false;
        }
        StartImportJobResponse other = (StartImportJobResponse) obj;
        return Objects.equals(importJob(), other.importJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportJobResponse").add("ImportJob", importJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importJob":
            return Optional.ofNullable(clazz.cast(importJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("importJob", IMPORT_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportJobResponse, T> g) {
        return obj -> g.apply((StartImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartImportJobResponse> {
        /**
         * <p>
         * The import job.
         * </p>
         * 
         * @param importJob
         *        The import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJob(ImportJobData importJob);

        /**
         * <p>
         * The import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportJobData.Builder} avoiding the need
         * to create one manually via {@link ImportJobData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportJobData.Builder#build()} is called immediately and its
         * result is passed to {@link #importJob(ImportJobData)}.
         * 
         * @param importJob
         *        a consumer that will call methods on {@link ImportJobData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJob(ImportJobData)
         */
        default Builder importJob(Consumer<ImportJobData.Builder> importJob) {
            return importJob(ImportJobData.builder().applyMutation(importJob).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private ImportJobData importJob;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportJobResponse model) {
            super(model);
            importJob(model.importJob);
        }

        public final ImportJobData.Builder getImportJob() {
            return importJob != null ? importJob.toBuilder() : null;
        }

        public final void setImportJob(ImportJobData.BuilderImpl importJob) {
            this.importJob = importJob != null ? importJob.build() : null;
        }

        @Override
        public final Builder importJob(ImportJobData importJob) {
            this.importJob = importJob;
            return this;
        }

        @Override
        public StartImportJobResponse build() {
            return new StartImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
