/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The date configuration of the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnchorDateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnchorDateConfiguration.Builder, AnchorDateConfiguration> {
    private static final SdkField<String> ANCHOR_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnchorOption").getter(getter(AnchorDateConfiguration::anchorOptionAsString))
            .setter(setter(Builder::anchorOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnchorOption").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(AnchorDateConfiguration::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_OPTION_FIELD,
            PARAMETER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String anchorOption;

    private final String parameterName;

    private AnchorDateConfiguration(BuilderImpl builder) {
        this.anchorOption = builder.anchorOption;
        this.parameterName = builder.parameterName;
    }

    /**
     * <p>
     * The options for the date configuration. Choose one of the options below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #anchorOption} will
     * return {@link AnchorOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #anchorOptionAsString}.
     * </p>
     * 
     * @return The options for the date configuration. Choose one of the options below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code>
     *         </p>
     *         </li>
     * @see AnchorOption
     */
    public final AnchorOption anchorOption() {
        return AnchorOption.fromValue(anchorOption);
    }

    /**
     * <p>
     * The options for the date configuration. Choose one of the options below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #anchorOption} will
     * return {@link AnchorOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #anchorOptionAsString}.
     * </p>
     * 
     * @return The options for the date configuration. Choose one of the options below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code>
     *         </p>
     *         </li>
     * @see AnchorOption
     */
    public final String anchorOptionAsString() {
        return anchorOption;
    }

    /**
     * <p>
     * The name of the parameter that is used for the anchor date configuration.
     * </p>
     * 
     * @return The name of the parameter that is used for the anchor date configuration.
     */
    public final String parameterName() {
        return parameterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anchorOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnchorDateConfiguration)) {
            return false;
        }
        AnchorDateConfiguration other = (AnchorDateConfiguration) obj;
        return Objects.equals(anchorOptionAsString(), other.anchorOptionAsString())
                && Objects.equals(parameterName(), other.parameterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnchorDateConfiguration").add("AnchorOption", anchorOptionAsString())
                .add("ParameterName", parameterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnchorOption":
            return Optional.ofNullable(clazz.cast(anchorOptionAsString()));
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnchorOption", ANCHOR_OPTION_FIELD);
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnchorDateConfiguration, T> g) {
        return obj -> g.apply((AnchorDateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnchorDateConfiguration> {
        /**
         * <p>
         * The options for the date configuration. Choose one of the options below:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param anchorOption
         *        The options for the date configuration. Choose one of the options below:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code>
         *        </p>
         *        </li>
         * @see AnchorOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnchorOption
         */
        Builder anchorOption(String anchorOption);

        /**
         * <p>
         * The options for the date configuration. Choose one of the options below:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param anchorOption
         *        The options for the date configuration. Choose one of the options below:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code>
         *        </p>
         *        </li>
         * @see AnchorOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnchorOption
         */
        Builder anchorOption(AnchorOption anchorOption);

        /**
         * <p>
         * The name of the parameter that is used for the anchor date configuration.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter that is used for the anchor date configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);
    }

    static final class BuilderImpl implements Builder {
        private String anchorOption;

        private String parameterName;

        private BuilderImpl() {
        }

        private BuilderImpl(AnchorDateConfiguration model) {
            anchorOption(model.anchorOption);
            parameterName(model.parameterName);
        }

        public final String getAnchorOption() {
            return anchorOption;
        }

        public final void setAnchorOption(String anchorOption) {
            this.anchorOption = anchorOption;
        }

        @Override
        public final Builder anchorOption(String anchorOption) {
            this.anchorOption = anchorOption;
            return this;
        }

        @Override
        public final Builder anchorOption(AnchorOption anchorOption) {
            this.anchorOption(anchorOption == null ? null : anchorOption.toString());
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        @Override
        public AnchorDateConfiguration build() {
            return new AnchorDateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
