/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional structure that configures resource ID overrides for the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobResourceIdOverrideConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleImportJobResourceIdOverrideConfiguration.Builder, AssetBundleImportJobResourceIdOverrideConfiguration> {
    private static final SdkField<String> PREFIX_FOR_ALL_RESOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrefixForAllResources")
            .getter(getter(AssetBundleImportJobResourceIdOverrideConfiguration::prefixForAllResources))
            .setter(setter(Builder::prefixForAllResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixForAllResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PREFIX_FOR_ALL_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String prefixForAllResources;

    private AssetBundleImportJobResourceIdOverrideConfiguration(BuilderImpl builder) {
        this.prefixForAllResources = builder.prefixForAllResources;
    }

    /**
     * <p>
     * An option to request a CloudFormation variable for a prefix to be prepended to each resource's ID before import.
     * The prefix is only added to the asset IDs and does not change the name of the asset.
     * </p>
     * 
     * @return An option to request a CloudFormation variable for a prefix to be prepended to each resource's ID before
     *         import. The prefix is only added to the asset IDs and does not change the name of the asset.
     */
    public final String prefixForAllResources() {
        return prefixForAllResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefixForAllResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobResourceIdOverrideConfiguration)) {
            return false;
        }
        AssetBundleImportJobResourceIdOverrideConfiguration other = (AssetBundleImportJobResourceIdOverrideConfiguration) obj;
        return Objects.equals(prefixForAllResources(), other.prefixForAllResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobResourceIdOverrideConfiguration")
                .add("PrefixForAllResources", prefixForAllResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrefixForAllResources":
            return Optional.ofNullable(clazz.cast(prefixForAllResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrefixForAllResources", PREFIX_FOR_ALL_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobResourceIdOverrideConfiguration, T> g) {
        return obj -> g.apply((AssetBundleImportJobResourceIdOverrideConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobResourceIdOverrideConfiguration> {
        /**
         * <p>
         * An option to request a CloudFormation variable for a prefix to be prepended to each resource's ID before
         * import. The prefix is only added to the asset IDs and does not change the name of the asset.
         * </p>
         * 
         * @param prefixForAllResources
         *        An option to request a CloudFormation variable for a prefix to be prepended to each resource's ID
         *        before import. The prefix is only added to the asset IDs and does not change the name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixForAllResources(String prefixForAllResources);
    }

    static final class BuilderImpl implements Builder {
        private String prefixForAllResources;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobResourceIdOverrideConfiguration model) {
            prefixForAllResources(model.prefixForAllResources);
        }

        public final String getPrefixForAllResources() {
            return prefixForAllResources;
        }

        public final void setPrefixForAllResources(String prefixForAllResources) {
            this.prefixForAllResources = prefixForAllResources;
        }

        @Override
        public final Builder prefixForAllResources(String prefixForAllResources) {
            this.prefixForAllResources = prefixForAllResources;
            return this;
        }

        @Override
        public AssetBundleImportJobResourceIdOverrideConfiguration build() {
            return new AssetBundleImportJobResourceIdOverrideConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
