/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The range setup of a numeric axis display range.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisDisplayRange implements SdkPojo, Serializable,
        ToCopyableBuilder<AxisDisplayRange.Builder, AxisDisplayRange> {
    private static final SdkField<AxisDisplayMinMaxRange> MIN_MAX_FIELD = SdkField
            .<AxisDisplayMinMaxRange> builder(MarshallingType.SDK_POJO).memberName("MinMax")
            .getter(getter(AxisDisplayRange::minMax)).setter(setter(Builder::minMax))
            .constructor(AxisDisplayMinMaxRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinMax").build()).build();

    private static final SdkField<AxisDisplayDataDrivenRange> DATA_DRIVEN_FIELD = SdkField
            .<AxisDisplayDataDrivenRange> builder(MarshallingType.SDK_POJO).memberName("DataDriven")
            .getter(getter(AxisDisplayRange::dataDriven)).setter(setter(Builder::dataDriven))
            .constructor(AxisDisplayDataDrivenRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDriven").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_MAX_FIELD,
            DATA_DRIVEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AxisDisplayMinMaxRange minMax;

    private final AxisDisplayDataDrivenRange dataDriven;

    private AxisDisplayRange(BuilderImpl builder) {
        this.minMax = builder.minMax;
        this.dataDriven = builder.dataDriven;
    }

    /**
     * <p>
     * The minimum and maximum setup of an axis display range.
     * </p>
     * 
     * @return The minimum and maximum setup of an axis display range.
     */
    public final AxisDisplayMinMaxRange minMax() {
        return minMax;
    }

    /**
     * <p>
     * The data-driven setup of an axis display range.
     * </p>
     * 
     * @return The data-driven setup of an axis display range.
     */
    public final AxisDisplayDataDrivenRange dataDriven() {
        return dataDriven;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minMax());
        hashCode = 31 * hashCode + Objects.hashCode(dataDriven());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisDisplayRange)) {
            return false;
        }
        AxisDisplayRange other = (AxisDisplayRange) obj;
        return Objects.equals(minMax(), other.minMax()) && Objects.equals(dataDriven(), other.dataDriven());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisDisplayRange").add("MinMax", minMax()).add("DataDriven", dataDriven()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinMax":
            return Optional.ofNullable(clazz.cast(minMax()));
        case "DataDriven":
            return Optional.ofNullable(clazz.cast(dataDriven()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinMax", MIN_MAX_FIELD);
        map.put("DataDriven", DATA_DRIVEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisDisplayRange, T> g) {
        return obj -> g.apply((AxisDisplayRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisDisplayRange> {
        /**
         * <p>
         * The minimum and maximum setup of an axis display range.
         * </p>
         * 
         * @param minMax
         *        The minimum and maximum setup of an axis display range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMax(AxisDisplayMinMaxRange minMax);

        /**
         * <p>
         * The minimum and maximum setup of an axis display range.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayMinMaxRange.Builder} avoiding
         * the need to create one manually via {@link AxisDisplayMinMaxRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayMinMaxRange.Builder#build()} is called immediately and
         * its result is passed to {@link #minMax(AxisDisplayMinMaxRange)}.
         * 
         * @param minMax
         *        a consumer that will call methods on {@link AxisDisplayMinMaxRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minMax(AxisDisplayMinMaxRange)
         */
        default Builder minMax(Consumer<AxisDisplayMinMaxRange.Builder> minMax) {
            return minMax(AxisDisplayMinMaxRange.builder().applyMutation(minMax).build());
        }

        /**
         * <p>
         * The data-driven setup of an axis display range.
         * </p>
         * 
         * @param dataDriven
         *        The data-driven setup of an axis display range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDriven(AxisDisplayDataDrivenRange dataDriven);

        /**
         * <p>
         * The data-driven setup of an axis display range.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayDataDrivenRange.Builder}
         * avoiding the need to create one manually via {@link AxisDisplayDataDrivenRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayDataDrivenRange.Builder#build()} is called immediately
         * and its result is passed to {@link #dataDriven(AxisDisplayDataDrivenRange)}.
         * 
         * @param dataDriven
         *        a consumer that will call methods on {@link AxisDisplayDataDrivenRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataDriven(AxisDisplayDataDrivenRange)
         */
        default Builder dataDriven(Consumer<AxisDisplayDataDrivenRange.Builder> dataDriven) {
            return dataDriven(AxisDisplayDataDrivenRange.builder().applyMutation(dataDriven).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AxisDisplayMinMaxRange minMax;

        private AxisDisplayDataDrivenRange dataDriven;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisDisplayRange model) {
            minMax(model.minMax);
            dataDriven(model.dataDriven);
        }

        public final AxisDisplayMinMaxRange.Builder getMinMax() {
            return minMax != null ? minMax.toBuilder() : null;
        }

        public final void setMinMax(AxisDisplayMinMaxRange.BuilderImpl minMax) {
            this.minMax = minMax != null ? minMax.build() : null;
        }

        @Override
        public final Builder minMax(AxisDisplayMinMaxRange minMax) {
            this.minMax = minMax;
            return this;
        }

        public final AxisDisplayDataDrivenRange.Builder getDataDriven() {
            return dataDriven != null ? dataDriven.toBuilder() : null;
        }

        public final void setDataDriven(AxisDisplayDataDrivenRange.BuilderImpl dataDriven) {
            this.dataDriven = dataDriven != null ? dataDriven.build() : null;
        }

        @Override
        public final Builder dataDriven(AxisDisplayDataDrivenRange dataDriven) {
            this.dataDriven = dataDriven;
            return this;
        }

        @Override
        public AxisDisplayRange build() {
            return new AxisDisplayRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
