/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the brand.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrandDefinition implements SdkPojo, Serializable, ToCopyableBuilder<BrandDefinition.Builder, BrandDefinition> {
    private static final SdkField<String> BRAND_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandName").getter(getter(BrandDefinition::brandName)).setter(setter(Builder::brandName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(BrandDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApplicationTheme> APPLICATION_THEME_FIELD = SdkField
            .<ApplicationTheme> builder(MarshallingType.SDK_POJO).memberName("ApplicationTheme")
            .getter(getter(BrandDefinition::applicationTheme)).setter(setter(Builder::applicationTheme))
            .constructor(ApplicationTheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTheme").build()).build();

    private static final SdkField<LogoConfiguration> LOGO_CONFIGURATION_FIELD = SdkField
            .<LogoConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogoConfiguration")
            .getter(getter(BrandDefinition::logoConfiguration)).setter(setter(Builder::logoConfiguration))
            .constructor(LogoConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_NAME_FIELD,
            DESCRIPTION_FIELD, APPLICATION_THEME_FIELD, LOGO_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String brandName;

    private final String description;

    private final ApplicationTheme applicationTheme;

    private final LogoConfiguration logoConfiguration;

    private BrandDefinition(BuilderImpl builder) {
        this.brandName = builder.brandName;
        this.description = builder.description;
        this.applicationTheme = builder.applicationTheme;
        this.logoConfiguration = builder.logoConfiguration;
    }

    /**
     * <p>
     * The name of the brand.
     * </p>
     * 
     * @return The name of the brand.
     */
    public final String brandName() {
        return brandName;
    }

    /**
     * <p>
     * The description of the brand.
     * </p>
     * 
     * @return The description of the brand.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The application theme of the brand.
     * </p>
     * 
     * @return The application theme of the brand.
     */
    public final ApplicationTheme applicationTheme() {
        return applicationTheme;
    }

    /**
     * <p>
     * The logo configuration of the brand.
     * </p>
     * 
     * @return The logo configuration of the brand.
     */
    public final LogoConfiguration logoConfiguration() {
        return logoConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brandName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTheme());
        hashCode = 31 * hashCode + Objects.hashCode(logoConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandDefinition)) {
            return false;
        }
        BrandDefinition other = (BrandDefinition) obj;
        return Objects.equals(brandName(), other.brandName()) && Objects.equals(description(), other.description())
                && Objects.equals(applicationTheme(), other.applicationTheme())
                && Objects.equals(logoConfiguration(), other.logoConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrandDefinition").add("BrandName", brandName()).add("Description", description())
                .add("ApplicationTheme", applicationTheme()).add("LogoConfiguration", logoConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrandName":
            return Optional.ofNullable(clazz.cast(brandName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ApplicationTheme":
            return Optional.ofNullable(clazz.cast(applicationTheme()));
        case "LogoConfiguration":
            return Optional.ofNullable(clazz.cast(logoConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BrandName", BRAND_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicationTheme", APPLICATION_THEME_FIELD);
        map.put("LogoConfiguration", LOGO_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandDefinition, T> g) {
        return obj -> g.apply((BrandDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrandDefinition> {
        /**
         * <p>
         * The name of the brand.
         * </p>
         * 
         * @param brandName
         *        The name of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandName(String brandName);

        /**
         * <p>
         * The description of the brand.
         * </p>
         * 
         * @param description
         *        The description of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The application theme of the brand.
         * </p>
         * 
         * @param applicationTheme
         *        The application theme of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTheme(ApplicationTheme applicationTheme);

        /**
         * <p>
         * The application theme of the brand.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationTheme.Builder} avoiding the
         * need to create one manually via {@link ApplicationTheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationTheme.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationTheme(ApplicationTheme)}.
         * 
         * @param applicationTheme
         *        a consumer that will call methods on {@link ApplicationTheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationTheme(ApplicationTheme)
         */
        default Builder applicationTheme(Consumer<ApplicationTheme.Builder> applicationTheme) {
            return applicationTheme(ApplicationTheme.builder().applyMutation(applicationTheme).build());
        }

        /**
         * <p>
         * The logo configuration of the brand.
         * </p>
         * 
         * @param logoConfiguration
         *        The logo configuration of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoConfiguration(LogoConfiguration logoConfiguration);

        /**
         * <p>
         * The logo configuration of the brand.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogoConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogoConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogoConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logoConfiguration(LogoConfiguration)}.
         * 
         * @param logoConfiguration
         *        a consumer that will call methods on {@link LogoConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logoConfiguration(LogoConfiguration)
         */
        default Builder logoConfiguration(Consumer<LogoConfiguration.Builder> logoConfiguration) {
            return logoConfiguration(LogoConfiguration.builder().applyMutation(logoConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String brandName;

        private String description;

        private ApplicationTheme applicationTheme;

        private LogoConfiguration logoConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandDefinition model) {
            brandName(model.brandName);
            description(model.description);
            applicationTheme(model.applicationTheme);
            logoConfiguration(model.logoConfiguration);
        }

        public final String getBrandName() {
            return brandName;
        }

        public final void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        @Override
        public final Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationTheme.Builder getApplicationTheme() {
            return applicationTheme != null ? applicationTheme.toBuilder() : null;
        }

        public final void setApplicationTheme(ApplicationTheme.BuilderImpl applicationTheme) {
            this.applicationTheme = applicationTheme != null ? applicationTheme.build() : null;
        }

        @Override
        public final Builder applicationTheme(ApplicationTheme applicationTheme) {
            this.applicationTheme = applicationTheme;
            return this;
        }

        public final LogoConfiguration.Builder getLogoConfiguration() {
            return logoConfiguration != null ? logoConfiguration.toBuilder() : null;
        }

        public final void setLogoConfiguration(LogoConfiguration.BuilderImpl logoConfiguration) {
            this.logoConfiguration = logoConfiguration != null ? logoConfiguration.build() : null;
        }

        @Override
        public final Builder logoConfiguration(LogoConfiguration logoConfiguration) {
            this.logoConfiguration = logoConfiguration;
            return this;
        }

        @Override
        public BrandDefinition build() {
            return new BrandDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
