/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a comparative order.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComparativeOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<ComparativeOrder.Builder, ComparativeOrder> {
    private static final SdkField<String> USE_ORDERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseOrdering").getter(getter(ComparativeOrder::useOrderingAsString)).setter(setter(Builder::useOrdering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseOrdering").build()).build();

    private static final SdkField<List<String>> SPECIFED_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SpecifedOrder")
            .getter(getter(ComparativeOrder::specifedOrder))
            .setter(setter(Builder::specifedOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecifedOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TREAT_UNDEFINED_SPECIFIED_VALUES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TreatUndefinedSpecifiedValues")
            .getter(getter(ComparativeOrder::treatUndefinedSpecifiedValuesAsString))
            .setter(setter(Builder::treatUndefinedSpecifiedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatUndefinedSpecifiedValues")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_ORDERING_FIELD,
            SPECIFED_ORDER_FIELD, TREAT_UNDEFINED_SPECIFIED_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String useOrdering;

    private final List<String> specifedOrder;

    private final String treatUndefinedSpecifiedValues;

    private ComparativeOrder(BuilderImpl builder) {
        this.useOrdering = builder.useOrdering;
        this.specifedOrder = builder.specifedOrder;
        this.treatUndefinedSpecifiedValues = builder.treatUndefinedSpecifiedValues;
    }

    /**
     * <p>
     * The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
     * <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useOrdering} will
     * return {@link ColumnOrderingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useOrderingAsString}.
     * </p>
     * 
     * @return The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
     *         <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
     * @see ColumnOrderingType
     */
    public final ColumnOrderingType useOrdering() {
        return ColumnOrderingType.fromValue(useOrdering);
    }

    /**
     * <p>
     * The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
     * <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useOrdering} will
     * return {@link ColumnOrderingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useOrderingAsString}.
     * </p>
     * 
     * @return The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
     *         <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
     * @see ColumnOrderingType
     */
    public final String useOrderingAsString() {
        return useOrdering;
    }

    /**
     * For responses, this returns true if the service returned a value for the SpecifedOrder property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpecifedOrder() {
        return specifedOrder != null && !(specifedOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns to be used in the ordering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpecifedOrder} method.
     * </p>
     * 
     * @return The list of columns to be used in the ordering.
     */
    public final List<String> specifedOrder() {
        return specifedOrder;
    }

    /**
     * <p>
     * The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
     * <code>MOST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #treatUndefinedSpecifiedValues} will return {@link UndefinedSpecifiedValueType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #treatUndefinedSpecifiedValuesAsString}.
     * </p>
     * 
     * @return The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
     *         <code>MOST</code>.
     * @see UndefinedSpecifiedValueType
     */
    public final UndefinedSpecifiedValueType treatUndefinedSpecifiedValues() {
        return UndefinedSpecifiedValueType.fromValue(treatUndefinedSpecifiedValues);
    }

    /**
     * <p>
     * The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
     * <code>MOST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #treatUndefinedSpecifiedValues} will return {@link UndefinedSpecifiedValueType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #treatUndefinedSpecifiedValuesAsString}.
     * </p>
     * 
     * @return The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
     *         <code>MOST</code>.
     * @see UndefinedSpecifiedValueType
     */
    public final String treatUndefinedSpecifiedValuesAsString() {
        return treatUndefinedSpecifiedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(useOrderingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpecifedOrder() ? specifedOrder() : null);
        hashCode = 31 * hashCode + Objects.hashCode(treatUndefinedSpecifiedValuesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparativeOrder)) {
            return false;
        }
        ComparativeOrder other = (ComparativeOrder) obj;
        return Objects.equals(useOrderingAsString(), other.useOrderingAsString())
                && hasSpecifedOrder() == other.hasSpecifedOrder() && Objects.equals(specifedOrder(), other.specifedOrder())
                && Objects.equals(treatUndefinedSpecifiedValuesAsString(), other.treatUndefinedSpecifiedValuesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComparativeOrder").add("UseOrdering", useOrderingAsString())
                .add("SpecifedOrder", hasSpecifedOrder() ? specifedOrder() : null)
                .add("TreatUndefinedSpecifiedValues", treatUndefinedSpecifiedValuesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UseOrdering":
            return Optional.ofNullable(clazz.cast(useOrderingAsString()));
        case "SpecifedOrder":
            return Optional.ofNullable(clazz.cast(specifedOrder()));
        case "TreatUndefinedSpecifiedValues":
            return Optional.ofNullable(clazz.cast(treatUndefinedSpecifiedValuesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UseOrdering", USE_ORDERING_FIELD);
        map.put("SpecifedOrder", SPECIFED_ORDER_FIELD);
        map.put("TreatUndefinedSpecifiedValues", TREAT_UNDEFINED_SPECIFIED_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComparativeOrder, T> g) {
        return obj -> g.apply((ComparativeOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComparativeOrder> {
        /**
         * <p>
         * The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
         * <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
         * </p>
         * 
         * @param useOrdering
         *        The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
         *        <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
         * @see ColumnOrderingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnOrderingType
         */
        Builder useOrdering(String useOrdering);

        /**
         * <p>
         * The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
         * <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
         * </p>
         * 
         * @param useOrdering
         *        The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>,
         *        <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.
         * @see ColumnOrderingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnOrderingType
         */
        Builder useOrdering(ColumnOrderingType useOrdering);

        /**
         * <p>
         * The list of columns to be used in the ordering.
         * </p>
         * 
         * @param specifedOrder
         *        The list of columns to be used in the ordering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifedOrder(Collection<String> specifedOrder);

        /**
         * <p>
         * The list of columns to be used in the ordering.
         * </p>
         * 
         * @param specifedOrder
         *        The list of columns to be used in the ordering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifedOrder(String... specifedOrder);

        /**
         * <p>
         * The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
         * <code>MOST</code>.
         * </p>
         * 
         * @param treatUndefinedSpecifiedValues
         *        The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
         *        <code>MOST</code>.
         * @see UndefinedSpecifiedValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UndefinedSpecifiedValueType
         */
        Builder treatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues);

        /**
         * <p>
         * The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
         * <code>MOST</code>.
         * </p>
         * 
         * @param treatUndefinedSpecifiedValues
         *        The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and
         *        <code>MOST</code>.
         * @see UndefinedSpecifiedValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UndefinedSpecifiedValueType
         */
        Builder treatUndefinedSpecifiedValues(UndefinedSpecifiedValueType treatUndefinedSpecifiedValues);
    }

    static final class BuilderImpl implements Builder {
        private String useOrdering;

        private List<String> specifedOrder = DefaultSdkAutoConstructList.getInstance();

        private String treatUndefinedSpecifiedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparativeOrder model) {
            useOrdering(model.useOrdering);
            specifedOrder(model.specifedOrder);
            treatUndefinedSpecifiedValues(model.treatUndefinedSpecifiedValues);
        }

        public final String getUseOrdering() {
            return useOrdering;
        }

        public final void setUseOrdering(String useOrdering) {
            this.useOrdering = useOrdering;
        }

        @Override
        public final Builder useOrdering(String useOrdering) {
            this.useOrdering = useOrdering;
            return this;
        }

        @Override
        public final Builder useOrdering(ColumnOrderingType useOrdering) {
            this.useOrdering(useOrdering == null ? null : useOrdering.toString());
            return this;
        }

        public final Collection<String> getSpecifedOrder() {
            if (specifedOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return specifedOrder;
        }

        public final void setSpecifedOrder(Collection<String> specifedOrder) {
            this.specifedOrder = StringListCopier.copy(specifedOrder);
        }

        @Override
        public final Builder specifedOrder(Collection<String> specifedOrder) {
            this.specifedOrder = StringListCopier.copy(specifedOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specifedOrder(String... specifedOrder) {
            specifedOrder(Arrays.asList(specifedOrder));
            return this;
        }

        public final String getTreatUndefinedSpecifiedValues() {
            return treatUndefinedSpecifiedValues;
        }

        public final void setTreatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues) {
            this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues;
        }

        @Override
        public final Builder treatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues) {
            this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues;
            return this;
        }

        @Override
        public final Builder treatUndefinedSpecifiedValues(UndefinedSpecifiedValueType treatUndefinedSpecifiedValues) {
            this.treatUndefinedSpecifiedValues(treatUndefinedSpecifiedValues == null ? null : treatUndefinedSpecifiedValues
                    .toString());
            return this;
        }

        @Override
        public ComparativeOrder build() {
            return new ComparativeOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
