/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the icon display configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingIconDisplayConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingIconDisplayConfiguration.Builder, ConditionalFormattingIconDisplayConfiguration> {
    private static final SdkField<String> ICON_DISPLAY_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IconDisplayOption")
            .getter(getter(ConditionalFormattingIconDisplayConfiguration::iconDisplayOptionAsString))
            .setter(setter(Builder::iconDisplayOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconDisplayOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICON_DISPLAY_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String iconDisplayOption;

    private ConditionalFormattingIconDisplayConfiguration(BuilderImpl builder) {
        this.iconDisplayOption = builder.iconDisplayOption;
    }

    /**
     * <p>
     * Determines the icon display configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iconDisplayOption}
     * will return {@link ConditionalFormattingIconDisplayOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #iconDisplayOptionAsString}.
     * </p>
     * 
     * @return Determines the icon display configuration.
     * @see ConditionalFormattingIconDisplayOption
     */
    public final ConditionalFormattingIconDisplayOption iconDisplayOption() {
        return ConditionalFormattingIconDisplayOption.fromValue(iconDisplayOption);
    }

    /**
     * <p>
     * Determines the icon display configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iconDisplayOption}
     * will return {@link ConditionalFormattingIconDisplayOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #iconDisplayOptionAsString}.
     * </p>
     * 
     * @return Determines the icon display configuration.
     * @see ConditionalFormattingIconDisplayOption
     */
    public final String iconDisplayOptionAsString() {
        return iconDisplayOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iconDisplayOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingIconDisplayConfiguration)) {
            return false;
        }
        ConditionalFormattingIconDisplayConfiguration other = (ConditionalFormattingIconDisplayConfiguration) obj;
        return Objects.equals(iconDisplayOptionAsString(), other.iconDisplayOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingIconDisplayConfiguration")
                .add("IconDisplayOption", iconDisplayOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IconDisplayOption":
            return Optional.ofNullable(clazz.cast(iconDisplayOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IconDisplayOption", ICON_DISPLAY_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingIconDisplayConfiguration, T> g) {
        return obj -> g.apply((ConditionalFormattingIconDisplayConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingIconDisplayConfiguration> {
        /**
         * <p>
         * Determines the icon display configuration.
         * </p>
         * 
         * @param iconDisplayOption
         *        Determines the icon display configuration.
         * @see ConditionalFormattingIconDisplayOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalFormattingIconDisplayOption
         */
        Builder iconDisplayOption(String iconDisplayOption);

        /**
         * <p>
         * Determines the icon display configuration.
         * </p>
         * 
         * @param iconDisplayOption
         *        Determines the icon display configuration.
         * @see ConditionalFormattingIconDisplayOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalFormattingIconDisplayOption
         */
        Builder iconDisplayOption(ConditionalFormattingIconDisplayOption iconDisplayOption);
    }

    static final class BuilderImpl implements Builder {
        private String iconDisplayOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingIconDisplayConfiguration model) {
            iconDisplayOption(model.iconDisplayOption);
        }

        public final String getIconDisplayOption() {
            return iconDisplayOption;
        }

        public final void setIconDisplayOption(String iconDisplayOption) {
            this.iconDisplayOption = iconDisplayOption;
        }

        @Override
        public final Builder iconDisplayOption(String iconDisplayOption) {
            this.iconDisplayOption = iconDisplayOption;
            return this;
        }

        @Override
        public final Builder iconDisplayOption(ConditionalFormattingIconDisplayOption iconDisplayOption) {
            this.iconDisplayOption(iconDisplayOption == null ? null : iconDisplayOption.toString());
            return this;
        }

        @Override
        public ConditionalFormattingIconDisplayConfiguration build() {
            return new ConditionalFormattingIconDisplayConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
