/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSetRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateDataSetRequest.Builder, CreateDataSetRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateDataSetRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(CreateDataSetRequest::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataSetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, PhysicalTable>> PHYSICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, PhysicalTable>> builder(MarshallingType.MAP)
            .memberName("PhysicalTableMap")
            .getter(getter(CreateDataSetRequest::physicalTableMap))
            .setter(setter(Builder::physicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PhysicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, LogicalTable>> LOGICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, LogicalTable>> builder(MarshallingType.MAP)
            .memberName("LogicalTableMap")
            .getter(getter(CreateDataSetRequest::logicalTableMap))
            .setter(setter(Builder::logicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportMode").getter(getter(CreateDataSetRequest::importModeAsString))
            .setter(setter(Builder::importMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()).build();

    private static final SdkField<List<ColumnGroup>> COLUMN_GROUPS_FIELD = SdkField
            .<List<ColumnGroup>> builder(MarshallingType.LIST)
            .memberName("ColumnGroups")
            .getter(getter(CreateDataSetRequest::columnGroups))
            .setter(setter(Builder::columnGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FieldFolder>> FIELD_FOLDERS_FIELD = SdkField
            .<Map<String, FieldFolder>> builder(MarshallingType.MAP)
            .memberName("FieldFolders")
            .getter(getter(CreateDataSetRequest::fieldFolders))
            .setter(setter(Builder::fieldFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldFolders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FieldFolder> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldFolder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateDataSetRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField
            .<RowLevelPermissionDataSet> builder(MarshallingType.SDK_POJO).memberName("RowLevelPermissionDataSet")
            .getter(getter(CreateDataSetRequest::rowLevelPermissionDataSet)).setter(setter(Builder::rowLevelPermissionDataSet))
            .constructor(RowLevelPermissionDataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build())
            .build();

    private static final SdkField<RowLevelPermissionTagConfiguration> ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD = SdkField
            .<RowLevelPermissionTagConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RowLevelPermissionTagConfiguration")
            .getter(getter(CreateDataSetRequest::rowLevelPermissionTagConfiguration))
            .setter(setter(Builder::rowLevelPermissionTagConfiguration))
            .constructor(RowLevelPermissionTagConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionTagConfiguration")
                    .build()).build();

    private static final SdkField<List<ColumnLevelPermissionRule>> COLUMN_LEVEL_PERMISSION_RULES_FIELD = SdkField
            .<List<ColumnLevelPermissionRule>> builder(MarshallingType.LIST)
            .memberName("ColumnLevelPermissionRules")
            .getter(getter(CreateDataSetRequest::columnLevelPermissionRules))
            .setter(setter(Builder::columnLevelPermissionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnLevelPermissionRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnLevelPermissionRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnLevelPermissionRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDataSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSetUsageConfiguration> DATA_SET_USAGE_CONFIGURATION_FIELD = SdkField
            .<DataSetUsageConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataSetUsageConfiguration")
            .getter(getter(CreateDataSetRequest::dataSetUsageConfiguration)).setter(setter(Builder::dataSetUsageConfiguration))
            .constructor(DataSetUsageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetUsageConfiguration").build())
            .build();

    private static final SdkField<List<DatasetParameter>> DATASET_PARAMETERS_FIELD = SdkField
            .<List<DatasetParameter>> builder(MarshallingType.LIST)
            .memberName("DatasetParameters")
            .getter(getter(CreateDataSetRequest::datasetParameters))
            .setter(setter(Builder::datasetParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FOLDER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FolderArns")
            .getter(getter(CreateDataSetRequest::folderArns))
            .setter(setter(Builder::folderArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIGURATION_FIELD = SdkField
            .<PerformanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("PerformanceConfiguration")
            .getter(getter(CreateDataSetRequest::performanceConfiguration)).setter(setter(Builder::performanceConfiguration))
            .constructor(PerformanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SET_ID_FIELD, NAME_FIELD, PHYSICAL_TABLE_MAP_FIELD, LOGICAL_TABLE_MAP_FIELD, IMPORT_MODE_FIELD,
            COLUMN_GROUPS_FIELD, FIELD_FOLDERS_FIELD, PERMISSIONS_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD,
            ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD, COLUMN_LEVEL_PERMISSION_RULES_FIELD, TAGS_FIELD,
            DATA_SET_USAGE_CONFIGURATION_FIELD, DATASET_PARAMETERS_FIELD, FOLDER_ARNS_FIELD, PERFORMANCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String dataSetId;

    private final String name;

    private final Map<String, PhysicalTable> physicalTableMap;

    private final Map<String, LogicalTable> logicalTableMap;

    private final String importMode;

    private final List<ColumnGroup> columnGroups;

    private final Map<String, FieldFolder> fieldFolders;

    private final List<ResourcePermission> permissions;

    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private final RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration;

    private final List<ColumnLevelPermissionRule> columnLevelPermissionRules;

    private final List<Tag> tags;

    private final DataSetUsageConfiguration dataSetUsageConfiguration;

    private final List<DatasetParameter> datasetParameters;

    private final List<String> folderArns;

    private final PerformanceConfiguration performanceConfiguration;

    private CreateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.physicalTableMap = builder.physicalTableMap;
        this.logicalTableMap = builder.logicalTableMap;
        this.importMode = builder.importMode;
        this.columnGroups = builder.columnGroups;
        this.fieldFolders = builder.fieldFolders;
        this.permissions = builder.permissions;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
        this.rowLevelPermissionTagConfiguration = builder.rowLevelPermissionTagConfiguration;
        this.columnLevelPermissionRules = builder.columnLevelPermissionRules;
        this.tags = builder.tags;
        this.dataSetUsageConfiguration = builder.dataSetUsageConfiguration;
        this.datasetParameters = builder.datasetParameters;
        this.folderArns = builder.folderArns;
        this.performanceConfiguration = builder.performanceConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon
     * Web Services account.
     * </p>
     * 
     * @return An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each
     *         Amazon Web Services account.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The display name for the dataset.
     * </p>
     * 
     * @return The display name for the dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhysicalTableMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhysicalTableMap() {
        return physicalTableMap != null && !(physicalTableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Declares the physical tables that are available in the underlying data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhysicalTableMap} method.
     * </p>
     * 
     * @return Declares the physical tables that are available in the underlying data sources.
     */
    public final Map<String, PhysicalTable> physicalTableMap() {
        return physicalTableMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogicalTableMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogicalTableMap() {
        return logicalTableMap != null && !(logicalTableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configures the combination and transformation of the data from the physical tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogicalTableMap} method.
     * </p>
     * 
     * @return Configures the combination and transformation of the data from the physical tables.
     */
    public final Map<String, LogicalTable> logicalTableMap() {
        return logicalTableMap;
    }

    /**
     * <p>
     * Indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return Indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public final DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(importMode);
    }

    /**
     * <p>
     * Indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return Indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public final String importModeAsString() {
        return importMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnGroups() {
        return columnGroups != null && !(columnGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
     * hierarchy is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnGroups} method.
     * </p>
     * 
     * @return Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
     *         hierarchy is supported.
     */
    public final List<ColumnGroup> columnGroups() {
        return columnGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldFolders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldFolders() {
        return fieldFolders != null && !(fieldFolders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The folder that contains fields and nested subfolders for your dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldFolders} method.
     * </p>
     * 
     * @return The folder that contains fields and nested subfolders for your dataset.
     */
    public final Map<String, FieldFolder> fieldFolders() {
        return fieldFolders;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource permissions on the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A list of resource permissions on the dataset.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The row-level security configuration for the data that you want to create.
     * </p>
     * 
     * @return The row-level security configuration for the data that you want to create.
     */
    public final RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return rowLevelPermissionDataSet;
    }

    /**
     * <p>
     * The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported
     * for anonymous embedding only.
     * </p>
     * 
     * @return The configuration of tags on a dataset to set row-level security. Row-level security tags are currently
     *         supported for anonymous embedding only.
     */
    public final RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration() {
        return rowLevelPermissionTagConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnLevelPermissionRules property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasColumnLevelPermissionRules() {
        return columnLevelPermissionRules != null && !(columnLevelPermissionRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of one or more definitions of a
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnLevelPermissionRules} method.
     * </p>
     * 
     * @return A set of one or more definitions of a
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
     *         .
     */
    public final List<ColumnLevelPermissionRule> columnLevelPermissionRules() {
        return columnLevelPermissionRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the DataSetUsageConfiguration property for this object.
     * 
     * @return The value of the DataSetUsageConfiguration property for this object.
     */
    public final DataSetUsageConfiguration dataSetUsageConfiguration() {
        return dataSetUsageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetParameters() {
        return datasetParameters != null && !(datasetParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter declarations of the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetParameters} method.
     * </p>
     * 
     * @return The parameter declarations of the dataset.
     */
    public final List<DatasetParameter> datasetParameters() {
        return datasetParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FolderArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolderArns() {
        return folderArns != null && !(folderArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When you create the dataset, Amazon QuickSight adds the dataset to these folders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolderArns} method.
     * </p>
     * 
     * @return When you create the dataset, Amazon QuickSight adds the dataset to these folders.
     */
    public final List<String> folderArns() {
        return folderArns;
    }

    /**
     * <p>
     * The configuration for the performance optimization of the dataset that contains a <code>UniqueKey</code>
     * configuration.
     * </p>
     * 
     * @return The configuration for the performance optimization of the dataset that contains a <code>UniqueKey</code>
     *         configuration.
     */
    public final PerformanceConfiguration performanceConfiguration() {
        return performanceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhysicalTableMap() ? physicalTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalTableMap() ? logicalTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnGroups() ? columnGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldFolders() ? fieldFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionDataSet());
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionTagConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnLevelPermissionRules() ? columnLevelPermissionRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSetUsageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetParameters() ? datasetParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFolderArns() ? folderArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(performanceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSetRequest)) {
            return false;
        }
        CreateDataSetRequest other = (CreateDataSetRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(name(), other.name()) && hasPhysicalTableMap() == other.hasPhysicalTableMap()
                && Objects.equals(physicalTableMap(), other.physicalTableMap())
                && hasLogicalTableMap() == other.hasLogicalTableMap()
                && Objects.equals(logicalTableMap(), other.logicalTableMap())
                && Objects.equals(importModeAsString(), other.importModeAsString())
                && hasColumnGroups() == other.hasColumnGroups() && Objects.equals(columnGroups(), other.columnGroups())
                && hasFieldFolders() == other.hasFieldFolders() && Objects.equals(fieldFolders(), other.fieldFolders())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet())
                && Objects.equals(rowLevelPermissionTagConfiguration(), other.rowLevelPermissionTagConfiguration())
                && hasColumnLevelPermissionRules() == other.hasColumnLevelPermissionRules()
                && Objects.equals(columnLevelPermissionRules(), other.columnLevelPermissionRules())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(dataSetUsageConfiguration(), other.dataSetUsageConfiguration())
                && hasDatasetParameters() == other.hasDatasetParameters()
                && Objects.equals(datasetParameters(), other.datasetParameters()) && hasFolderArns() == other.hasFolderArns()
                && Objects.equals(folderArns(), other.folderArns())
                && Objects.equals(performanceConfiguration(), other.performanceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSetRequest").add("AwsAccountId", awsAccountId()).add("DataSetId", dataSetId())
                .add("Name", name()).add("PhysicalTableMap", hasPhysicalTableMap() ? physicalTableMap() : null)
                .add("LogicalTableMap", hasLogicalTableMap() ? logicalTableMap() : null).add("ImportMode", importModeAsString())
                .add("ColumnGroups", hasColumnGroups() ? columnGroups() : null)
                .add("FieldFolders", hasFieldFolders() ? fieldFolders() : null)
                .add("Permissions", hasPermissions() ? permissions() : null)
                .add("RowLevelPermissionDataSet", rowLevelPermissionDataSet())
                .add("RowLevelPermissionTagConfiguration", rowLevelPermissionTagConfiguration())
                .add("ColumnLevelPermissionRules", hasColumnLevelPermissionRules() ? columnLevelPermissionRules() : null)
                .add("Tags", hasTags() ? tags() : null).add("DataSetUsageConfiguration", dataSetUsageConfiguration())
                .add("DatasetParameters", hasDatasetParameters() ? datasetParameters() : null)
                .add("FolderArns", hasFolderArns() ? folderArns() : null)
                .add("PerformanceConfiguration", performanceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PhysicalTableMap":
            return Optional.ofNullable(clazz.cast(physicalTableMap()));
        case "LogicalTableMap":
            return Optional.ofNullable(clazz.cast(logicalTableMap()));
        case "ImportMode":
            return Optional.ofNullable(clazz.cast(importModeAsString()));
        case "ColumnGroups":
            return Optional.ofNullable(clazz.cast(columnGroups()));
        case "FieldFolders":
            return Optional.ofNullable(clazz.cast(fieldFolders()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "RowLevelPermissionDataSet":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionDataSet()));
        case "RowLevelPermissionTagConfiguration":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionTagConfiguration()));
        case "ColumnLevelPermissionRules":
            return Optional.ofNullable(clazz.cast(columnLevelPermissionRules()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DataSetUsageConfiguration":
            return Optional.ofNullable(clazz.cast(dataSetUsageConfiguration()));
        case "DatasetParameters":
            return Optional.ofNullable(clazz.cast(datasetParameters()));
        case "FolderArns":
            return Optional.ofNullable(clazz.cast(folderArns()));
        case "PerformanceConfiguration":
            return Optional.ofNullable(clazz.cast(performanceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PhysicalTableMap", PHYSICAL_TABLE_MAP_FIELD);
        map.put("LogicalTableMap", LOGICAL_TABLE_MAP_FIELD);
        map.put("ImportMode", IMPORT_MODE_FIELD);
        map.put("ColumnGroups", COLUMN_GROUPS_FIELD);
        map.put("FieldFolders", FIELD_FOLDERS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("RowLevelPermissionDataSet", ROW_LEVEL_PERMISSION_DATA_SET_FIELD);
        map.put("RowLevelPermissionTagConfiguration", ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD);
        map.put("ColumnLevelPermissionRules", COLUMN_LEVEL_PERMISSION_RULES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DataSetUsageConfiguration", DATA_SET_USAGE_CONFIGURATION_FIELD);
        map.put("DatasetParameters", DATASET_PARAMETERS_FIELD);
        map.put("FolderArns", FOLDER_ARNS_FIELD);
        map.put("PerformanceConfiguration", PERFORMANCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSetRequest, T> g) {
        return obj -> g.apply((CreateDataSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSetRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each
         * Amazon Web Services account.
         * </p>
         * 
         * @param dataSetId
         *        An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for
         *        each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The display name for the dataset.
         * </p>
         * 
         * @param name
         *        The display name for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Declares the physical tables that are available in the underlying data sources.
         * </p>
         * 
         * @param physicalTableMap
         *        Declares the physical tables that are available in the underlying data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap);

        /**
         * <p>
         * Configures the combination and transformation of the data from the physical tables.
         * </p>
         * 
         * @param logicalTableMap
         *        Configures the combination and transformation of the data from the physical tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap);

        /**
         * <p>
         * Indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        Indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(String importMode);

        /**
         * <p>
         * Indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        Indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(DataSetImportMode importMode);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only
         *        geospatial hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(Collection<ColumnGroup> columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only
         *        geospatial hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(ColumnGroup... columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #columnGroups(List<ColumnGroup>)}.
         * 
         * @param columnGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnGroups(java.util.Collection<ColumnGroup>)
         */
        Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups);

        /**
         * <p>
         * The folder that contains fields and nested subfolders for your dataset.
         * </p>
         * 
         * @param fieldFolders
         *        The folder that contains fields and nested subfolders for your dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldFolders(Map<String, FieldFolder> fieldFolders);

        /**
         * <p>
         * A list of resource permissions on the dataset.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions on the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A list of resource permissions on the dataset.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions on the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A list of resource permissions on the dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The row-level security configuration for the data that you want to create.
         * </p>
         * 
         * @param rowLevelPermissionDataSet
         *        The row-level security configuration for the data that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet);

        /**
         * <p>
         * The row-level security configuration for the data that you want to create.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowLevelPermissionDataSet.Builder}
         * avoiding the need to create one manually via {@link RowLevelPermissionDataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionDataSet.Builder#build()} is called immediately
         * and its result is passed to {@link #rowLevelPermissionDataSet(RowLevelPermissionDataSet)}.
         * 
         * @param rowLevelPermissionDataSet
         *        a consumer that will call methods on {@link RowLevelPermissionDataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionDataSet(RowLevelPermissionDataSet)
         */
        default Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return rowLevelPermissionDataSet(RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet).build());
        }

        /**
         * <p>
         * The configuration of tags on a dataset to set row-level security. Row-level security tags are currently
         * supported for anonymous embedding only.
         * </p>
         * 
         * @param rowLevelPermissionTagConfiguration
         *        The configuration of tags on a dataset to set row-level security. Row-level security tags are
         *        currently supported for anonymous embedding only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration);

        /**
         * <p>
         * The configuration of tags on a dataset to set row-level security. Row-level security tags are currently
         * supported for anonymous embedding only.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RowLevelPermissionTagConfiguration.Builder} avoiding the need to create one manually via
         * {@link RowLevelPermissionTagConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionTagConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration)}.
         * 
         * @param rowLevelPermissionTagConfiguration
         *        a consumer that will call methods on {@link RowLevelPermissionTagConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration)
         */
        default Builder rowLevelPermissionTagConfiguration(
                Consumer<RowLevelPermissionTagConfiguration.Builder> rowLevelPermissionTagConfiguration) {
            return rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration.builder()
                    .applyMutation(rowLevelPermissionTagConfiguration).build());
        }

        /**
         * <p>
         * A set of one or more definitions of a
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         * .
         * </p>
         * 
         * @param columnLevelPermissionRules
         *        A set of one or more definitions of a
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnLevelPermissionRules(Collection<ColumnLevelPermissionRule> columnLevelPermissionRules);

        /**
         * <p>
         * A set of one or more definitions of a
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         * .
         * </p>
         * 
         * @param columnLevelPermissionRules
         *        A set of one or more definitions of a
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnLevelPermissionRules(ColumnLevelPermissionRule... columnLevelPermissionRules);

        /**
         * <p>
         * A set of one or more definitions of a
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         * .
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule.Builder#build()} is called
         * immediately and its result is passed to {@link #columnLevelPermissionRules(List<ColumnLevelPermissionRule>)}.
         * 
         * @param columnLevelPermissionRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnLevelPermissionRules(java.util.Collection<ColumnLevelPermissionRule>)
         */
        Builder columnLevelPermissionRules(Consumer<ColumnLevelPermissionRule.Builder>... columnLevelPermissionRules);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.quicksight.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the DataSetUsageConfiguration property for this object.
         *
         * @param dataSetUsageConfiguration
         *        The new value for the DataSetUsageConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetUsageConfiguration(DataSetUsageConfiguration dataSetUsageConfiguration);

        /**
         * Sets the value of the DataSetUsageConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSetUsageConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSetUsageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetUsageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSetUsageConfiguration(DataSetUsageConfiguration)}.
         * 
         * @param dataSetUsageConfiguration
         *        a consumer that will call methods on {@link DataSetUsageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetUsageConfiguration(DataSetUsageConfiguration)
         */
        default Builder dataSetUsageConfiguration(Consumer<DataSetUsageConfiguration.Builder> dataSetUsageConfiguration) {
            return dataSetUsageConfiguration(DataSetUsageConfiguration.builder().applyMutation(dataSetUsageConfiguration).build());
        }

        /**
         * <p>
         * The parameter declarations of the dataset.
         * </p>
         * 
         * @param datasetParameters
         *        The parameter declarations of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetParameters(Collection<DatasetParameter> datasetParameters);

        /**
         * <p>
         * The parameter declarations of the dataset.
         * </p>
         * 
         * @param datasetParameters
         *        The parameter declarations of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetParameters(DatasetParameter... datasetParameters);

        /**
         * <p>
         * The parameter declarations of the dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetParameters(List<DatasetParameter>)}.
         * 
         * @param datasetParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetParameters(java.util.Collection<DatasetParameter>)
         */
        Builder datasetParameters(Consumer<DatasetParameter.Builder>... datasetParameters);

        /**
         * <p>
         * When you create the dataset, Amazon QuickSight adds the dataset to these folders.
         * </p>
         * 
         * @param folderArns
         *        When you create the dataset, Amazon QuickSight adds the dataset to these folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderArns(Collection<String> folderArns);

        /**
         * <p>
         * When you create the dataset, Amazon QuickSight adds the dataset to these folders.
         * </p>
         * 
         * @param folderArns
         *        When you create the dataset, Amazon QuickSight adds the dataset to these folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderArns(String... folderArns);

        /**
         * <p>
         * The configuration for the performance optimization of the dataset that contains a <code>UniqueKey</code>
         * configuration.
         * </p>
         * 
         * @param performanceConfiguration
         *        The configuration for the performance optimization of the dataset that contains a
         *        <code>UniqueKey</code> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceConfiguration(PerformanceConfiguration performanceConfiguration);

        /**
         * <p>
         * The configuration for the performance optimization of the dataset that contains a <code>UniqueKey</code>
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PerformanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #performanceConfiguration(PerformanceConfiguration)}.
         * 
         * @param performanceConfiguration
         *        a consumer that will call methods on {@link PerformanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceConfiguration(PerformanceConfiguration)
         */
        default Builder performanceConfiguration(Consumer<PerformanceConfiguration.Builder> performanceConfiguration) {
            return performanceConfiguration(PerformanceConfiguration.builder().applyMutation(performanceConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSetId;

        private String name;

        private Map<String, PhysicalTable> physicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, LogicalTable> logicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private String importMode;

        private List<ColumnGroup> columnGroups = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FieldFolder> fieldFolders = DefaultSdkAutoConstructMap.getInstance();

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration;

        private List<ColumnLevelPermissionRule> columnLevelPermissionRules = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DataSetUsageConfiguration dataSetUsageConfiguration;

        private List<DatasetParameter> datasetParameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> folderArns = DefaultSdkAutoConstructList.getInstance();

        private PerformanceConfiguration performanceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSetRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSetId(model.dataSetId);
            name(model.name);
            physicalTableMap(model.physicalTableMap);
            logicalTableMap(model.logicalTableMap);
            importMode(model.importMode);
            columnGroups(model.columnGroups);
            fieldFolders(model.fieldFolders);
            permissions(model.permissions);
            rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
            rowLevelPermissionTagConfiguration(model.rowLevelPermissionTagConfiguration);
            columnLevelPermissionRules(model.columnLevelPermissionRules);
            tags(model.tags);
            dataSetUsageConfiguration(model.dataSetUsageConfiguration);
            datasetParameters(model.datasetParameters);
            folderArns(model.folderArns);
            performanceConfiguration(model.performanceConfiguration);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, PhysicalTable.Builder> getPhysicalTableMap() {
            Map<String, PhysicalTable.Builder> result = PhysicalTableMapCopier.copyToBuilder(this.physicalTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPhysicalTableMap(Map<String, PhysicalTable.BuilderImpl> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copyFromBuilder(physicalTableMap);
        }

        @Override
        public final Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copy(physicalTableMap);
            return this;
        }

        public final Map<String, LogicalTable.Builder> getLogicalTableMap() {
            Map<String, LogicalTable.Builder> result = LogicalTableMapCopier.copyToBuilder(this.logicalTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogicalTableMap(Map<String, LogicalTable.BuilderImpl> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copyFromBuilder(logicalTableMap);
        }

        @Override
        public final Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copy(logicalTableMap);
            return this;
        }

        public final String getImportMode() {
            return importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final List<ColumnGroup.Builder> getColumnGroups() {
            List<ColumnGroup.Builder> result = ColumnGroupListCopier.copyToBuilder(this.columnGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnGroups(Collection<ColumnGroup.BuilderImpl> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copyFromBuilder(columnGroups);
        }

        @Override
        public final Builder columnGroups(Collection<ColumnGroup> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copy(columnGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(ColumnGroup... columnGroups) {
            columnGroups(Arrays.asList(columnGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups) {
            columnGroups(Stream.of(columnGroups).map(c -> ColumnGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FieldFolder.Builder> getFieldFolders() {
            Map<String, FieldFolder.Builder> result = FieldFolderMapCopier.copyToBuilder(this.fieldFolders);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFieldFolders(Map<String, FieldFolder.BuilderImpl> fieldFolders) {
            this.fieldFolders = FieldFolderMapCopier.copyFromBuilder(fieldFolders);
        }

        @Override
        public final Builder fieldFolders(Map<String, FieldFolder> fieldFolders) {
            this.fieldFolders = FieldFolderMapCopier.copy(fieldFolders);
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.toBuilder() : null;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final RowLevelPermissionTagConfiguration.Builder getRowLevelPermissionTagConfiguration() {
            return rowLevelPermissionTagConfiguration != null ? rowLevelPermissionTagConfiguration.toBuilder() : null;
        }

        public final void setRowLevelPermissionTagConfiguration(
                RowLevelPermissionTagConfiguration.BuilderImpl rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration != null ? rowLevelPermissionTagConfiguration
                    .build() : null;
        }

        @Override
        public final Builder rowLevelPermissionTagConfiguration(
                RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration;
            return this;
        }

        public final List<ColumnLevelPermissionRule.Builder> getColumnLevelPermissionRules() {
            List<ColumnLevelPermissionRule.Builder> result = ColumnLevelPermissionRuleListCopier
                    .copyToBuilder(this.columnLevelPermissionRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnLevelPermissionRules(
                Collection<ColumnLevelPermissionRule.BuilderImpl> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = ColumnLevelPermissionRuleListCopier.copyFromBuilder(columnLevelPermissionRules);
        }

        @Override
        public final Builder columnLevelPermissionRules(Collection<ColumnLevelPermissionRule> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = ColumnLevelPermissionRuleListCopier.copy(columnLevelPermissionRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnLevelPermissionRules(ColumnLevelPermissionRule... columnLevelPermissionRules) {
            columnLevelPermissionRules(Arrays.asList(columnLevelPermissionRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnLevelPermissionRules(Consumer<ColumnLevelPermissionRule.Builder>... columnLevelPermissionRules) {
            columnLevelPermissionRules(Stream.of(columnLevelPermissionRules)
                    .map(c -> ColumnLevelPermissionRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSetUsageConfiguration.Builder getDataSetUsageConfiguration() {
            return dataSetUsageConfiguration != null ? dataSetUsageConfiguration.toBuilder() : null;
        }

        public final void setDataSetUsageConfiguration(DataSetUsageConfiguration.BuilderImpl dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration != null ? dataSetUsageConfiguration.build() : null;
        }

        @Override
        public final Builder dataSetUsageConfiguration(DataSetUsageConfiguration dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration;
            return this;
        }

        public final List<DatasetParameter.Builder> getDatasetParameters() {
            List<DatasetParameter.Builder> result = DatasetParameterListCopier.copyToBuilder(this.datasetParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetParameters(Collection<DatasetParameter.BuilderImpl> datasetParameters) {
            this.datasetParameters = DatasetParameterListCopier.copyFromBuilder(datasetParameters);
        }

        @Override
        public final Builder datasetParameters(Collection<DatasetParameter> datasetParameters) {
            this.datasetParameters = DatasetParameterListCopier.copy(datasetParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetParameters(DatasetParameter... datasetParameters) {
            datasetParameters(Arrays.asList(datasetParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetParameters(Consumer<DatasetParameter.Builder>... datasetParameters) {
            datasetParameters(Stream.of(datasetParameters).map(c -> DatasetParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFolderArns() {
            if (folderArns instanceof SdkAutoConstructList) {
                return null;
            }
            return folderArns;
        }

        public final void setFolderArns(Collection<String> folderArns) {
            this.folderArns = FolderArnListCopier.copy(folderArns);
        }

        @Override
        public final Builder folderArns(Collection<String> folderArns) {
            this.folderArns = FolderArnListCopier.copy(folderArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderArns(String... folderArns) {
            folderArns(Arrays.asList(folderArns));
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfiguration() {
            return performanceConfiguration != null ? performanceConfiguration.toBuilder() : null;
        }

        public final void setPerformanceConfiguration(PerformanceConfiguration.BuilderImpl performanceConfiguration) {
            this.performanceConfiguration = performanceConfiguration != null ? performanceConfiguration.build() : null;
        }

        @Override
        public final Builder performanceConfiguration(PerformanceConfiguration performanceConfiguration) {
            this.performanceConfiguration = performanceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSetRequest build() {
            return new CreateDataSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
