/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the color that's applied to a particular data value in a column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomColor implements SdkPojo, Serializable, ToCopyableBuilder<CustomColor.Builder, CustomColor> {
    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldValue").getter(getter(CustomColor::fieldValue)).setter(setter(Builder::fieldValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(CustomColor::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<String> SPECIAL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpecialValue").getter(getter(CustomColor::specialValueAsString)).setter(setter(Builder::specialValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecialValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_VALUE_FIELD,
            COLOR_FIELD, SPECIAL_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldValue;

    private final String color;

    private final String specialValue;

    private CustomColor(BuilderImpl builder) {
        this.fieldValue = builder.fieldValue;
        this.color = builder.color;
        this.specialValue = builder.specialValue;
    }

    /**
     * <p>
     * The data value that the color is applied to.
     * </p>
     * 
     * @return The data value that the color is applied to.
     */
    public final String fieldValue() {
        return fieldValue;
    }

    /**
     * <p>
     * The color that is applied to the data value.
     * </p>
     * 
     * @return The color that is applied to the data value.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The value of a special data value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialValue} will
     * return {@link SpecialValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialValueAsString}.
     * </p>
     * 
     * @return The value of a special data value.
     * @see SpecialValue
     */
    public final SpecialValue specialValue() {
        return SpecialValue.fromValue(specialValue);
    }

    /**
     * <p>
     * The value of a special data value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialValue} will
     * return {@link SpecialValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialValueAsString}.
     * </p>
     * 
     * @return The value of a special data value.
     * @see SpecialValue
     */
    public final String specialValueAsString() {
        return specialValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldValue());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(specialValueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomColor)) {
            return false;
        }
        CustomColor other = (CustomColor) obj;
        return Objects.equals(fieldValue(), other.fieldValue()) && Objects.equals(color(), other.color())
                && Objects.equals(specialValueAsString(), other.specialValueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomColor").add("FieldValue", fieldValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Color", color()).add("SpecialValue", specialValueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldValue":
            return Optional.ofNullable(clazz.cast(fieldValue()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "SpecialValue":
            return Optional.ofNullable(clazz.cast(specialValueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldValue", FIELD_VALUE_FIELD);
        map.put("Color", COLOR_FIELD);
        map.put("SpecialValue", SPECIAL_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomColor, T> g) {
        return obj -> g.apply((CustomColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomColor> {
        /**
         * <p>
         * The data value that the color is applied to.
         * </p>
         * 
         * @param fieldValue
         *        The data value that the color is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldValue(String fieldValue);

        /**
         * <p>
         * The color that is applied to the data value.
         * </p>
         * 
         * @param color
         *        The color that is applied to the data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The value of a special data value.
         * </p>
         * 
         * @param specialValue
         *        The value of a special data value.
         * @see SpecialValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpecialValue
         */
        Builder specialValue(String specialValue);

        /**
         * <p>
         * The value of a special data value.
         * </p>
         * 
         * @param specialValue
         *        The value of a special data value.
         * @see SpecialValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpecialValue
         */
        Builder specialValue(SpecialValue specialValue);
    }

    static final class BuilderImpl implements Builder {
        private String fieldValue;

        private String color;

        private String specialValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomColor model) {
            fieldValue(model.fieldValue);
            color(model.color);
            specialValue(model.specialValue);
        }

        public final String getFieldValue() {
            return fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getSpecialValue() {
            return specialValue;
        }

        public final void setSpecialValue(String specialValue) {
            this.specialValue = specialValue;
        }

        @Override
        public final Builder specialValue(String specialValue) {
            this.specialValue = specialValue;
            return this;
        }

        @Override
        public final Builder specialValue(SpecialValue specialValue) {
            this.specialValue(specialValue == null ? null : specialValue.toString());
            return this;
        }

        @Override
        public CustomColor build() {
            return new CustomColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
