/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom permissions profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPermissions.Builder, CustomPermissions> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CustomPermissions::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPermissionsName").getter(getter(CustomPermissions::customPermissionsName))
            .setter(setter(Builder::customPermissionsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build())
            .build();

    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.<Capabilities> builder(MarshallingType.SDK_POJO)
            .memberName("Capabilities").getter(getter(CustomPermissions::capabilities)).setter(setter(Builder::capabilities))
            .constructor(Capabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CUSTOM_PERMISSIONS_NAME_FIELD, CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String customPermissionsName;

    private final Capabilities capabilities;

    private CustomPermissions(BuilderImpl builder) {
        this.arn = builder.arn;
        this.customPermissionsName = builder.customPermissionsName;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom permissions profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom permissions profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the custom permissions profile.
     * </p>
     * 
     * @return The name of the custom permissions profile.
     */
    public final String customPermissionsName() {
        return customPermissionsName;
    }

    /**
     * <p>
     * A set of actions in the custom permissions profile.
     * </p>
     * 
     * @return A set of actions in the custom permissions profile.
     */
    public final Capabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissionsName());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPermissions)) {
            return false;
        }
        CustomPermissions other = (CustomPermissions) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(customPermissionsName(), other.customPermissionsName())
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPermissions").add("Arn", arn()).add("CustomPermissionsName", customPermissionsName())
                .add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CustomPermissionsName":
            return Optional.ofNullable(clazz.cast(customPermissionsName()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CustomPermissionsName", CUSTOM_PERMISSIONS_NAME_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomPermissions, T> g) {
        return obj -> g.apply((CustomPermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPermissions> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom permissions profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the custom permissions profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the custom permissions profile.
         * </p>
         * 
         * @param customPermissionsName
         *        The name of the custom permissions profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissionsName(String customPermissionsName);

        /**
         * <p>
         * A set of actions in the custom permissions profile.
         * </p>
         * 
         * @param capabilities
         *        A set of actions in the custom permissions profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capabilities capabilities);

        /**
         * <p>
         * A set of actions in the custom permissions profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capabilities.Builder} avoiding the need
         * to create one manually via {@link Capabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilities(Capabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link Capabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(Capabilities)
         */
        default Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return capabilities(Capabilities.builder().applyMutation(capabilities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String customPermissionsName;

        private Capabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPermissions model) {
            arn(model.arn);
            customPermissionsName(model.customPermissionsName);
            capabilities(model.capabilities);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCustomPermissionsName() {
            return customPermissionsName;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public CustomPermissions build() {
            return new CustomPermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
