/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that corresponds to the control type of the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFilterControlOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultFilterControlOptions.Builder, DefaultFilterControlOptions> {
    private static final SdkField<DefaultDateTimePickerControlOptions> DEFAULT_DATE_TIME_PICKER_OPTIONS_FIELD = SdkField
            .<DefaultDateTimePickerControlOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultDateTimePickerOptions")
            .getter(getter(DefaultFilterControlOptions::defaultDateTimePickerOptions))
            .setter(setter(Builder::defaultDateTimePickerOptions))
            .constructor(DefaultDateTimePickerControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDateTimePickerOptions")
                    .build()).build();

    private static final SdkField<DefaultFilterListControlOptions> DEFAULT_LIST_OPTIONS_FIELD = SdkField
            .<DefaultFilterListControlOptions> builder(MarshallingType.SDK_POJO).memberName("DefaultListOptions")
            .getter(getter(DefaultFilterControlOptions::defaultListOptions)).setter(setter(Builder::defaultListOptions))
            .constructor(DefaultFilterListControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultListOptions").build())
            .build();

    private static final SdkField<DefaultFilterDropDownControlOptions> DEFAULT_DROPDOWN_OPTIONS_FIELD = SdkField
            .<DefaultFilterDropDownControlOptions> builder(MarshallingType.SDK_POJO).memberName("DefaultDropdownOptions")
            .getter(getter(DefaultFilterControlOptions::defaultDropdownOptions)).setter(setter(Builder::defaultDropdownOptions))
            .constructor(DefaultFilterDropDownControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDropdownOptions").build())
            .build();

    private static final SdkField<DefaultTextFieldControlOptions> DEFAULT_TEXT_FIELD_OPTIONS_FIELD = SdkField
            .<DefaultTextFieldControlOptions> builder(MarshallingType.SDK_POJO).memberName("DefaultTextFieldOptions")
            .getter(getter(DefaultFilterControlOptions::defaultTextFieldOptions))
            .setter(setter(Builder::defaultTextFieldOptions)).constructor(DefaultTextFieldControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTextFieldOptions").build())
            .build();

    private static final SdkField<DefaultTextAreaControlOptions> DEFAULT_TEXT_AREA_OPTIONS_FIELD = SdkField
            .<DefaultTextAreaControlOptions> builder(MarshallingType.SDK_POJO).memberName("DefaultTextAreaOptions")
            .getter(getter(DefaultFilterControlOptions::defaultTextAreaOptions)).setter(setter(Builder::defaultTextAreaOptions))
            .constructor(DefaultTextAreaControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTextAreaOptions").build())
            .build();

    private static final SdkField<DefaultSliderControlOptions> DEFAULT_SLIDER_OPTIONS_FIELD = SdkField
            .<DefaultSliderControlOptions> builder(MarshallingType.SDK_POJO).memberName("DefaultSliderOptions")
            .getter(getter(DefaultFilterControlOptions::defaultSliderOptions)).setter(setter(Builder::defaultSliderOptions))
            .constructor(DefaultSliderControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSliderOptions").build())
            .build();

    private static final SdkField<DefaultRelativeDateTimeControlOptions> DEFAULT_RELATIVE_DATE_TIME_OPTIONS_FIELD = SdkField
            .<DefaultRelativeDateTimeControlOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultRelativeDateTimeOptions")
            .getter(getter(DefaultFilterControlOptions::defaultRelativeDateTimeOptions))
            .setter(setter(Builder::defaultRelativeDateTimeOptions))
            .constructor(DefaultRelativeDateTimeControlOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRelativeDateTimeOptions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_DATE_TIME_PICKER_OPTIONS_FIELD, DEFAULT_LIST_OPTIONS_FIELD, DEFAULT_DROPDOWN_OPTIONS_FIELD,
            DEFAULT_TEXT_FIELD_OPTIONS_FIELD, DEFAULT_TEXT_AREA_OPTIONS_FIELD, DEFAULT_SLIDER_OPTIONS_FIELD,
            DEFAULT_RELATIVE_DATE_TIME_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DefaultDateTimePickerControlOptions defaultDateTimePickerOptions;

    private final DefaultFilterListControlOptions defaultListOptions;

    private final DefaultFilterDropDownControlOptions defaultDropdownOptions;

    private final DefaultTextFieldControlOptions defaultTextFieldOptions;

    private final DefaultTextAreaControlOptions defaultTextAreaOptions;

    private final DefaultSliderControlOptions defaultSliderOptions;

    private final DefaultRelativeDateTimeControlOptions defaultRelativeDateTimeOptions;

    private DefaultFilterControlOptions(BuilderImpl builder) {
        this.defaultDateTimePickerOptions = builder.defaultDateTimePickerOptions;
        this.defaultListOptions = builder.defaultListOptions;
        this.defaultDropdownOptions = builder.defaultDropdownOptions;
        this.defaultTextFieldOptions = builder.defaultTextFieldOptions;
        this.defaultTextAreaOptions = builder.defaultTextAreaOptions;
        this.defaultSliderOptions = builder.defaultSliderOptions;
        this.defaultRelativeDateTimeOptions = builder.defaultRelativeDateTimeOptions;
    }

    /**
     * <p>
     * The default options that correspond to the filter control type of a <code>DateTimePicker</code>.
     * </p>
     * 
     * @return The default options that correspond to the filter control type of a <code>DateTimePicker</code>.
     */
    public final DefaultDateTimePickerControlOptions defaultDateTimePickerOptions() {
        return defaultDateTimePickerOptions;
    }

    /**
     * <p>
     * The default options that correspond to the <code>List</code> filter control type.
     * </p>
     * 
     * @return The default options that correspond to the <code>List</code> filter control type.
     */
    public final DefaultFilterListControlOptions defaultListOptions() {
        return defaultListOptions;
    }

    /**
     * <p>
     * The default options that correspond to the <code>Dropdown</code> filter control type.
     * </p>
     * 
     * @return The default options that correspond to the <code>Dropdown</code> filter control type.
     */
    public final DefaultFilterDropDownControlOptions defaultDropdownOptions() {
        return defaultDropdownOptions;
    }

    /**
     * <p>
     * The default options that correspond to the <code>TextField</code> filter control type.
     * </p>
     * 
     * @return The default options that correspond to the <code>TextField</code> filter control type.
     */
    public final DefaultTextFieldControlOptions defaultTextFieldOptions() {
        return defaultTextFieldOptions;
    }

    /**
     * <p>
     * The default options that correspond to the <code>TextArea</code> filter control type.
     * </p>
     * 
     * @return The default options that correspond to the <code>TextArea</code> filter control type.
     */
    public final DefaultTextAreaControlOptions defaultTextAreaOptions() {
        return defaultTextAreaOptions;
    }

    /**
     * <p>
     * The default options that correspond to the <code>Slider</code> filter control type.
     * </p>
     * 
     * @return The default options that correspond to the <code>Slider</code> filter control type.
     */
    public final DefaultSliderControlOptions defaultSliderOptions() {
        return defaultSliderOptions;
    }

    /**
     * <p>
     * The default options that correspond to the <code>RelativeDateTime</code> filter control type.
     * </p>
     * 
     * @return The default options that correspond to the <code>RelativeDateTime</code> filter control type.
     */
    public final DefaultRelativeDateTimeControlOptions defaultRelativeDateTimeOptions() {
        return defaultRelativeDateTimeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultDateTimePickerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultListOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDropdownOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTextFieldOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTextAreaOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSliderOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRelativeDateTimeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFilterControlOptions)) {
            return false;
        }
        DefaultFilterControlOptions other = (DefaultFilterControlOptions) obj;
        return Objects.equals(defaultDateTimePickerOptions(), other.defaultDateTimePickerOptions())
                && Objects.equals(defaultListOptions(), other.defaultListOptions())
                && Objects.equals(defaultDropdownOptions(), other.defaultDropdownOptions())
                && Objects.equals(defaultTextFieldOptions(), other.defaultTextFieldOptions())
                && Objects.equals(defaultTextAreaOptions(), other.defaultTextAreaOptions())
                && Objects.equals(defaultSliderOptions(), other.defaultSliderOptions())
                && Objects.equals(defaultRelativeDateTimeOptions(), other.defaultRelativeDateTimeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultFilterControlOptions")
                .add("DefaultDateTimePickerOptions", defaultDateTimePickerOptions())
                .add("DefaultListOptions", defaultListOptions()).add("DefaultDropdownOptions", defaultDropdownOptions())
                .add("DefaultTextFieldOptions", defaultTextFieldOptions())
                .add("DefaultTextAreaOptions", defaultTextAreaOptions()).add("DefaultSliderOptions", defaultSliderOptions())
                .add("DefaultRelativeDateTimeOptions", defaultRelativeDateTimeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultDateTimePickerOptions":
            return Optional.ofNullable(clazz.cast(defaultDateTimePickerOptions()));
        case "DefaultListOptions":
            return Optional.ofNullable(clazz.cast(defaultListOptions()));
        case "DefaultDropdownOptions":
            return Optional.ofNullable(clazz.cast(defaultDropdownOptions()));
        case "DefaultTextFieldOptions":
            return Optional.ofNullable(clazz.cast(defaultTextFieldOptions()));
        case "DefaultTextAreaOptions":
            return Optional.ofNullable(clazz.cast(defaultTextAreaOptions()));
        case "DefaultSliderOptions":
            return Optional.ofNullable(clazz.cast(defaultSliderOptions()));
        case "DefaultRelativeDateTimeOptions":
            return Optional.ofNullable(clazz.cast(defaultRelativeDateTimeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultDateTimePickerOptions", DEFAULT_DATE_TIME_PICKER_OPTIONS_FIELD);
        map.put("DefaultListOptions", DEFAULT_LIST_OPTIONS_FIELD);
        map.put("DefaultDropdownOptions", DEFAULT_DROPDOWN_OPTIONS_FIELD);
        map.put("DefaultTextFieldOptions", DEFAULT_TEXT_FIELD_OPTIONS_FIELD);
        map.put("DefaultTextAreaOptions", DEFAULT_TEXT_AREA_OPTIONS_FIELD);
        map.put("DefaultSliderOptions", DEFAULT_SLIDER_OPTIONS_FIELD);
        map.put("DefaultRelativeDateTimeOptions", DEFAULT_RELATIVE_DATE_TIME_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultFilterControlOptions, T> g) {
        return obj -> g.apply((DefaultFilterControlOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultFilterControlOptions> {
        /**
         * <p>
         * The default options that correspond to the filter control type of a <code>DateTimePicker</code>.
         * </p>
         * 
         * @param defaultDateTimePickerOptions
         *        The default options that correspond to the filter control type of a <code>DateTimePicker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDateTimePickerOptions(DefaultDateTimePickerControlOptions defaultDateTimePickerOptions);

        /**
         * <p>
         * The default options that correspond to the filter control type of a <code>DateTimePicker</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultDateTimePickerControlOptions.Builder} avoiding the need to create one manually via
         * {@link DefaultDateTimePickerControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultDateTimePickerControlOptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultDateTimePickerOptions(DefaultDateTimePickerControlOptions)}.
         * 
         * @param defaultDateTimePickerOptions
         *        a consumer that will call methods on {@link DefaultDateTimePickerControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultDateTimePickerOptions(DefaultDateTimePickerControlOptions)
         */
        default Builder defaultDateTimePickerOptions(
                Consumer<DefaultDateTimePickerControlOptions.Builder> defaultDateTimePickerOptions) {
            return defaultDateTimePickerOptions(DefaultDateTimePickerControlOptions.builder()
                    .applyMutation(defaultDateTimePickerOptions).build());
        }

        /**
         * <p>
         * The default options that correspond to the <code>List</code> filter control type.
         * </p>
         * 
         * @param defaultListOptions
         *        The default options that correspond to the <code>List</code> filter control type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultListOptions(DefaultFilterListControlOptions defaultListOptions);

        /**
         * <p>
         * The default options that correspond to the <code>List</code> filter control type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultFilterListControlOptions.Builder}
         * avoiding the need to create one manually via {@link DefaultFilterListControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterListControlOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultListOptions(DefaultFilterListControlOptions)}.
         * 
         * @param defaultListOptions
         *        a consumer that will call methods on {@link DefaultFilterListControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultListOptions(DefaultFilterListControlOptions)
         */
        default Builder defaultListOptions(Consumer<DefaultFilterListControlOptions.Builder> defaultListOptions) {
            return defaultListOptions(DefaultFilterListControlOptions.builder().applyMutation(defaultListOptions).build());
        }

        /**
         * <p>
         * The default options that correspond to the <code>Dropdown</code> filter control type.
         * </p>
         * 
         * @param defaultDropdownOptions
         *        The default options that correspond to the <code>Dropdown</code> filter control type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDropdownOptions(DefaultFilterDropDownControlOptions defaultDropdownOptions);

        /**
         * <p>
         * The default options that correspond to the <code>Dropdown</code> filter control type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFilterDropDownControlOptions.Builder} avoiding the need to create one manually via
         * {@link DefaultFilterDropDownControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterDropDownControlOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultDropdownOptions(DefaultFilterDropDownControlOptions)}.
         * 
         * @param defaultDropdownOptions
         *        a consumer that will call methods on {@link DefaultFilterDropDownControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultDropdownOptions(DefaultFilterDropDownControlOptions)
         */
        default Builder defaultDropdownOptions(Consumer<DefaultFilterDropDownControlOptions.Builder> defaultDropdownOptions) {
            return defaultDropdownOptions(DefaultFilterDropDownControlOptions.builder().applyMutation(defaultDropdownOptions)
                    .build());
        }

        /**
         * <p>
         * The default options that correspond to the <code>TextField</code> filter control type.
         * </p>
         * 
         * @param defaultTextFieldOptions
         *        The default options that correspond to the <code>TextField</code> filter control type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTextFieldOptions(DefaultTextFieldControlOptions defaultTextFieldOptions);

        /**
         * <p>
         * The default options that correspond to the <code>TextField</code> filter control type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultTextFieldControlOptions.Builder}
         * avoiding the need to create one manually via {@link DefaultTextFieldControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultTextFieldControlOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultTextFieldOptions(DefaultTextFieldControlOptions)}.
         * 
         * @param defaultTextFieldOptions
         *        a consumer that will call methods on {@link DefaultTextFieldControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultTextFieldOptions(DefaultTextFieldControlOptions)
         */
        default Builder defaultTextFieldOptions(Consumer<DefaultTextFieldControlOptions.Builder> defaultTextFieldOptions) {
            return defaultTextFieldOptions(DefaultTextFieldControlOptions.builder().applyMutation(defaultTextFieldOptions)
                    .build());
        }

        /**
         * <p>
         * The default options that correspond to the <code>TextArea</code> filter control type.
         * </p>
         * 
         * @param defaultTextAreaOptions
         *        The default options that correspond to the <code>TextArea</code> filter control type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTextAreaOptions(DefaultTextAreaControlOptions defaultTextAreaOptions);

        /**
         * <p>
         * The default options that correspond to the <code>TextArea</code> filter control type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultTextAreaControlOptions.Builder}
         * avoiding the need to create one manually via {@link DefaultTextAreaControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultTextAreaControlOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultTextAreaOptions(DefaultTextAreaControlOptions)}.
         * 
         * @param defaultTextAreaOptions
         *        a consumer that will call methods on {@link DefaultTextAreaControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultTextAreaOptions(DefaultTextAreaControlOptions)
         */
        default Builder defaultTextAreaOptions(Consumer<DefaultTextAreaControlOptions.Builder> defaultTextAreaOptions) {
            return defaultTextAreaOptions(DefaultTextAreaControlOptions.builder().applyMutation(defaultTextAreaOptions).build());
        }

        /**
         * <p>
         * The default options that correspond to the <code>Slider</code> filter control type.
         * </p>
         * 
         * @param defaultSliderOptions
         *        The default options that correspond to the <code>Slider</code> filter control type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSliderOptions(DefaultSliderControlOptions defaultSliderOptions);

        /**
         * <p>
         * The default options that correspond to the <code>Slider</code> filter control type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultSliderControlOptions.Builder}
         * avoiding the need to create one manually via {@link DefaultSliderControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSliderControlOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultSliderOptions(DefaultSliderControlOptions)}.
         * 
         * @param defaultSliderOptions
         *        a consumer that will call methods on {@link DefaultSliderControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSliderOptions(DefaultSliderControlOptions)
         */
        default Builder defaultSliderOptions(Consumer<DefaultSliderControlOptions.Builder> defaultSliderOptions) {
            return defaultSliderOptions(DefaultSliderControlOptions.builder().applyMutation(defaultSliderOptions).build());
        }

        /**
         * <p>
         * The default options that correspond to the <code>RelativeDateTime</code> filter control type.
         * </p>
         * 
         * @param defaultRelativeDateTimeOptions
         *        The default options that correspond to the <code>RelativeDateTime</code> filter control type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRelativeDateTimeOptions(DefaultRelativeDateTimeControlOptions defaultRelativeDateTimeOptions);

        /**
         * <p>
         * The default options that correspond to the <code>RelativeDateTime</code> filter control type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultRelativeDateTimeControlOptions.Builder} avoiding the need to create one manually via
         * {@link DefaultRelativeDateTimeControlOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultRelativeDateTimeControlOptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultRelativeDateTimeOptions(DefaultRelativeDateTimeControlOptions)}.
         * 
         * @param defaultRelativeDateTimeOptions
         *        a consumer that will call methods on {@link DefaultRelativeDateTimeControlOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRelativeDateTimeOptions(DefaultRelativeDateTimeControlOptions)
         */
        default Builder defaultRelativeDateTimeOptions(
                Consumer<DefaultRelativeDateTimeControlOptions.Builder> defaultRelativeDateTimeOptions) {
            return defaultRelativeDateTimeOptions(DefaultRelativeDateTimeControlOptions.builder()
                    .applyMutation(defaultRelativeDateTimeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DefaultDateTimePickerControlOptions defaultDateTimePickerOptions;

        private DefaultFilterListControlOptions defaultListOptions;

        private DefaultFilterDropDownControlOptions defaultDropdownOptions;

        private DefaultTextFieldControlOptions defaultTextFieldOptions;

        private DefaultTextAreaControlOptions defaultTextAreaOptions;

        private DefaultSliderControlOptions defaultSliderOptions;

        private DefaultRelativeDateTimeControlOptions defaultRelativeDateTimeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFilterControlOptions model) {
            defaultDateTimePickerOptions(model.defaultDateTimePickerOptions);
            defaultListOptions(model.defaultListOptions);
            defaultDropdownOptions(model.defaultDropdownOptions);
            defaultTextFieldOptions(model.defaultTextFieldOptions);
            defaultTextAreaOptions(model.defaultTextAreaOptions);
            defaultSliderOptions(model.defaultSliderOptions);
            defaultRelativeDateTimeOptions(model.defaultRelativeDateTimeOptions);
        }

        public final DefaultDateTimePickerControlOptions.Builder getDefaultDateTimePickerOptions() {
            return defaultDateTimePickerOptions != null ? defaultDateTimePickerOptions.toBuilder() : null;
        }

        public final void setDefaultDateTimePickerOptions(
                DefaultDateTimePickerControlOptions.BuilderImpl defaultDateTimePickerOptions) {
            this.defaultDateTimePickerOptions = defaultDateTimePickerOptions != null ? defaultDateTimePickerOptions.build()
                    : null;
        }

        @Override
        public final Builder defaultDateTimePickerOptions(DefaultDateTimePickerControlOptions defaultDateTimePickerOptions) {
            this.defaultDateTimePickerOptions = defaultDateTimePickerOptions;
            return this;
        }

        public final DefaultFilterListControlOptions.Builder getDefaultListOptions() {
            return defaultListOptions != null ? defaultListOptions.toBuilder() : null;
        }

        public final void setDefaultListOptions(DefaultFilterListControlOptions.BuilderImpl defaultListOptions) {
            this.defaultListOptions = defaultListOptions != null ? defaultListOptions.build() : null;
        }

        @Override
        public final Builder defaultListOptions(DefaultFilterListControlOptions defaultListOptions) {
            this.defaultListOptions = defaultListOptions;
            return this;
        }

        public final DefaultFilterDropDownControlOptions.Builder getDefaultDropdownOptions() {
            return defaultDropdownOptions != null ? defaultDropdownOptions.toBuilder() : null;
        }

        public final void setDefaultDropdownOptions(DefaultFilterDropDownControlOptions.BuilderImpl defaultDropdownOptions) {
            this.defaultDropdownOptions = defaultDropdownOptions != null ? defaultDropdownOptions.build() : null;
        }

        @Override
        public final Builder defaultDropdownOptions(DefaultFilterDropDownControlOptions defaultDropdownOptions) {
            this.defaultDropdownOptions = defaultDropdownOptions;
            return this;
        }

        public final DefaultTextFieldControlOptions.Builder getDefaultTextFieldOptions() {
            return defaultTextFieldOptions != null ? defaultTextFieldOptions.toBuilder() : null;
        }

        public final void setDefaultTextFieldOptions(DefaultTextFieldControlOptions.BuilderImpl defaultTextFieldOptions) {
            this.defaultTextFieldOptions = defaultTextFieldOptions != null ? defaultTextFieldOptions.build() : null;
        }

        @Override
        public final Builder defaultTextFieldOptions(DefaultTextFieldControlOptions defaultTextFieldOptions) {
            this.defaultTextFieldOptions = defaultTextFieldOptions;
            return this;
        }

        public final DefaultTextAreaControlOptions.Builder getDefaultTextAreaOptions() {
            return defaultTextAreaOptions != null ? defaultTextAreaOptions.toBuilder() : null;
        }

        public final void setDefaultTextAreaOptions(DefaultTextAreaControlOptions.BuilderImpl defaultTextAreaOptions) {
            this.defaultTextAreaOptions = defaultTextAreaOptions != null ? defaultTextAreaOptions.build() : null;
        }

        @Override
        public final Builder defaultTextAreaOptions(DefaultTextAreaControlOptions defaultTextAreaOptions) {
            this.defaultTextAreaOptions = defaultTextAreaOptions;
            return this;
        }

        public final DefaultSliderControlOptions.Builder getDefaultSliderOptions() {
            return defaultSliderOptions != null ? defaultSliderOptions.toBuilder() : null;
        }

        public final void setDefaultSliderOptions(DefaultSliderControlOptions.BuilderImpl defaultSliderOptions) {
            this.defaultSliderOptions = defaultSliderOptions != null ? defaultSliderOptions.build() : null;
        }

        @Override
        public final Builder defaultSliderOptions(DefaultSliderControlOptions defaultSliderOptions) {
            this.defaultSliderOptions = defaultSliderOptions;
            return this;
        }

        public final DefaultRelativeDateTimeControlOptions.Builder getDefaultRelativeDateTimeOptions() {
            return defaultRelativeDateTimeOptions != null ? defaultRelativeDateTimeOptions.toBuilder() : null;
        }

        public final void setDefaultRelativeDateTimeOptions(
                DefaultRelativeDateTimeControlOptions.BuilderImpl defaultRelativeDateTimeOptions) {
            this.defaultRelativeDateTimeOptions = defaultRelativeDateTimeOptions != null ? defaultRelativeDateTimeOptions.build()
                    : null;
        }

        @Override
        public final Builder defaultRelativeDateTimeOptions(DefaultRelativeDateTimeControlOptions defaultRelativeDateTimeOptions) {
            this.defaultRelativeDateTimeOptions = defaultRelativeDateTimeOptions;
            return this;
        }

        @Override
        public DefaultFilterControlOptions build() {
            return new DefaultFilterControlOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
