/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default options that correspond to the <code>Dropdown</code> filter control type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFilterDropDownControlOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultFilterDropDownControlOptions.Builder, DefaultFilterDropDownControlOptions> {
    private static final SdkField<DropDownControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<DropDownControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(DefaultFilterDropDownControlOptions::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(DropDownControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DefaultFilterDropDownControlOptions::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<FilterSelectableValues> SELECTABLE_VALUES_FIELD = SdkField
            .<FilterSelectableValues> builder(MarshallingType.SDK_POJO).memberName("SelectableValues")
            .getter(getter(DefaultFilterDropDownControlOptions::selectableValues)).setter(setter(Builder::selectableValues))
            .constructor(FilterSelectableValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectableValues").build()).build();

    private static final SdkField<String> COMMIT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitMode").getter(getter(DefaultFilterDropDownControlOptions::commitModeAsString))
            .setter(setter(Builder::commitMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD,
            TYPE_FIELD, SELECTABLE_VALUES_FIELD, COMMIT_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DropDownControlDisplayOptions displayOptions;

    private final String type;

    private final FilterSelectableValues selectableValues;

    private final String commitMode;

    private DefaultFilterDropDownControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.selectableValues = builder.selectableValues;
        this.commitMode = builder.commitMode;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final DropDownControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     *         </p>
     *         </li>
     * @see SheetControlListType
     */
    public final SheetControlListType type() {
        return SheetControlListType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     *         </p>
     *         </li>
     * @see SheetControlListType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A list of selectable values that are used in a control.
     * </p>
     * 
     * @return A list of selectable values that are used in a control.
     */
    public final FilterSelectableValues selectableValues() {
        return selectableValues;
    }

    /**
     * <p>
     * The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitMode} will
     * return {@link CommitMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitModeAsString}.
     * </p>
     * 
     * @return The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
     * @see CommitMode
     */
    public final CommitMode commitMode() {
        return CommitMode.fromValue(commitMode);
    }

    /**
     * <p>
     * The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitMode} will
     * return {@link CommitMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitModeAsString}.
     * </p>
     * 
     * @return The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
     * @see CommitMode
     */
    public final String commitModeAsString() {
        return commitMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectableValues());
        hashCode = 31 * hashCode + Objects.hashCode(commitModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFilterDropDownControlOptions)) {
            return false;
        }
        DefaultFilterDropDownControlOptions other = (DefaultFilterDropDownControlOptions) obj;
        return Objects.equals(displayOptions(), other.displayOptions()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(selectableValues(), other.selectableValues())
                && Objects.equals(commitModeAsString(), other.commitModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultFilterDropDownControlOptions").add("DisplayOptions", displayOptions())
                .add("Type", typeAsString()).add("SelectableValues", selectableValues()).add("CommitMode", commitModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SelectableValues":
            return Optional.ofNullable(clazz.cast(selectableValues()));
        case "CommitMode":
            return Optional.ofNullable(clazz.cast(commitModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SelectableValues", SELECTABLE_VALUES_FIELD);
        map.put("CommitMode", COMMIT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultFilterDropDownControlOptions, T> g) {
        return obj -> g.apply((DefaultFilterDropDownControlOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultFilterDropDownControlOptions> {
        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(DropDownControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropDownControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link DropDownControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropDownControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(DropDownControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link DropDownControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(DropDownControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<DropDownControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(DropDownControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         *        </p>
         *        </li>
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         *        </p>
         *        </li>
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(SheetControlListType type);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * 
         * @param selectableValues
         *        A list of selectable values that are used in a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectableValues(FilterSelectableValues selectableValues);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterSelectableValues.Builder} avoiding
         * the need to create one manually via {@link FilterSelectableValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterSelectableValues.Builder#build()} is called immediately and
         * its result is passed to {@link #selectableValues(FilterSelectableValues)}.
         * 
         * @param selectableValues
         *        a consumer that will call methods on {@link FilterSelectableValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectableValues(FilterSelectableValues)
         */
        default Builder selectableValues(Consumer<FilterSelectableValues.Builder> selectableValues) {
            return selectableValues(FilterSelectableValues.builder().applyMutation(selectableValues).build());
        }

        /**
         * <p>
         * The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
         * </p>
         * 
         * @param commitMode
         *        The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
         * @see CommitMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitMode
         */
        Builder commitMode(String commitMode);

        /**
         * <p>
         * The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
         * </p>
         * 
         * @param commitMode
         *        The visibility configuration of the Apply button on a <code>FilterDropDownControl</code>.
         * @see CommitMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitMode
         */
        Builder commitMode(CommitMode commitMode);
    }

    static final class BuilderImpl implements Builder {
        private DropDownControlDisplayOptions displayOptions;

        private String type;

        private FilterSelectableValues selectableValues;

        private String commitMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFilterDropDownControlOptions model) {
            displayOptions(model.displayOptions);
            type(model.type);
            selectableValues(model.selectableValues);
            commitMode(model.commitMode);
        }

        public final DropDownControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(DropDownControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(DropDownControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlListType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FilterSelectableValues.Builder getSelectableValues() {
            return selectableValues != null ? selectableValues.toBuilder() : null;
        }

        public final void setSelectableValues(FilterSelectableValues.BuilderImpl selectableValues) {
            this.selectableValues = selectableValues != null ? selectableValues.build() : null;
        }

        @Override
        public final Builder selectableValues(FilterSelectableValues selectableValues) {
            this.selectableValues = selectableValues;
            return this;
        }

        public final String getCommitMode() {
            return commitMode;
        }

        public final void setCommitMode(String commitMode) {
            this.commitMode = commitMode;
        }

        @Override
        public final Builder commitMode(String commitMode) {
            this.commitMode = commitMode;
            return this;
        }

        @Override
        public final Builder commitMode(CommitMode commitMode) {
            this.commitMode(commitMode == null ? null : commitMode.toString());
            return this;
        }

        @Override
        public DefaultFilterDropDownControlOptions build() {
            return new DefaultFilterDropDownControlOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
