/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default options that correspond to the <code>TextField</code> filter control type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultTextFieldControlOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultTextFieldControlOptions.Builder, DefaultTextFieldControlOptions> {
    private static final SdkField<TextFieldControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<TextFieldControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(DefaultTextFieldControlOptions::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(TextFieldControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextFieldControlDisplayOptions displayOptions;

    private DefaultTextFieldControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final TextFieldControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultTextFieldControlOptions)) {
            return false;
        }
        DefaultTextFieldControlOptions other = (DefaultTextFieldControlOptions) obj;
        return Objects.equals(displayOptions(), other.displayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultTextFieldControlOptions").add("DisplayOptions", displayOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultTextFieldControlOptions, T> g) {
        return obj -> g.apply((DefaultTextFieldControlOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultTextFieldControlOptions> {
        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(TextFieldControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextFieldControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link TextFieldControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextFieldControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(TextFieldControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link TextFieldControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(TextFieldControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<TextFieldControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(TextFieldControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextFieldControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultTextFieldControlOptions model) {
            displayOptions(model.displayOptions);
        }

        public final TextFieldControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(TextFieldControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(TextFieldControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        @Override
        public DefaultTextFieldControlOptions build() {
            return new DefaultTextFieldControlOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
