/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for configuring a donut chart or pie chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DonutOptions implements SdkPojo, Serializable, ToCopyableBuilder<DonutOptions.Builder, DonutOptions> {
    private static final SdkField<ArcOptions> ARC_OPTIONS_FIELD = SdkField.<ArcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ArcOptions").getter(getter(DonutOptions::arcOptions)).setter(setter(Builder::arcOptions))
            .constructor(ArcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcOptions").build()).build();

    private static final SdkField<DonutCenterOptions> DONUT_CENTER_OPTIONS_FIELD = SdkField
            .<DonutCenterOptions> builder(MarshallingType.SDK_POJO).memberName("DonutCenterOptions")
            .getter(getter(DonutOptions::donutCenterOptions)).setter(setter(Builder::donutCenterOptions))
            .constructor(DonutCenterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DonutCenterOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARC_OPTIONS_FIELD,
            DONUT_CENTER_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ArcOptions arcOptions;

    private final DonutCenterOptions donutCenterOptions;

    private DonutOptions(BuilderImpl builder) {
        this.arcOptions = builder.arcOptions;
        this.donutCenterOptions = builder.donutCenterOptions;
    }

    /**
     * <p>
     * The option for define the arc of the chart shape. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WHOLE</code> - A pie chart
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SMALL</code>- A small-sized donut chart
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code>- A medium-sized donut chart
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LARGE</code>- A large-sized donut chart
     * </p>
     * </li>
     * </ul>
     * 
     * @return The option for define the arc of the chart shape. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WHOLE</code> - A pie chart
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SMALL</code>- A small-sized donut chart
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code>- A medium-sized donut chart
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LARGE</code>- A large-sized donut chart
     *         </p>
     *         </li>
     */
    public final ArcOptions arcOptions() {
        return arcOptions;
    }

    /**
     * <p>
     * The label options of the label that is displayed in the center of a donut chart. This option isn't available for
     * pie charts.
     * </p>
     * 
     * @return The label options of the label that is displayed in the center of a donut chart. This option isn't
     *         available for pie charts.
     */
    public final DonutCenterOptions donutCenterOptions() {
        return donutCenterOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(donutCenterOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DonutOptions)) {
            return false;
        }
        DonutOptions other = (DonutOptions) obj;
        return Objects.equals(arcOptions(), other.arcOptions())
                && Objects.equals(donutCenterOptions(), other.donutCenterOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DonutOptions").add("ArcOptions", arcOptions()).add("DonutCenterOptions", donutCenterOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArcOptions":
            return Optional.ofNullable(clazz.cast(arcOptions()));
        case "DonutCenterOptions":
            return Optional.ofNullable(clazz.cast(donutCenterOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArcOptions", ARC_OPTIONS_FIELD);
        map.put("DonutCenterOptions", DONUT_CENTER_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DonutOptions, T> g) {
        return obj -> g.apply((DonutOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DonutOptions> {
        /**
         * <p>
         * The option for define the arc of the chart shape. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WHOLE</code> - A pie chart
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMALL</code>- A small-sized donut chart
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code>- A medium-sized donut chart
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LARGE</code>- A large-sized donut chart
         * </p>
         * </li>
         * </ul>
         * 
         * @param arcOptions
         *        The option for define the arc of the chart shape. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WHOLE</code> - A pie chart
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMALL</code>- A small-sized donut chart
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code>- A medium-sized donut chart
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LARGE</code>- A large-sized donut chart
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arcOptions(ArcOptions arcOptions);

        /**
         * <p>
         * The option for define the arc of the chart shape. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WHOLE</code> - A pie chart
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMALL</code>- A small-sized donut chart
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code>- A medium-sized donut chart
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LARGE</code>- A large-sized donut chart
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ArcOptions.Builder} avoiding the need to
         * create one manually via {@link ArcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArcOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #arcOptions(ArcOptions)}.
         * 
         * @param arcOptions
         *        a consumer that will call methods on {@link ArcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arcOptions(ArcOptions)
         */
        default Builder arcOptions(Consumer<ArcOptions.Builder> arcOptions) {
            return arcOptions(ArcOptions.builder().applyMutation(arcOptions).build());
        }

        /**
         * <p>
         * The label options of the label that is displayed in the center of a donut chart. This option isn't available
         * for pie charts.
         * </p>
         * 
         * @param donutCenterOptions
         *        The label options of the label that is displayed in the center of a donut chart. This option isn't
         *        available for pie charts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder donutCenterOptions(DonutCenterOptions donutCenterOptions);

        /**
         * <p>
         * The label options of the label that is displayed in the center of a donut chart. This option isn't available
         * for pie charts.
         * </p>
         * This is a convenience method that creates an instance of the {@link DonutCenterOptions.Builder} avoiding the
         * need to create one manually via {@link DonutCenterOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DonutCenterOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #donutCenterOptions(DonutCenterOptions)}.
         * 
         * @param donutCenterOptions
         *        a consumer that will call methods on {@link DonutCenterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #donutCenterOptions(DonutCenterOptions)
         */
        default Builder donutCenterOptions(Consumer<DonutCenterOptions.Builder> donutCenterOptions) {
            return donutCenterOptions(DonutCenterOptions.builder().applyMutation(donutCenterOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArcOptions arcOptions;

        private DonutCenterOptions donutCenterOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DonutOptions model) {
            arcOptions(model.arcOptions);
            donutCenterOptions(model.donutCenterOptions);
        }

        public final ArcOptions.Builder getArcOptions() {
            return arcOptions != null ? arcOptions.toBuilder() : null;
        }

        public final void setArcOptions(ArcOptions.BuilderImpl arcOptions) {
            this.arcOptions = arcOptions != null ? arcOptions.build() : null;
        }

        @Override
        public final Builder arcOptions(ArcOptions arcOptions) {
            this.arcOptions = arcOptions;
            return this;
        }

        public final DonutCenterOptions.Builder getDonutCenterOptions() {
            return donutCenterOptions != null ? donutCenterOptions.toBuilder() : null;
        }

        public final void setDonutCenterOptions(DonutCenterOptions.BuilderImpl donutCenterOptions) {
            this.donutCenterOptions = donutCenterOptions != null ? donutCenterOptions.build() : null;
        }

        @Override
        public final Builder donutCenterOptions(DonutCenterOptions donutCenterOptions) {
            this.donutCenterOptions = donutCenterOptions;
            return this;
        }

        @Override
        public DonutOptions build() {
            return new DonutOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
