/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color field that defines a gradient or categorical style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLayerColorField implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLayerColorField.Builder, GeospatialLayerColorField> {
    private static final SdkField<List<DimensionField>> COLOR_DIMENSIONS_FIELDS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("ColorDimensionsFields")
            .getter(getter(GeospatialLayerColorField::colorDimensionsFields))
            .setter(setter(Builder::colorDimensionsFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorDimensionsFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> COLOR_VALUES_FIELDS_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("ColorValuesFields")
            .getter(getter(GeospatialLayerColorField::colorValuesFields))
            .setter(setter(Builder::colorValuesFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorValuesFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_DIMENSIONS_FIELDS_FIELD,
            COLOR_VALUES_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> colorDimensionsFields;

    private final List<MeasureField> colorValuesFields;

    private GeospatialLayerColorField(BuilderImpl builder) {
        this.colorDimensionsFields = builder.colorDimensionsFields;
        this.colorValuesFields = builder.colorValuesFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColorDimensionsFields property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasColorDimensionsFields() {
        return colorDimensionsFields != null && !(colorDimensionsFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of color dimension fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColorDimensionsFields} method.
     * </p>
     * 
     * @return A list of color dimension fields.
     */
    public final List<DimensionField> colorDimensionsFields() {
        return colorDimensionsFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColorValuesFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColorValuesFields() {
        return colorValuesFields != null && !(colorValuesFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of color measure fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColorValuesFields} method.
     * </p>
     * 
     * @return A list of color measure fields.
     */
    public final List<MeasureField> colorValuesFields() {
        return colorValuesFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColorDimensionsFields() ? colorDimensionsFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColorValuesFields() ? colorValuesFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerColorField)) {
            return false;
        }
        GeospatialLayerColorField other = (GeospatialLayerColorField) obj;
        return hasColorDimensionsFields() == other.hasColorDimensionsFields()
                && Objects.equals(colorDimensionsFields(), other.colorDimensionsFields())
                && hasColorValuesFields() == other.hasColorValuesFields()
                && Objects.equals(colorValuesFields(), other.colorValuesFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLayerColorField")
                .add("ColorDimensionsFields", hasColorDimensionsFields() ? colorDimensionsFields() : null)
                .add("ColorValuesFields", hasColorValuesFields() ? colorValuesFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColorDimensionsFields":
            return Optional.ofNullable(clazz.cast(colorDimensionsFields()));
        case "ColorValuesFields":
            return Optional.ofNullable(clazz.cast(colorValuesFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColorDimensionsFields", COLOR_DIMENSIONS_FIELDS_FIELD);
        map.put("ColorValuesFields", COLOR_VALUES_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerColorField, T> g) {
        return obj -> g.apply((GeospatialLayerColorField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLayerColorField> {
        /**
         * <p>
         * A list of color dimension fields.
         * </p>
         * 
         * @param colorDimensionsFields
         *        A list of color dimension fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorDimensionsFields(Collection<DimensionField> colorDimensionsFields);

        /**
         * <p>
         * A list of color dimension fields.
         * </p>
         * 
         * @param colorDimensionsFields
         *        A list of color dimension fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorDimensionsFields(DimensionField... colorDimensionsFields);

        /**
         * <p>
         * A list of color dimension fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #colorDimensionsFields(List<DimensionField>)}.
         * 
         * @param colorDimensionsFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorDimensionsFields(java.util.Collection<DimensionField>)
         */
        Builder colorDimensionsFields(Consumer<DimensionField.Builder>... colorDimensionsFields);

        /**
         * <p>
         * A list of color measure fields.
         * </p>
         * 
         * @param colorValuesFields
         *        A list of color measure fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorValuesFields(Collection<MeasureField> colorValuesFields);

        /**
         * <p>
         * A list of color measure fields.
         * </p>
         * 
         * @param colorValuesFields
         *        A list of color measure fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorValuesFields(MeasureField... colorValuesFields);

        /**
         * <p>
         * A list of color measure fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #colorValuesFields(List<MeasureField>)}.
         * 
         * @param colorValuesFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorValuesFields(java.util.Collection<MeasureField>)
         */
        Builder colorValuesFields(Consumer<MeasureField.Builder>... colorValuesFields);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> colorDimensionsFields = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> colorValuesFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerColorField model) {
            colorDimensionsFields(model.colorDimensionsFields);
            colorValuesFields(model.colorValuesFields);
        }

        public final List<DimensionField.Builder> getColorDimensionsFields() {
            List<DimensionField.Builder> result = GeospatialLayerDimensionFieldListCopier
                    .copyToBuilder(this.colorDimensionsFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColorDimensionsFields(Collection<DimensionField.BuilderImpl> colorDimensionsFields) {
            this.colorDimensionsFields = GeospatialLayerDimensionFieldListCopier.copyFromBuilder(colorDimensionsFields);
        }

        @Override
        public final Builder colorDimensionsFields(Collection<DimensionField> colorDimensionsFields) {
            this.colorDimensionsFields = GeospatialLayerDimensionFieldListCopier.copy(colorDimensionsFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorDimensionsFields(DimensionField... colorDimensionsFields) {
            colorDimensionsFields(Arrays.asList(colorDimensionsFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorDimensionsFields(Consumer<DimensionField.Builder>... colorDimensionsFields) {
            colorDimensionsFields(Stream.of(colorDimensionsFields).map(c -> DimensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getColorValuesFields() {
            List<MeasureField.Builder> result = GeospatialLayerMeasureFieldListCopier.copyToBuilder(this.colorValuesFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColorValuesFields(Collection<MeasureField.BuilderImpl> colorValuesFields) {
            this.colorValuesFields = GeospatialLayerMeasureFieldListCopier.copyFromBuilder(colorValuesFields);
        }

        @Override
        public final Builder colorValuesFields(Collection<MeasureField> colorValuesFields) {
            this.colorValuesFields = GeospatialLayerMeasureFieldListCopier.copy(colorValuesFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorValuesFields(MeasureField... colorValuesFields) {
            colorValuesFields(Arrays.asList(colorValuesFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorValuesFields(Consumer<MeasureField.Builder>... colorValuesFields) {
            colorValuesFields(Stream.of(colorValuesFields).map(c -> MeasureField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GeospatialLayerColorField build() {
            return new GeospatialLayerColorField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
