/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>GeospatialMapVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialMapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialMapConfiguration.Builder, GeospatialMapConfiguration> {
    private static final SdkField<GeospatialMapFieldWells> FIELD_WELLS_FIELD = SdkField
            .<GeospatialMapFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(GeospatialMapConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(GeospatialMapFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(GeospatialMapConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(GeospatialMapConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<GeospatialWindowOptions> WINDOW_OPTIONS_FIELD = SdkField
            .<GeospatialWindowOptions> builder(MarshallingType.SDK_POJO).memberName("WindowOptions")
            .getter(getter(GeospatialMapConfiguration::windowOptions)).setter(setter(Builder::windowOptions))
            .constructor(GeospatialWindowOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowOptions").build()).build();

    private static final SdkField<GeospatialMapStyleOptions> MAP_STYLE_OPTIONS_FIELD = SdkField
            .<GeospatialMapStyleOptions> builder(MarshallingType.SDK_POJO).memberName("MapStyleOptions")
            .getter(getter(GeospatialMapConfiguration::mapStyleOptions)).setter(setter(Builder::mapStyleOptions))
            .constructor(GeospatialMapStyleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapStyleOptions").build()).build();

    private static final SdkField<GeospatialPointStyleOptions> POINT_STYLE_OPTIONS_FIELD = SdkField
            .<GeospatialPointStyleOptions> builder(MarshallingType.SDK_POJO).memberName("PointStyleOptions")
            .getter(getter(GeospatialMapConfiguration::pointStyleOptions)).setter(setter(Builder::pointStyleOptions))
            .constructor(GeospatialPointStyleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointStyleOptions").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(GeospatialMapConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(GeospatialMapConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            LEGEND_FIELD, TOOLTIP_FIELD, WINDOW_OPTIONS_FIELD, MAP_STYLE_OPTIONS_FIELD, POINT_STYLE_OPTIONS_FIELD,
            VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialMapFieldWells fieldWells;

    private final LegendOptions legend;

    private final TooltipOptions tooltip;

    private final GeospatialWindowOptions windowOptions;

    private final GeospatialMapStyleOptions mapStyleOptions;

    private final GeospatialPointStyleOptions pointStyleOptions;

    private final VisualPalette visualPalette;

    private final VisualInteractionOptions interactions;

    private GeospatialMapConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.legend = builder.legend;
        this.tooltip = builder.tooltip;
        this.windowOptions = builder.windowOptions;
        this.mapStyleOptions = builder.mapStyleOptions;
        this.pointStyleOptions = builder.pointStyleOptions;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final GeospatialMapFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The window options of the geospatial map.
     * </p>
     * 
     * @return The window options of the geospatial map.
     */
    public final GeospatialWindowOptions windowOptions() {
        return windowOptions;
    }

    /**
     * <p>
     * The map style options of the geospatial map.
     * </p>
     * 
     * @return The map style options of the geospatial map.
     */
    public final GeospatialMapStyleOptions mapStyleOptions() {
        return mapStyleOptions;
    }

    /**
     * <p>
     * The point style options of the geospatial map.
     * </p>
     * 
     * @return The point style options of the geospatial map.
     */
    public final GeospatialPointStyleOptions pointStyleOptions() {
        return pointStyleOptions;
    }

    /**
     * Returns the value of the VisualPalette property for this object.
     * 
     * @return The value of the VisualPalette property for this object.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(windowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(mapStyleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(pointStyleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapConfiguration)) {
            return false;
        }
        GeospatialMapConfiguration other = (GeospatialMapConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(legend(), other.legend())
                && Objects.equals(tooltip(), other.tooltip()) && Objects.equals(windowOptions(), other.windowOptions())
                && Objects.equals(mapStyleOptions(), other.mapStyleOptions())
                && Objects.equals(pointStyleOptions(), other.pointStyleOptions())
                && Objects.equals(visualPalette(), other.visualPalette()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialMapConfiguration").add("FieldWells", fieldWells()).add("Legend", legend())
                .add("Tooltip", tooltip()).add("WindowOptions", windowOptions()).add("MapStyleOptions", mapStyleOptions())
                .add("PointStyleOptions", pointStyleOptions()).add("VisualPalette", visualPalette())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "WindowOptions":
            return Optional.ofNullable(clazz.cast(windowOptions()));
        case "MapStyleOptions":
            return Optional.ofNullable(clazz.cast(mapStyleOptions()));
        case "PointStyleOptions":
            return Optional.ofNullable(clazz.cast(pointStyleOptions()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("WindowOptions", WINDOW_OPTIONS_FIELD);
        map.put("MapStyleOptions", MAP_STYLE_OPTIONS_FIELD);
        map.put("PointStyleOptions", POINT_STYLE_OPTIONS_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapConfiguration, T> g) {
        return obj -> g.apply((GeospatialMapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialMapConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(GeospatialMapFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialMapFieldWells.Builder} avoiding
         * the need to create one manually via {@link GeospatialMapFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapFieldWells.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldWells(GeospatialMapFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link GeospatialMapFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(GeospatialMapFieldWells)
         */
        default Builder fieldWells(Consumer<GeospatialMapFieldWells.Builder> fieldWells) {
            return fieldWells(GeospatialMapFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The window options of the geospatial map.
         * </p>
         * 
         * @param windowOptions
         *        The window options of the geospatial map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowOptions(GeospatialWindowOptions windowOptions);

        /**
         * <p>
         * The window options of the geospatial map.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialWindowOptions.Builder} avoiding
         * the need to create one manually via {@link GeospatialWindowOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialWindowOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #windowOptions(GeospatialWindowOptions)}.
         * 
         * @param windowOptions
         *        a consumer that will call methods on {@link GeospatialWindowOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowOptions(GeospatialWindowOptions)
         */
        default Builder windowOptions(Consumer<GeospatialWindowOptions.Builder> windowOptions) {
            return windowOptions(GeospatialWindowOptions.builder().applyMutation(windowOptions).build());
        }

        /**
         * <p>
         * The map style options of the geospatial map.
         * </p>
         * 
         * @param mapStyleOptions
         *        The map style options of the geospatial map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapStyleOptions(GeospatialMapStyleOptions mapStyleOptions);

        /**
         * <p>
         * The map style options of the geospatial map.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialMapStyleOptions.Builder}
         * avoiding the need to create one manually via {@link GeospatialMapStyleOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapStyleOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #mapStyleOptions(GeospatialMapStyleOptions)}.
         * 
         * @param mapStyleOptions
         *        a consumer that will call methods on {@link GeospatialMapStyleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapStyleOptions(GeospatialMapStyleOptions)
         */
        default Builder mapStyleOptions(Consumer<GeospatialMapStyleOptions.Builder> mapStyleOptions) {
            return mapStyleOptions(GeospatialMapStyleOptions.builder().applyMutation(mapStyleOptions).build());
        }

        /**
         * <p>
         * The point style options of the geospatial map.
         * </p>
         * 
         * @param pointStyleOptions
         *        The point style options of the geospatial map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointStyleOptions(GeospatialPointStyleOptions pointStyleOptions);

        /**
         * <p>
         * The point style options of the geospatial map.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialPointStyleOptions.Builder}
         * avoiding the need to create one manually via {@link GeospatialPointStyleOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialPointStyleOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #pointStyleOptions(GeospatialPointStyleOptions)}.
         * 
         * @param pointStyleOptions
         *        a consumer that will call methods on {@link GeospatialPointStyleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointStyleOptions(GeospatialPointStyleOptions)
         */
        default Builder pointStyleOptions(Consumer<GeospatialPointStyleOptions.Builder> pointStyleOptions) {
            return pointStyleOptions(GeospatialPointStyleOptions.builder().applyMutation(pointStyleOptions).build());
        }

        /**
         * Sets the value of the VisualPalette property for this object.
         *
         * @param visualPalette
         *        The new value for the VisualPalette property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * Sets the value of the VisualPalette property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialMapFieldWells fieldWells;

        private LegendOptions legend;

        private TooltipOptions tooltip;

        private GeospatialWindowOptions windowOptions;

        private GeospatialMapStyleOptions mapStyleOptions;

        private GeospatialPointStyleOptions pointStyleOptions;

        private VisualPalette visualPalette;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapConfiguration model) {
            fieldWells(model.fieldWells);
            legend(model.legend);
            tooltip(model.tooltip);
            windowOptions(model.windowOptions);
            mapStyleOptions(model.mapStyleOptions);
            pointStyleOptions(model.pointStyleOptions);
            visualPalette(model.visualPalette);
            interactions(model.interactions);
        }

        public final GeospatialMapFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(GeospatialMapFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(GeospatialMapFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final GeospatialWindowOptions.Builder getWindowOptions() {
            return windowOptions != null ? windowOptions.toBuilder() : null;
        }

        public final void setWindowOptions(GeospatialWindowOptions.BuilderImpl windowOptions) {
            this.windowOptions = windowOptions != null ? windowOptions.build() : null;
        }

        @Override
        public final Builder windowOptions(GeospatialWindowOptions windowOptions) {
            this.windowOptions = windowOptions;
            return this;
        }

        public final GeospatialMapStyleOptions.Builder getMapStyleOptions() {
            return mapStyleOptions != null ? mapStyleOptions.toBuilder() : null;
        }

        public final void setMapStyleOptions(GeospatialMapStyleOptions.BuilderImpl mapStyleOptions) {
            this.mapStyleOptions = mapStyleOptions != null ? mapStyleOptions.build() : null;
        }

        @Override
        public final Builder mapStyleOptions(GeospatialMapStyleOptions mapStyleOptions) {
            this.mapStyleOptions = mapStyleOptions;
            return this;
        }

        public final GeospatialPointStyleOptions.Builder getPointStyleOptions() {
            return pointStyleOptions != null ? pointStyleOptions.toBuilder() : null;
        }

        public final void setPointStyleOptions(GeospatialPointStyleOptions.BuilderImpl pointStyleOptions) {
            this.pointStyleOptions = pointStyleOptions != null ? pointStyleOptions.build() : null;
        }

        @Override
        public final Builder pointStyleOptions(GeospatialPointStyleOptions pointStyleOptions) {
            this.pointStyleOptions = pointStyleOptions;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public GeospatialMapConfiguration build() {
            return new GeospatialMapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
