/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration of a heat map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeatMapSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HeatMapSortConfiguration.Builder, HeatMapSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> HEAT_MAP_ROW_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("HeatMapRowSort")
            .getter(getter(HeatMapSortConfiguration::heatMapRowSort))
            .setter(setter(Builder::heatMapRowSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapRowSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FieldSortOptions>> HEAT_MAP_COLUMN_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("HeatMapColumnSort")
            .getter(getter(HeatMapSortConfiguration::heatMapColumnSort))
            .setter(setter(Builder::heatMapColumnSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapColumnSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ItemsLimitConfiguration> HEAT_MAP_ROW_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("HeatMapRowItemsLimitConfiguration")
            .getter(getter(HeatMapSortConfiguration::heatMapRowItemsLimitConfiguration))
            .setter(setter(Builder::heatMapRowItemsLimitConfiguration))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapRowItemsLimitConfiguration")
                    .build()).build();

    private static final SdkField<ItemsLimitConfiguration> HEAT_MAP_COLUMN_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("HeatMapColumnItemsLimitConfiguration")
            .getter(getter(HeatMapSortConfiguration::heatMapColumnItemsLimitConfiguration))
            .setter(setter(Builder::heatMapColumnItemsLimitConfiguration))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HeatMapColumnItemsLimitConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEAT_MAP_ROW_SORT_FIELD,
            HEAT_MAP_COLUMN_SORT_FIELD, HEAT_MAP_ROW_ITEMS_LIMIT_CONFIGURATION_FIELD,
            HEAT_MAP_COLUMN_ITEMS_LIMIT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> heatMapRowSort;

    private final List<FieldSortOptions> heatMapColumnSort;

    private final ItemsLimitConfiguration heatMapRowItemsLimitConfiguration;

    private final ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration;

    private HeatMapSortConfiguration(BuilderImpl builder) {
        this.heatMapRowSort = builder.heatMapRowSort;
        this.heatMapColumnSort = builder.heatMapColumnSort;
        this.heatMapRowItemsLimitConfiguration = builder.heatMapRowItemsLimitConfiguration;
        this.heatMapColumnItemsLimitConfiguration = builder.heatMapColumnItemsLimitConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeatMapRowSort property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeatMapRowSort() {
        return heatMapRowSort != null && !(heatMapRowSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field sort configuration of the rows fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeatMapRowSort} method.
     * </p>
     * 
     * @return The field sort configuration of the rows fields.
     */
    public final List<FieldSortOptions> heatMapRowSort() {
        return heatMapRowSort;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeatMapColumnSort property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeatMapColumnSort() {
        return heatMapColumnSort != null && !(heatMapColumnSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column sort configuration for heat map for columns that aren't a part of a field well.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeatMapColumnSort} method.
     * </p>
     * 
     * @return The column sort configuration for heat map for columns that aren't a part of a field well.
     */
    public final List<FieldSortOptions> heatMapColumnSort() {
        return heatMapColumnSort;
    }

    /**
     * <p>
     * The limit on the number of rows that are displayed in a heat map.
     * </p>
     * 
     * @return The limit on the number of rows that are displayed in a heat map.
     */
    public final ItemsLimitConfiguration heatMapRowItemsLimitConfiguration() {
        return heatMapRowItemsLimitConfiguration;
    }

    /**
     * <p>
     * The limit on the number of columns that are displayed in a heat map.
     * </p>
     * 
     * @return The limit on the number of columns that are displayed in a heat map.
     */
    public final ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration() {
        return heatMapColumnItemsLimitConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeatMapRowSort() ? heatMapRowSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHeatMapColumnSort() ? heatMapColumnSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(heatMapRowItemsLimitConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(heatMapColumnItemsLimitConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeatMapSortConfiguration)) {
            return false;
        }
        HeatMapSortConfiguration other = (HeatMapSortConfiguration) obj;
        return hasHeatMapRowSort() == other.hasHeatMapRowSort() && Objects.equals(heatMapRowSort(), other.heatMapRowSort())
                && hasHeatMapColumnSort() == other.hasHeatMapColumnSort()
                && Objects.equals(heatMapColumnSort(), other.heatMapColumnSort())
                && Objects.equals(heatMapRowItemsLimitConfiguration(), other.heatMapRowItemsLimitConfiguration())
                && Objects.equals(heatMapColumnItemsLimitConfiguration(), other.heatMapColumnItemsLimitConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeatMapSortConfiguration").add("HeatMapRowSort", hasHeatMapRowSort() ? heatMapRowSort() : null)
                .add("HeatMapColumnSort", hasHeatMapColumnSort() ? heatMapColumnSort() : null)
                .add("HeatMapRowItemsLimitConfiguration", heatMapRowItemsLimitConfiguration())
                .add("HeatMapColumnItemsLimitConfiguration", heatMapColumnItemsLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeatMapRowSort":
            return Optional.ofNullable(clazz.cast(heatMapRowSort()));
        case "HeatMapColumnSort":
            return Optional.ofNullable(clazz.cast(heatMapColumnSort()));
        case "HeatMapRowItemsLimitConfiguration":
            return Optional.ofNullable(clazz.cast(heatMapRowItemsLimitConfiguration()));
        case "HeatMapColumnItemsLimitConfiguration":
            return Optional.ofNullable(clazz.cast(heatMapColumnItemsLimitConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HeatMapRowSort", HEAT_MAP_ROW_SORT_FIELD);
        map.put("HeatMapColumnSort", HEAT_MAP_COLUMN_SORT_FIELD);
        map.put("HeatMapRowItemsLimitConfiguration", HEAT_MAP_ROW_ITEMS_LIMIT_CONFIGURATION_FIELD);
        map.put("HeatMapColumnItemsLimitConfiguration", HEAT_MAP_COLUMN_ITEMS_LIMIT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeatMapSortConfiguration, T> g) {
        return obj -> g.apply((HeatMapSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeatMapSortConfiguration> {
        /**
         * <p>
         * The field sort configuration of the rows fields.
         * </p>
         * 
         * @param heatMapRowSort
         *        The field sort configuration of the rows fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapRowSort(Collection<FieldSortOptions> heatMapRowSort);

        /**
         * <p>
         * The field sort configuration of the rows fields.
         * </p>
         * 
         * @param heatMapRowSort
         *        The field sort configuration of the rows fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapRowSort(FieldSortOptions... heatMapRowSort);

        /**
         * <p>
         * The field sort configuration of the rows fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #heatMapRowSort(List<FieldSortOptions>)}.
         * 
         * @param heatMapRowSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatMapRowSort(java.util.Collection<FieldSortOptions>)
         */
        Builder heatMapRowSort(Consumer<FieldSortOptions.Builder>... heatMapRowSort);

        /**
         * <p>
         * The column sort configuration for heat map for columns that aren't a part of a field well.
         * </p>
         * 
         * @param heatMapColumnSort
         *        The column sort configuration for heat map for columns that aren't a part of a field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapColumnSort(Collection<FieldSortOptions> heatMapColumnSort);

        /**
         * <p>
         * The column sort configuration for heat map for columns that aren't a part of a field well.
         * </p>
         * 
         * @param heatMapColumnSort
         *        The column sort configuration for heat map for columns that aren't a part of a field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapColumnSort(FieldSortOptions... heatMapColumnSort);

        /**
         * <p>
         * The column sort configuration for heat map for columns that aren't a part of a field well.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #heatMapColumnSort(List<FieldSortOptions>)}.
         * 
         * @param heatMapColumnSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatMapColumnSort(java.util.Collection<FieldSortOptions>)
         */
        Builder heatMapColumnSort(Consumer<FieldSortOptions.Builder>... heatMapColumnSort);

        /**
         * <p>
         * The limit on the number of rows that are displayed in a heat map.
         * </p>
         * 
         * @param heatMapRowItemsLimitConfiguration
         *        The limit on the number of rows that are displayed in a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration heatMapRowItemsLimitConfiguration);

        /**
         * <p>
         * The limit on the number of rows that are displayed in a heat map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration)}.
         * 
         * @param heatMapRowItemsLimitConfiguration
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration)
         */
        default Builder heatMapRowItemsLimitConfiguration(
                Consumer<ItemsLimitConfiguration.Builder> heatMapRowItemsLimitConfiguration) {
            return heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration.builder()
                    .applyMutation(heatMapRowItemsLimitConfiguration).build());
        }

        /**
         * <p>
         * The limit on the number of columns that are displayed in a heat map.
         * </p>
         * 
         * @param heatMapColumnItemsLimitConfiguration
         *        The limit on the number of columns that are displayed in a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration);

        /**
         * <p>
         * The limit on the number of columns that are displayed in a heat map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration)}.
         * 
         * @param heatMapColumnItemsLimitConfiguration
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration)
         */
        default Builder heatMapColumnItemsLimitConfiguration(
                Consumer<ItemsLimitConfiguration.Builder> heatMapColumnItemsLimitConfiguration) {
            return heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration.builder()
                    .applyMutation(heatMapColumnItemsLimitConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> heatMapRowSort = DefaultSdkAutoConstructList.getInstance();

        private List<FieldSortOptions> heatMapColumnSort = DefaultSdkAutoConstructList.getInstance();

        private ItemsLimitConfiguration heatMapRowItemsLimitConfiguration;

        private ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HeatMapSortConfiguration model) {
            heatMapRowSort(model.heatMapRowSort);
            heatMapColumnSort(model.heatMapColumnSort);
            heatMapRowItemsLimitConfiguration(model.heatMapRowItemsLimitConfiguration);
            heatMapColumnItemsLimitConfiguration(model.heatMapColumnItemsLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getHeatMapRowSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.heatMapRowSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeatMapRowSort(Collection<FieldSortOptions.BuilderImpl> heatMapRowSort) {
            this.heatMapRowSort = FieldSortOptionsListCopier.copyFromBuilder(heatMapRowSort);
        }

        @Override
        public final Builder heatMapRowSort(Collection<FieldSortOptions> heatMapRowSort) {
            this.heatMapRowSort = FieldSortOptionsListCopier.copy(heatMapRowSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapRowSort(FieldSortOptions... heatMapRowSort) {
            heatMapRowSort(Arrays.asList(heatMapRowSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapRowSort(Consumer<FieldSortOptions.Builder>... heatMapRowSort) {
            heatMapRowSort(Stream.of(heatMapRowSort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FieldSortOptions.Builder> getHeatMapColumnSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.heatMapColumnSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeatMapColumnSort(Collection<FieldSortOptions.BuilderImpl> heatMapColumnSort) {
            this.heatMapColumnSort = FieldSortOptionsListCopier.copyFromBuilder(heatMapColumnSort);
        }

        @Override
        public final Builder heatMapColumnSort(Collection<FieldSortOptions> heatMapColumnSort) {
            this.heatMapColumnSort = FieldSortOptionsListCopier.copy(heatMapColumnSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapColumnSort(FieldSortOptions... heatMapColumnSort) {
            heatMapColumnSort(Arrays.asList(heatMapColumnSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapColumnSort(Consumer<FieldSortOptions.Builder>... heatMapColumnSort) {
            heatMapColumnSort(Stream.of(heatMapColumnSort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getHeatMapRowItemsLimitConfiguration() {
            return heatMapRowItemsLimitConfiguration != null ? heatMapRowItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setHeatMapRowItemsLimitConfiguration(
                ItemsLimitConfiguration.BuilderImpl heatMapRowItemsLimitConfiguration) {
            this.heatMapRowItemsLimitConfiguration = heatMapRowItemsLimitConfiguration != null ? heatMapRowItemsLimitConfiguration
                    .build() : null;
        }

        @Override
        public final Builder heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration heatMapRowItemsLimitConfiguration) {
            this.heatMapRowItemsLimitConfiguration = heatMapRowItemsLimitConfiguration;
            return this;
        }

        public final ItemsLimitConfiguration.Builder getHeatMapColumnItemsLimitConfiguration() {
            return heatMapColumnItemsLimitConfiguration != null ? heatMapColumnItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setHeatMapColumnItemsLimitConfiguration(
                ItemsLimitConfiguration.BuilderImpl heatMapColumnItemsLimitConfiguration) {
            this.heatMapColumnItemsLimitConfiguration = heatMapColumnItemsLimitConfiguration != null ? heatMapColumnItemsLimitConfiguration
                    .build() : null;
        }

        @Override
        public final Builder heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration) {
            this.heatMapColumnItemsLimitConfiguration = heatMapColumnItemsLimitConfiguration;
            return this;
        }

        @Override
        public HeatMapSortConfiguration build() {
            return new HeatMapSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
