/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A layer map visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayerMapVisual implements SdkPojo, Serializable, ToCopyableBuilder<LayerMapVisual.Builder, LayerMapVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(LayerMapVisual::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField
            .<VisualTitleLabelOptions> builder(MarshallingType.SDK_POJO).memberName("Title")
            .getter(getter(LayerMapVisual::title)).setter(setter(Builder::title)).constructor(VisualTitleLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField
            .<VisualSubtitleLabelOptions> builder(MarshallingType.SDK_POJO).memberName("Subtitle")
            .getter(getter(LayerMapVisual::subtitle)).setter(setter(Builder::subtitle))
            .constructor(VisualSubtitleLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()).build();

    private static final SdkField<GeospatialLayerMapConfiguration> CHART_CONFIGURATION_FIELD = SdkField
            .<GeospatialLayerMapConfiguration> builder(MarshallingType.SDK_POJO).memberName("ChartConfiguration")
            .getter(getter(LayerMapVisual::chartConfiguration)).setter(setter(Builder::chartConfiguration))
            .constructor(GeospatialLayerMapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartConfiguration").build())
            .build();

    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetIdentifier").getter(getter(LayerMapVisual::dataSetIdentifier))
            .setter(setter(Builder::dataSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()).build();

    private static final SdkField<String> VISUAL_CONTENT_ALT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualContentAltText").getter(getter(LayerMapVisual::visualContentAltText))
            .setter(setter(Builder::visualContentAltText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualContentAltText").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, TITLE_FIELD,
            SUBTITLE_FIELD, CHART_CONFIGURATION_FIELD, DATA_SET_IDENTIFIER_FIELD, VISUAL_CONTENT_ALT_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visualId;

    private final VisualTitleLabelOptions title;

    private final VisualSubtitleLabelOptions subtitle;

    private final GeospatialLayerMapConfiguration chartConfiguration;

    private final String dataSetIdentifier;

    private final String visualContentAltText;

    private LayerMapVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.chartConfiguration = builder.chartConfiguration;
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.visualContentAltText = builder.visualContentAltText;
    }

    /**
     * <p>
     * The ID of the visual.
     * </p>
     * 
     * @return The ID of the visual.
     */
    public final String visualId() {
        return visualId;
    }

    /**
     * Returns the value of the Title property for this object.
     * 
     * @return The value of the Title property for this object.
     */
    public final VisualTitleLabelOptions title() {
        return title;
    }

    /**
     * Returns the value of the Subtitle property for this object.
     * 
     * @return The value of the Subtitle property for this object.
     */
    public final VisualSubtitleLabelOptions subtitle() {
        return subtitle;
    }

    /**
     * <p>
     * The configuration settings of the visual.
     * </p>
     * 
     * @return The configuration settings of the visual.
     */
    public final GeospatialLayerMapConfiguration chartConfiguration() {
        return chartConfiguration;
    }

    /**
     * <p>
     * The dataset that is used to create the layer map visual. You can't create a visual without a dataset.
     * </p>
     * 
     * @return The dataset that is used to create the layer map visual. You can't create a visual without a dataset.
     */
    public final String dataSetIdentifier() {
        return dataSetIdentifier;
    }

    /**
     * <p>
     * The alt text for the visual.
     * </p>
     * 
     * @return The alt text for the visual.
     */
    public final String visualContentAltText() {
        return visualContentAltText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(chartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(visualContentAltText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerMapVisual)) {
            return false;
        }
        LayerMapVisual other = (LayerMapVisual) obj;
        return Objects.equals(visualId(), other.visualId()) && Objects.equals(title(), other.title())
                && Objects.equals(subtitle(), other.subtitle())
                && Objects.equals(chartConfiguration(), other.chartConfiguration())
                && Objects.equals(dataSetIdentifier(), other.dataSetIdentifier())
                && Objects.equals(visualContentAltText(), other.visualContentAltText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayerMapVisual").add("VisualId", visualId()).add("Title", title()).add("Subtitle", subtitle())
                .add("ChartConfiguration", chartConfiguration()).add("DataSetIdentifier", dataSetIdentifier())
                .add("VisualContentAltText", visualContentAltText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "ChartConfiguration":
            return Optional.ofNullable(clazz.cast(chartConfiguration()));
        case "DataSetIdentifier":
            return Optional.ofNullable(clazz.cast(dataSetIdentifier()));
        case "VisualContentAltText":
            return Optional.ofNullable(clazz.cast(visualContentAltText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VisualId", VISUAL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Subtitle", SUBTITLE_FIELD);
        map.put("ChartConfiguration", CHART_CONFIGURATION_FIELD);
        map.put("DataSetIdentifier", DATA_SET_IDENTIFIER_FIELD);
        map.put("VisualContentAltText", VISUAL_CONTENT_ALT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayerMapVisual, T> g) {
        return obj -> g.apply((LayerMapVisual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayerMapVisual> {
        /**
         * <p>
         * The ID of the visual.
         * </p>
         * 
         * @param visualId
         *        The ID of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);

        /**
         * Sets the value of the Title property for this object.
         *
         * @param title
         *        The new value for the Title property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(VisualTitleLabelOptions title);

        /**
         * Sets the value of the Title property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualTitleLabelOptions.Builder} avoiding
         * the need to create one manually via {@link VisualTitleLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualTitleLabelOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #title(VisualTitleLabelOptions)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link VisualTitleLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(VisualTitleLabelOptions)
         */
        default Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return title(VisualTitleLabelOptions.builder().applyMutation(title).build());
        }

        /**
         * Sets the value of the Subtitle property for this object.
         *
         * @param subtitle
         *        The new value for the Subtitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(VisualSubtitleLabelOptions subtitle);

        /**
         * Sets the value of the Subtitle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualSubtitleLabelOptions.Builder}
         * avoiding the need to create one manually via {@link VisualSubtitleLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualSubtitleLabelOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #subtitle(VisualSubtitleLabelOptions)}.
         * 
         * @param subtitle
         *        a consumer that will call methods on {@link VisualSubtitleLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subtitle(VisualSubtitleLabelOptions)
         */
        default Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return subtitle(VisualSubtitleLabelOptions.builder().applyMutation(subtitle).build());
        }

        /**
         * <p>
         * The configuration settings of the visual.
         * </p>
         * 
         * @param chartConfiguration
         *        The configuration settings of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chartConfiguration(GeospatialLayerMapConfiguration chartConfiguration);

        /**
         * <p>
         * The configuration settings of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLayerMapConfiguration.Builder}
         * avoiding the need to create one manually via {@link GeospatialLayerMapConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLayerMapConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chartConfiguration(GeospatialLayerMapConfiguration)}.
         * 
         * @param chartConfiguration
         *        a consumer that will call methods on {@link GeospatialLayerMapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chartConfiguration(GeospatialLayerMapConfiguration)
         */
        default Builder chartConfiguration(Consumer<GeospatialLayerMapConfiguration.Builder> chartConfiguration) {
            return chartConfiguration(GeospatialLayerMapConfiguration.builder().applyMutation(chartConfiguration).build());
        }

        /**
         * <p>
         * The dataset that is used to create the layer map visual. You can't create a visual without a dataset.
         * </p>
         * 
         * @param dataSetIdentifier
         *        The dataset that is used to create the layer map visual. You can't create a visual without a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifier(String dataSetIdentifier);

        /**
         * <p>
         * The alt text for the visual.
         * </p>
         * 
         * @param visualContentAltText
         *        The alt text for the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualContentAltText(String visualContentAltText);
    }

    static final class BuilderImpl implements Builder {
        private String visualId;

        private VisualTitleLabelOptions title;

        private VisualSubtitleLabelOptions subtitle;

        private GeospatialLayerMapConfiguration chartConfiguration;

        private String dataSetIdentifier;

        private String visualContentAltText;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerMapVisual model) {
            visualId(model.visualId);
            title(model.title);
            subtitle(model.subtitle);
            chartConfiguration(model.chartConfiguration);
            dataSetIdentifier(model.dataSetIdentifier);
            visualContentAltText(model.visualContentAltText);
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return title != null ? title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return subtitle != null ? subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final GeospatialLayerMapConfiguration.Builder getChartConfiguration() {
            return chartConfiguration != null ? chartConfiguration.toBuilder() : null;
        }

        public final void setChartConfiguration(GeospatialLayerMapConfiguration.BuilderImpl chartConfiguration) {
            this.chartConfiguration = chartConfiguration != null ? chartConfiguration.build() : null;
        }

        @Override
        public final Builder chartConfiguration(GeospatialLayerMapConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
            return this;
        }

        public final String getDataSetIdentifier() {
            return dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final String getVisualContentAltText() {
            return visualContentAltText;
        }

        public final void setVisualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
        }

        @Override
        public final Builder visualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
            return this;
        }

        @Override
        public LayerMapVisual build() {
            return new LayerMapVisual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
